/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.util.FramedUtils;

public class SlopeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        if (SideSkipPredicate.CTM.test(level, pos, state, adjState, side)) {
            return true;
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = FramedUtils.getBlockFacing(state);
            SlopeType type = FramedUtils.getSlopeType(state);
            return switch (blockType) {
                case BlockType.FRAMED_SLOPE, BlockType.FRAMED_RAIL_SLOPE -> SlopeSkipPredicate.testAgainstSlope(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE -> SlopeSkipPredicate.testAgainstDoubleSlope(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_CORNER_SLOPE -> SlopeSkipPredicate.testAgainstCorner(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_CORNER -> SlopeSkipPredicate.testAgainstDoubleCorner(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_PRISM_CORNER, BlockType.FRAMED_DOUBLE_THREEWAY_CORNER -> SlopeSkipPredicate.testAgainstDoubleThreewayCorner(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE -> SlopeSkipPredicate.testAgainstInnerCorner(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_PRISM_CORNER, BlockType.FRAMED_THREEWAY_CORNER -> SlopeSkipPredicate.testAgainstThreewayCorner(level, pos, dir, type, adjState, side);
                case BlockType.FRAMED_INNER_PRISM_CORNER, BlockType.FRAMED_INNER_THREEWAY_CORNER -> SlopeSkipPredicate.testAgainstInnerThreewayCorner(level, pos, dir, type, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstSlope(BlockGetter level, BlockPos pos, Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = FramedUtils.getBlockFacing(adjState);
        SlopeType adjType = FramedUtils.getSlopeType(adjState);
        if (type == SlopeType.HORIZONTAL && Utils.isY(side)) {
            return dir == adjDir && type == adjType && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (type != SlopeType.HORIZONTAL && (side == dir.m_122427_() || side == dir.m_122428_())) {
            return dir == adjDir && type == adjType && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlope(BlockGetter level, BlockPos pos, Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.m_61143_(PropertyHolder.SLOPE_TYPE));
        if (type == SlopeType.HORIZONTAL && adjType == SlopeType.HORIZONTAL && Utils.isY(side)) {
            return (dir == adjDir || adjDir == dir.m_122424_()) && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (type != SlopeType.HORIZONTAL && adjType != SlopeType.HORIZONTAL && (side == dir.m_122427_() || side == dir.m_122428_())) {
            return dir == adjDir && type == adjType || dir.m_122424_() == adjDir && type != adjType && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (side == dir.m_122427_() && adjDir == dir) {
            if (type == SlopeType.BOTTOM && (adjType == CornerType.BOTTOM || adjType == CornerType.HORIZONTAL_BOTTOM_LEFT)) {
                return SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
            if (type == SlopeType.TOP && (adjType == CornerType.TOP || adjType == CornerType.HORIZONTAL_TOP_LEFT)) {
                return SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
        } else if (side == dir.m_122428_()) {
            if (adjDir == dir) {
                if (type == SlopeType.BOTTOM && adjType == CornerType.HORIZONTAL_BOTTOM_RIGHT) {
                    return SideSkipPredicate.compareState(level, pos, side, dir, dir);
                }
                if (type == SlopeType.TOP && adjType == CornerType.HORIZONTAL_TOP_RIGHT) {
                    return SideSkipPredicate.compareState(level, pos, side, dir, dir);
                }
            } else if (adjDir == dir.m_122427_()) {
                if (type == SlopeType.BOTTOM && adjType == CornerType.BOTTOM) {
                    return SideSkipPredicate.compareState(level, pos, side, dir, dir);
                }
                if (type == SlopeType.TOP && adjType == CornerType.TOP) {
                    return SideSkipPredicate.compareState(level, pos, side, dir, dir);
                }
            }
        } else if (Utils.isY(side) && type == SlopeType.HORIZONTAL && side == Direction.UP != adjType.isTop()) {
            if (adjType.isRight()) {
                return dir == adjDir.m_122427_() && SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
            return dir == adjDir && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstDoubleCorner(BlockGetter level, BlockPos pos, Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (adjType.isHorizontal()) {
            if (type == SlopeType.HORIZONTAL && (side == Direction.DOWN && !adjType.isTop() || side == Direction.UP && adjType.isTop())) {
                if (!(adjDir != dir && adjDir != dir.m_122424_() || adjType.isRight())) {
                    return SideSkipPredicate.compareState(level, pos, side, dir, dir);
                }
                if ((adjDir == dir.m_122427_() || adjDir == dir.m_122428_()) && adjType.isRight()) {
                    Direction camoSide = adjDir == dir.m_122427_() ? adjDir.m_122424_() : dir;
                    return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
                }
            } else {
                if (type != SlopeType.HORIZONTAL && adjDir == dir && (side == dir.m_122428_() && !adjType.isRight() || side == dir.m_122427_() && adjType.isRight())) {
                    return type == SlopeType.TOP == adjType.isTop() && SideSkipPredicate.compareState(level, pos, side, dir, dir);
                }
                if (type != SlopeType.HORIZONTAL && (side == dir.m_122427_() && !adjType.isRight() || side == dir.m_122428_() && adjType.isRight())) {
                    return adjDir == dir.m_122424_() && type == SlopeType.TOP != adjType.isTop() && SideSkipPredicate.compareState(level, pos, side, dir, dir);
                }
            }
        } else {
            if (side == dir.m_122428_() && adjDir == dir || side == dir.m_122427_() && adjDir == dir.m_122427_()) {
                return type == SlopeType.TOP == adjType.isTop() && SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
            if (side == dir.m_122427_() && adjDir == dir.m_122424_() || side == dir.m_122428_() && adjDir == dir.m_122428_()) {
                Direction face = adjType.isTop() ? Direction.DOWN : Direction.UP;
                return type == SlopeType.TOP != adjType.isTop() && SideSkipPredicate.compareState(level, pos, side, face, face);
            }
        }
        return false;
    }

    private static boolean testAgainstDoubleThreewayCorner(BlockGetter level, BlockPos pos, Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (type != SlopeType.HORIZONTAL) {
            if (type == SlopeType.TOP == adjTop && (side == dir.m_122428_() && adjDir == dir || side == dir.m_122427_() && adjDir == dir.m_122427_())) {
                return SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
            if (type == SlopeType.TOP != adjTop && (side == dir.m_122428_() && adjDir == dir.m_122428_() || side == dir.m_122427_() && adjDir == dir.m_122424_())) {
                return SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
        } else if ((adjDir == dir || adjDir == dir.m_122424_()) && (side == Direction.DOWN && !adjTop || side == Direction.UP && adjTop)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstInnerCorner(BlockGetter level, BlockPos pos, Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (side == dir.m_122427_()) {
            if (adjDir == dir) {
                if (type == SlopeType.BOTTOM && adjType == CornerType.HORIZONTAL_BOTTOM_RIGHT) {
                    return SideSkipPredicate.compareState(level, pos, side, dir, dir);
                }
                if (type == SlopeType.TOP && adjType == CornerType.HORIZONTAL_TOP_RIGHT) {
                    return SideSkipPredicate.compareState(level, pos, side, dir, dir);
                }
            } else if (adjDir == dir.m_122427_()) {
                if (type == SlopeType.BOTTOM && adjType == CornerType.BOTTOM) {
                    return SideSkipPredicate.compareState(level, pos, side, dir, dir);
                }
                if (type == SlopeType.TOP && adjType == CornerType.TOP) {
                    return SideSkipPredicate.compareState(level, pos, side, dir, dir);
                }
            }
        } else if (side == dir.m_122428_() && adjDir == dir) {
            if (type == SlopeType.BOTTOM && (adjType == CornerType.BOTTOM || adjType == CornerType.HORIZONTAL_BOTTOM_LEFT)) {
                return SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
            if (type == SlopeType.TOP && (adjType == CornerType.TOP || adjType == CornerType.HORIZONTAL_TOP_LEFT)) {
                return SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
        } else if (Utils.isY(side) && type == SlopeType.HORIZONTAL && side == Direction.UP == adjType.isTop()) {
            if (adjType.isRight()) {
                return dir == adjDir.m_122427_() && SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
            return dir == adjDir && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstThreewayCorner(BlockGetter level, BlockPos pos, Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (type != SlopeType.HORIZONTAL && adjTop == (type == SlopeType.TOP)) {
            if (side == dir.m_122427_()) {
                return dir == adjDir && SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
            if (side == dir.m_122428_()) {
                return adjDir == dir.m_122427_() && SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
        } else if (type == SlopeType.HORIZONTAL && Utils.isY(side) && adjTop == (side == Direction.DOWN)) {
            return dir == adjDir && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstInnerThreewayCorner(BlockGetter level, BlockPos pos, Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (type != SlopeType.HORIZONTAL && adjTop == (type == SlopeType.TOP)) {
            if (side == dir.m_122427_()) {
                return adjDir == dir.m_122427_() && SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
            if (side == dir.m_122428_()) {
                return dir == adjDir && SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
        } else if (type == SlopeType.HORIZONTAL && Utils.isY(side) && adjTop == (side == Direction.UP)) {
            return dir == adjDir && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }
}

