/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;

public class ElevatedSlopeSlabSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        if (side == dir || top && side == Direction.UP || !top && side == Direction.DOWN) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB, BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstDoubleSlab(level, pos, dir, top, side);
                case BlockType.FRAMED_SLAB_EDGE -> ElevatedSlopeSlabSkipPredicate.testAgainstSlabEdge(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> ElevatedSlopeSlabSkipPredicate.testAgainstStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> ElevatedSlopeSlabSkipPredicate.testAgainstDoubleStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> ElevatedSlopeSlabSkipPredicate.testAgainstVerticalHalfStairs(level, pos, dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop != top) {
            return false;
        }
        if (side == dir.m_122427_() || side == dir.m_122428_()) {
            return adjDir == dir && SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == dir.m_122424_()) {
            return adjDir == dir.m_122424_() && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        return side == dir.m_122424_() && adjDir == dir && adjTopHalf == top && SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side != dir.m_122424_()) {
            return false;
        }
        return (adjDir == dir && top || adjDir == dir.m_122424_() && !top) && SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return adjTop == top && side == dir.m_122424_() && SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, Direction side) {
        Direction camoSide = top ? Direction.UP : Direction.DOWN;
        return side == dir.m_122424_() && SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return adjDir == dir && adjTop == top && side == dir.m_122424_() && SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (adjTop != top || side != dir.m_122424_()) {
            return false;
        }
        return StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.m_122424_()) && SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        if (side != dir.m_122424_() || adjDir != dir.m_122424_()) {
            return false;
        }
        Direction face = top ? Direction.UP : Direction.DOWN;
        return SideSkipPredicate.compareState(level, pos, side, face, face);
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (side != dir.m_122424_() || adjTop != top) {
            return false;
        }
        if (adjDir == dir || adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }
}

