/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelProperty;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CollapseFace;
import xfacthd.framedblocks.common.util.MathUtils;

public class FramedCollapsibleBlockEntity
extends FramedBlockEntity {
    public static final ModelProperty<Integer> OFFSETS = new ModelProperty();
    private Direction collapsedFace = null;
    private byte[] vertexOffsets = new byte[4];

    public FramedCollapsibleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.blockEntityTypeFramedCollapsibleBlock.get(), pos, state);
    }

    public void handleDeform(Player player) {
        HitResult hit = player.m_19907_(10.0, 0.0f, false);
        if (!(hit instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hit;
        Direction faceHit = blockHit.m_82434_();
        Vec3 hitLoc = Utils.fraction(hit.m_82450_());
        if (this.collapsedFace != null && faceHit != this.collapsedFace) {
            return;
        }
        int vert = FramedCollapsibleBlockEntity.vertexFromHit(faceHit, hitLoc);
        if (player.m_6144_() && this.collapsedFace != null && this.vertexOffsets[vert] > 0) {
            byte target = (byte)(this.vertexOffsets[vert] - 1);
            this.applyDeformation(vert, target, faceHit);
            this.deformNeighbors(faceHit, hitLoc, target);
        } else if (!player.m_6144_() && this.vertexOffsets[vert] < 16) {
            byte target = (byte)(this.vertexOffsets[vert] + 1);
            this.applyDeformation(vert, target, faceHit);
            this.deformNeighbors(faceHit, hitLoc, target);
        }
    }

    private void applyDeformation(int vertex, byte offset, Direction faceHit) {
        if ((offset = Mth.m_144847_((byte)offset, (byte)0, (byte)16)) == this.vertexOffsets[vertex]) {
            return;
        }
        this.vertexOffsets[vertex] = offset;
        if (offset == 0) {
            boolean noOffsets = true;
            for (int i = 0; i < 4; ++i) {
                if (this.vertexOffsets[i] <= 0) continue;
                noOffsets = false;
                break;
            }
            if (noOffsets) {
                this.collapsedFace = null;
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(PropertyHolder.COLLAPSED_FACE, (Comparable)((Object)CollapseFace.NONE)), 3);
            } else {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        } else if (this.collapsedFace == null) {
            this.collapsedFace = faceHit;
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(PropertyHolder.COLLAPSED_FACE, (Comparable)((Object)CollapseFace.fromDirection(this.collapsedFace))), 3);
        } else {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
        this.m_6596_();
    }

    private void deformNeighbors(Direction faceHit, Vec3 hitLoc, byte offset) {
        BlockPos[] neighbors = new BlockPos[3];
        Vec3[] hitVecs = new Vec3[3];
        if (Utils.isY(faceHit)) {
            Direction dirX = hitLoc.f_82479_ > 0.5 ? Direction.EAST : Direction.WEST;
            Direction dirZ = hitLoc.f_82481_ > 0.5 ? Direction.SOUTH : Direction.NORTH;
            neighbors[0] = this.f_58858_.m_142300_(dirX);
            neighbors[1] = this.f_58858_.m_142300_(dirZ);
            neighbors[2] = neighbors[0].m_142300_(dirZ);
            hitVecs[0] = hitLoc.m_82520_((double)dirX.m_122429_() * 0.5, 0.0, 0.0);
            hitVecs[1] = hitLoc.m_82520_(0.0, 0.0, (double)dirZ.m_122431_() * 0.5);
            hitVecs[2] = hitVecs[0].m_82520_(0.0, 0.0, (double)dirZ.m_122431_() * 0.5);
        } else {
            Direction dirY;
            Direction direction = dirY = hitLoc.f_82480_ > 0.5 ? Direction.UP : Direction.DOWN;
            Direction dirXZ = Utils.isX(faceHit) ? (hitLoc.f_82481_ > 0.5 ? Direction.SOUTH : Direction.NORTH) : (hitLoc.f_82479_ > 0.5 ? Direction.EAST : Direction.WEST);
            neighbors[0] = this.f_58858_.m_142300_(dirY);
            neighbors[1] = this.f_58858_.m_142300_(dirXZ);
            neighbors[2] = neighbors[0].m_142300_(dirXZ);
            hitVecs[0] = hitLoc.m_82520_(0.0, (double)dirY.m_122430_() * 0.5, 0.0);
            hitVecs[1] = hitLoc.m_82520_((double)dirXZ.m_122429_() * 0.5, 0.0, (double)dirXZ.m_122431_() * 0.5);
            hitVecs[2] = hitVecs[0].m_82520_((double)dirXZ.m_122429_() * 0.5, 0.0, (double)dirXZ.m_122431_() * 0.5);
        }
        for (int i = 0; i < 3; ++i) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(neighbors[i]);
            if (!(blockEntity instanceof FramedCollapsibleBlockEntity)) continue;
            FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
            if (be.collapsedFace != null && be.collapsedFace != faceHit) continue;
            int vert = FramedCollapsibleBlockEntity.vertexFromHit(faceHit, MathUtils.wrapVector(hitVecs[i], 0.0, 1.0));
            be.applyDeformation(vert, offset, faceHit);
        }
    }

    private static int vertexFromHit(Direction faceHit, Vec3 loc) {
        double xz;
        if (Utils.isY(faceHit)) {
            if (loc.f_82481_ < 0.5 == (faceHit == Direction.UP)) {
                return loc.f_82479_ < 0.5 ? 0 : 3;
            }
            return loc.f_82479_ < 0.5 ? 1 : 2;
        }
        boolean positive = faceHit == Direction.SOUTH || faceHit == Direction.WEST;
        double d = xz = Utils.isX(faceHit) ? loc.f_82481_ : loc.f_82479_;
        if (loc.f_82480_ < 0.5) {
            return xz < 0.5 == positive ? 1 : 2;
        }
        return xz < 0.5 == positive ? 0 : 3;
    }

    public Direction getCollapsedFace() {
        return this.collapsedFace;
    }

    public byte[] getVertexOffsets() {
        return this.vertexOffsets;
    }

    public int getPackedOffsets() {
        return FramedCollapsibleBlockEntity.packOffsets(this.vertexOffsets);
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt) {
        super.writeToDataPacket(nbt);
        nbt.m_128405_("offsets", FramedCollapsibleBlockEntity.packOffsets(this.vertexOffsets));
        nbt.m_128405_("face", this.collapsedFace == null ? -1 : this.collapsedFace.m_122411_());
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt) {
        int faceIdx;
        Direction face;
        boolean needUpdate = super.readFromDataPacket(nbt);
        int packed = nbt.m_128451_("offsets");
        byte[] offsets = FramedCollapsibleBlockEntity.unpackOffsets(packed);
        if (!Arrays.equals(offsets, this.vertexOffsets)) {
            this.vertexOffsets = offsets;
            this.getModelDataInternal().setData(OFFSETS, packed);
            needUpdate = true;
        }
        Direction direction = face = (faceIdx = nbt.m_128451_("face")) == -1 ? null : Direction.m_122376_((int)faceIdx);
        if (this.collapsedFace != face) {
            this.collapsedFace = face;
            needUpdate = true;
        }
        return needUpdate;
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("offsets", FramedCollapsibleBlockEntity.packOffsets(this.vertexOffsets));
        nbt.m_128405_("face", this.collapsedFace == null ? -1 : this.collapsedFace.m_122411_());
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        int packed = nbt.m_128451_("offsets");
        this.vertexOffsets = FramedCollapsibleBlockEntity.unpackOffsets(packed);
        this.getModelDataInternal().setData(OFFSETS, packed);
        int face = nbt.m_128451_("face");
        this.collapsedFace = face == -1 ? null : Direction.m_122376_((int)face);
    }

    @Override
    protected void initModelData() {
        super.initModelData();
        this.getModelDataInternal().setData(OFFSETS, FramedCollapsibleBlockEntity.packOffsets(this.vertexOffsets));
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("offsets", FramedCollapsibleBlockEntity.packOffsets(this.vertexOffsets));
        nbt.m_128405_("face", this.collapsedFace == null ? -1 : this.collapsedFace.m_122411_());
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.vertexOffsets = FramedCollapsibleBlockEntity.unpackOffsets(nbt.m_128451_("offsets"));
        int face = nbt.m_128451_("face");
        this.collapsedFace = face == -1 ? null : Direction.m_122376_((int)face);
    }

    public static int packOffsets(byte[] offsets) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result |= offsets[i] << i * 5;
        }
        return result;
    }

    public static byte[] unpackOffsets(int packed) {
        byte[] offsets = new byte[4];
        for (int i = 0; i < 4; ++i) {
            offsets[i] = (byte)(packed >> i * 5 & 0x1F);
        }
        return offsets;
    }
}

