/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.FramedRailSlopeBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.util.FramedUtils;

public class FramedSlopeBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> {
        SlopeType type = FramedUtils.getSlopeType(state);
        if (dir == Direction.UP && type == SlopeType.TOP) {
            return true;
        }
        if (dir == Direction.DOWN && type == SlopeType.BOTTOM) {
            return true;
        }
        if (type == SlopeType.HORIZONTAL) {
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return dir == facing || dir == facing.m_122428_();
        }
        return FramedUtils.getBlockFacing(state) == dir;
    };
    public static final VoxelShape SHAPE_BOTTOM = Shapes.m_83124_((VoxelShape)FramedSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopeBlock.m_49796_((double)0.0, (double)0.5, (double)0.0, (double)16.0, (double)4.0, (double)15.5), FramedSlopeBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), FramedSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), FramedSlopeBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)4.0), FramedSlopeBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)0.5)}).m_83296_();
    public static final VoxelShape SHAPE_TOP = Shapes.m_83124_((VoxelShape)FramedSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)0.5), (VoxelShape[])new VoxelShape[]{FramedSlopeBlock.m_49796_((double)0.0, (double)0.5, (double)0.0, (double)16.0, (double)4.0, (double)4.0), FramedSlopeBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), FramedSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0), FramedSlopeBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)15.5), FramedSlopeBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0)}).m_83296_();
    public static final VoxelShape SHAPE_HORIZONTAL = Shapes.m_83124_((VoxelShape)FramedSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)15.5), FramedSlopeBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)12.0), FramedSlopeBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0), FramedSlopeBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)4.0), FramedSlopeBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5)}).m_83296_();

    public FramedSlopeBlock() {
        super(BlockType.FRAMED_SLOPE);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.SLOPE_TYPE, BlockStateProperties.f_61362_, FramedProperties.SOLID, FramedProperties.GLOWING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = FramedSlopeBlock.withSlopeType(this.m_49966_(), context.m_43719_(), context.m_8125_(), context.m_43720_());
        return FramedSlopeBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_41720_() == Items.f_41964_) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
            Direction face = hit.m_82434_();
            if (type == SlopeType.BOTTOM && (face == dir.m_122424_() || face == Direction.UP)) {
                BlockState newState;
                Block railSlope = (Block)FBContent.blockFramedRailSlope.get();
                if (!railSlope.m_7898_(newState = (BlockState)((BlockState)railSlope.m_49966_().m_61124_(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)FramedRailSlopeBlock.shapeFromDirection(dir))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_))), (LevelReader)level, pos)) {
                    return InteractionResult.FAIL;
                }
                if (!level.m_5776_()) {
                    BlockEntity blockEntity;
                    BlockState camoState = Blocks.f_50016_.m_49966_();
                    ItemStack camoStack = ItemStack.f_41583_;
                    boolean glowing = false;
                    boolean intangible = false;
                    BlockEntity blockEntity2 = level.m_7702_(pos);
                    if (blockEntity2 instanceof FramedBlockEntity) {
                        FramedBlockEntity be = (FramedBlockEntity)blockEntity2;
                        camoState = be.getCamoState();
                        camoStack = be.getCamoStack();
                        glowing = be.isGlowing();
                        intangible = be.isIntangible(null);
                    }
                    level.m_46597_(pos, newState);
                    SoundType sound = Blocks.f_50156_.m_49962_(Blocks.f_50156_.m_49966_());
                    level.m_5594_(null, pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                        player.m_150109_().m_6596_();
                    }
                    if ((blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
                        FramedBlockEntity be = (FramedBlockEntity)blockEntity;
                        be.setCamo(camoStack, camoState, false);
                        be.setGlowing(glowing);
                        be.setIntangible(intangible);
                    }
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        if (Utils.isY(face) || type != SlopeType.HORIZONTAL && face == dir.m_122424_()) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_(PropertyHolder.SLOPE_TYPE);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            SlopeType type = FramedUtils.getSlopeType(state);
            Direction dir = FramedUtils.getBlockFacing(state);
            if (type == SlopeType.BOTTOM) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, SHAPE_BOTTOM));
                continue;
            }
            if (type == SlopeType.TOP) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, SHAPE_TOP));
                continue;
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, SHAPE_HORIZONTAL));
        }
        return builder.build();
    }
}

