/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.outline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.util.client.OutlineRender;

public class PyramidOutlineRenderer
implements OutlineRender {
    private static final Quaternion ZP_90 = Vector3f.f_122227_.m_122270_(1.5707964f);
    private static final Quaternion ZP_180 = Vector3f.f_122227_.m_122270_((float)Math.PI);
    private static final Quaternion[] XN_DIR = PyramidOutlineRenderer.makeQuaternionArray();
    private final float height;

    public PyramidOutlineRenderer(boolean slab) {
        this.height = slab ? 0.5f : 1.0f;
    }

    @Override
    public void draw(BlockState state, PoseStack pstack, VertexConsumer builder) {
        OutlineRender.drawLine(builder, pstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        OutlineRender.drawLine(builder, pstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, pstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, pstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, pstack, 0.0, 0.0, 0.0, 0.5, this.height, 0.5);
        OutlineRender.drawLine(builder, pstack, 1.0, 0.0, 0.0, 0.5, this.height, 0.5);
        OutlineRender.drawLine(builder, pstack, 0.0, 0.0, 1.0, 0.5, this.height, 0.5);
        OutlineRender.drawLine(builder, pstack, 1.0, 0.0, 1.0, 0.5, this.height, 0.5);
    }

    @Override
    public void rotateMatrix(PoseStack poseStack, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        if (dir == Direction.DOWN) {
            poseStack.m_85845_(ZP_180);
        } else if (dir != Direction.UP) {
            poseStack.m_85845_(ZP_90);
            poseStack.m_85845_(XN_DIR[dir.m_122416_()]);
        }
    }

    private static Quaternion[] makeQuaternionArray() {
        Quaternion[] array = new Quaternion[4];
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            array[dir.m_122416_()] = Vector3f.f_122222_.m_122240_(dir.m_122435_() - 90.0f);
        }
        return array;
    }
}

