/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedPillarModel
extends FramedBlockModel {
    private final Direction.Axis axis;
    private final float capStart;
    private final float capEnd;
    private final float sideCut;

    public FramedPillarModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
        IBlockType type = ((IFramedBlock)state.m_60734_()).getBlockType();
        this.capStart = type == BlockType.FRAMED_POST ? 0.375f : 0.25f;
        this.capEnd = type == BlockType.FRAMED_POST ? 0.625f : 0.75f;
        this.sideCut = type == BlockType.FRAMED_POST ? 0.625f : 0.75f;
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        FramedPillarModel.createPillarQuad(quad, this.axis, this.capStart, this.capEnd, this.sideCut).export(quadMap.get(quadDir.m_122434_() == this.axis ? quadDir : null));
    }

    public static QuadModifier createPillarQuad(BakedQuad quad, Direction.Axis axis, float capStart, float capEnd, float sideCut) {
        Direction quadDir = quad.m_111306_();
        if (quadDir.m_122434_() == axis) {
            if (axis == Direction.Axis.Y) {
                return QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(capStart, capStart, capEnd, capEnd));
            }
            return QuadModifier.geometry(quad).apply(Modifiers.cutSide(capStart, capStart, capEnd, capEnd));
        }
        if (axis == Direction.Axis.Y) {
            return QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(quadDir.m_122427_(), sideCut)).apply(Modifiers.cutSideLeftRight(quadDir.m_122428_(), sideCut)).apply(Modifiers.setPosition(sideCut));
        }
        if (Utils.isY(quadDir)) {
            return QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(FramedPillarModel.axisToDir(axis, true).m_122427_(), sideCut)).apply(Modifiers.cutTopBottom(FramedPillarModel.axisToDir(axis, false).m_122427_(), sideCut)).apply(Modifiers.setPosition(sideCut));
        }
        return QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(true, sideCut)).apply(Modifiers.cutSideUpDown(false, sideCut)).apply(Modifiers.setPosition(sideCut));
    }

    private static Direction axisToDir(Direction.Axis axis, boolean positive) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (positive) {
                    yield Direction.EAST;
                }
                yield Direction.WEST;
            }
            case Direction.Axis.Y -> {
                if (positive) {
                    yield Direction.UP;
                }
                yield Direction.DOWN;
            }
            case Direction.Axis.Z -> positive ? Direction.SOUTH : Direction.NORTH;
        };
    }
}

