/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;

public class FramedLeverModel
extends FramedBlockModel {
    private static final ResourceLocation TEXTURE = new ResourceLocation("framedblocks", "block/framed_block");
    private static final float MIN_SMALL = 0.3125f;
    private static final float MAX_SMALL = 0.6875f;
    private static final float MIN_LARGE = 0.25f;
    private static final float MAX_LARGE = 0.75f;
    private static final float HEIGHT = 0.1875f;
    private final Direction dir;
    private final AttachFace face;

    public FramedLeverModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        this.face = (AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_);
    }

    @Override
    protected boolean hasAdditionalQuadsInLayer(RenderType layer) {
        return ItemBlockRenderTypes.canRenderInLayer((BlockState)Blocks.f_50164_.m_49966_(), (RenderType)layer);
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data, RenderType layer) {
        List quads = this.baseModel.getQuads(state, null, rand, data);
        for (BakedQuad quad : quads) {
            if (quad.m_173410_().m_118413_().equals((Object)TEXTURE)) continue;
            quadMap.get(null).add(quad);
        }
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction facing;
        boolean quadInDir;
        Direction quadDir = quad.m_111306_();
        boolean bl = quadInDir = quadDir == (facing = this.getFacing());
        if (Utils.isY(facing)) {
            if (quadDir.m_122434_() == facing.m_122434_()) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122434_(), 0.75f)).apply(Modifiers.cutTopBottom(this.dir.m_122427_().m_122434_(), 0.6875f)).applyIf(Modifiers.setPosition(0.1875f), quadInDir).export(quadMap.get(quadInDir ? null : quadDir));
            } else {
                boolean smallSide = this.dir.m_122434_() == quadDir.m_122434_();
                QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(facing == Direction.DOWN, 0.1875f)).apply(Modifiers.cutSideLeftRight(smallSide ? 0.6875f : 0.75f)).apply(Modifiers.setPosition(smallSide ? 0.75f : 0.6875f)).export(quadMap.get(null));
            }
        } else if (quadDir.m_122434_() == facing.m_122434_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.3125f, 0.25f, 0.6875f, 0.75f)).applyIf(Modifiers.setPosition(0.1875f), quadInDir).export(quadMap.get(quadInDir ? null : quadDir));
        } else if (Utils.isY(quadDir)) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir, 0.1875f)).apply(Modifiers.cutTopBottom(this.dir.m_122427_().m_122434_(), 0.6875f)).apply(Modifiers.setPosition(0.75f)).export(quadMap.get(null));
        } else {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.1875f)).apply(Modifiers.cutSideUpDown(0.75f)).apply(Modifiers.setPosition(0.6875f)).export(quadMap.get(null));
        }
    }

    private Direction getFacing() {
        return switch (this.face) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> Direction.UP;
            case AttachFace.WALL -> this.dir;
            case AttachFace.CEILING -> Direction.DOWN;
        };
    }
}

