/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.FramedBlockData;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.FramedLargeButtonModel;
import xfacthd.framedblocks.common.FBContent;

public class FramedLargeStoneButtonModel
extends FramedLargeButtonModel {
    private static final ResourceLocation FRAME_LOCATION = new ResourceLocation("framedblocks", "block/framed_large_stone_button_frame");
    private static final ResourceLocation FRAME_PRESSED_LOCATION = new ResourceLocation("framedblocks", "block/framed_large_stone_button_pressed_frame");
    private static BakedModel frameNormalModel;
    private static BakedModel framePressedModel;
    private final BakedModel frameModel;
    private final int rotX;
    private final int rotY;

    public FramedLargeStoneButtonModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.frameModel = this.pressed ? framePressedModel : frameNormalModel;
        this.rotX = switch (this.face) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> 0;
            case AttachFace.WALL -> 90;
            case AttachFace.CEILING -> 180;
        };
        this.rotY = (int)(-this.dir.m_122435_());
    }

    @Override
    protected boolean hasAdditionalQuadsInLayer(RenderType layer) {
        return layer == RenderType.m_110463_();
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data, RenderType layer) {
        BlockState camo = (BlockState)data.getData(FramedBlockData.CAMO);
        if (camo == null || camo.m_60795_()) {
            return;
        }
        List quads = this.frameModel.getQuads(state, null, rand, data);
        this.addRotatedQuads(quads, quadMap.get(null));
        for (Direction side : Direction.values()) {
            quads = this.frameModel.getQuads(state, side, rand, data);
            this.addRotatedQuads(quads, quadMap.get(side));
        }
    }

    private void addRotatedQuads(List<BakedQuad> source, List<BakedQuad> dest) {
        if (this.face == AttachFace.FLOOR && Utils.isZ(this.dir)) {
            dest.addAll(source);
            return;
        }
        for (BakedQuad quad : source) {
            QuadModifier.geometry(quad).apply(Modifiers.rotateCentered(Direction.Axis.X, this.rotX, false)).apply(Modifiers.rotateCentered(Direction.Axis.Y, this.rotY, false)).export(dest);
        }
    }

    @Override
    protected BakedModel getCamoModel(BlockState camoState) {
        if (camoState.m_60713_((Block)FBContent.blockFramedCube.get())) {
            return this.baseModel;
        }
        return super.getCamoModel(camoState);
    }

    @Override
    protected boolean forceUngeneratedBaseModel() {
        return true;
    }

    public static void registerFrameModels() {
        ForgeModelBakery.addSpecialModel((ResourceLocation)FRAME_LOCATION);
        ForgeModelBakery.addSpecialModel((ResourceLocation)FRAME_PRESSED_LOCATION);
    }

    public static void cacheFrameModels(Map<ResourceLocation, BakedModel> registry) {
        frameNormalModel = registry.get(FRAME_LOCATION);
        framePressedModel = registry.get(FRAME_PRESSED_LOCATION);
    }
}

