/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.api.model.BakedModelProxy;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.FramedBlockData;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedFlowerPotBlock;
import xfacthd.framedblocks.common.blockentity.FramedFlowerPotBlockEntity;

public class FramedFlowerPotModel
extends BakedModelProxy {
    private final Map<Block, PotModel> CACHE_BY_PLANT = new HashMap<Block, PotModel>();

    public FramedFlowerPotModel(BlockState state, BakedModel baseModel) {
        super(baseModel);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return this.getOrCreatePotModel(state, extraData).getQuads(state, side, rand, extraData);
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        return this.getOrCreatePotModel(((Block)FBContent.blockFramedFlowerPot.get()).m_49966_(), data).getParticleIcon(data);
    }

    private PotModel getOrCreatePotModel(BlockState state, IModelData extraData) {
        Block flower = Optional.ofNullable((Block)extraData.getData(FramedFlowerPotBlockEntity.FLOWER_BLOCK)).orElse(Blocks.f_50016_);
        return this.CACHE_BY_PLANT.computeIfAbsent(flower, block -> new PotModel(state, this.baseModel, flower));
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedFlowerPotBlockEntity) {
            FramedFlowerPotBlockEntity be = (FramedFlowerPotBlockEntity)blockEntity;
            return be.getModelData();
        }
        return tileData;
    }

    private static class PotModel
    extends FramedBlockModel {
        private static final ResourceLocation POT_TEXTURE = new ResourceLocation("minecraft:block/flower_pot");
        private static final ResourceLocation DIRT_TEXTURE = new ResourceLocation("minecraft:block/dirt");
        private final Block flower;

        public PotModel(BlockState state, BakedModel baseModel, Block flower) {
            super(state, baseModel);
            this.flower = flower;
        }

        @Override
        protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
            if (quad.m_111306_() == Direction.DOWN) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.3125f, 0.3125f, 0.6875f, 0.6875f)).export(quadMap.get(Direction.DOWN));
            } else if (quad.m_111306_() == Direction.UP) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.3125f, 0.3125f, 0.6875f, 0.375f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.3125f, 0.625f, 0.6875f, 0.6875f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.3125f, 0.375f, 0.375f, 0.625f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.625f, 0.375f, 0.6875f, 0.625f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
            } else if (!Utils.isY(quad.m_111306_())) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.3125f, 0.0f, 0.6875f, 0.375f)).apply(Modifiers.setPosition(0.6875f)).export(quadMap.get(null));
                QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.375f, 0.0625f, 0.625f, 0.375f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
            }
        }

        @Override
        protected boolean hasAdditionalQuadsInLayer(RenderType layer) {
            return ItemBlockRenderTypes.canRenderInLayer((BlockState)Blocks.f_50493_.m_49966_(), (RenderType)layer) || ItemBlockRenderTypes.canRenderInLayer((BlockState)this.flower.m_49966_(), (RenderType)layer);
        }

        @Override
        protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data, RenderType layer) {
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            BlockState potState = FramedFlowerPotBlock.getFlowerPotState(this.flower);
            if (!potState.m_60795_() && ItemBlockRenderTypes.canRenderInLayer((BlockState)this.flower.m_49966_(), (RenderType)layer)) {
                BakedModel potModel = dispatcher.m_110910_(potState);
                Arrays.stream(Direction.values()).map(dir -> Pair.of((Object)dir, PotModel.getFilteredPlantQuads(potState, potModel, dir, rand))).forEach(pair -> ((List)quadMap.get(pair.getFirst())).addAll((Collection)pair.getSecond()));
                quadMap.get(null).addAll(PotModel.getFilteredPlantQuads(potState, potModel, null, rand));
            }
            if (ItemBlockRenderTypes.canRenderInLayer((BlockState)Blocks.f_50493_.m_49966_(), (RenderType)layer)) {
                FramedBlockData framedData;
                BakedModel dirtModel = dispatcher.m_110910_(Blocks.f_50493_.m_49966_());
                dirtModel.getQuads(Blocks.f_50493_.m_49966_(), Direction.UP, rand, (IModelData)EmptyModelData.INSTANCE).forEach(q -> QuadModifier.geometry(q).apply(Modifiers.cutTopBottom(0.375f, 0.375f, 0.625f, 0.625f)).apply(Modifiers.setPosition(0.25f)).export((List)quadMap.get(null)));
                if (data instanceof FramedBlockData && !(framedData = (FramedBlockData)data).getCamoState().m_60815_()) {
                    dirtModel.getQuads(Blocks.f_50493_.m_49966_(), Direction.DOWN, rand, (IModelData)EmptyModelData.INSTANCE).forEach(q -> QuadModifier.geometry(q).apply(Modifiers.cutTopBottom(0.375f, 0.375f, 0.625f, 0.625f)).apply(Modifiers.setPosition(0.9375f)).export((List)quadMap.get(null)));
                    Direction.Plane.HORIZONTAL.m_122557_().flatMap(face -> dirtModel.getQuads(Blocks.f_50016_.m_49966_(), face, rand, (IModelData)EmptyModelData.INSTANCE).stream()).forEach(q -> QuadModifier.geometry(q).apply(Modifiers.cutSide(0.375f, 0.0625f, 0.625f, 0.25f)).apply(Modifiers.setPosition(0.625f)).export((List)quadMap.get(null)));
                }
            }
        }

        private static List<BakedQuad> getFilteredPlantQuads(BlockState potState, BakedModel potModel, Direction face, Random rand) {
            return potModel.getQuads(potState, face, rand, (IModelData)EmptyModelData.INSTANCE).stream().filter(q -> !q.m_173410_().m_118413_().equals((Object)POT_TEXTURE)).filter(q -> !q.m_173410_().m_118413_().equals((Object)DIRT_TEXTURE)).map(ModelUtils::invertTintIndex).collect(Collectors.toList());
        }
    }
}

