/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.model.quad;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraftforge.client.model.pipeline.LightUtil;
import xfacthd.framedblocks.api.util.client.ModelUtils;

public final class QuadModifier {
    private static final QuadModifier FAILED = new QuadModifier(null, true, true);
    private static final QuadModifier FAILED_FULL = new QuadModifier(null, false, true);
    private final Data data;
    private final boolean limited;
    private boolean failed;

    public static QuadModifier geometry(BakedQuad quad) {
        float[][] pos = new float[4][3];
        float[][] uv = new float[4][2];
        float[][] normal = new float[4][3];
        int[] vertexData = quad.m_111303_();
        for (int i = 0; i < 4; ++i) {
            LightUtil.unpack((int[])vertexData, (float[])pos[i], (VertexFormat)DefaultVertexFormat.f_85811_, (int)i, (int)ModelUtils.ELEMENT_POS);
            LightUtil.unpack((int[])vertexData, (float[])uv[i], (VertexFormat)DefaultVertexFormat.f_85811_, (int)i, (int)ModelUtils.ELEMENT_UV);
            LightUtil.unpack((int[])vertexData, (float[])normal[i], (VertexFormat)DefaultVertexFormat.f_85811_, (int)i, (int)ModelUtils.ELEMENT_NORMAL);
        }
        return new QuadModifier(new Data(quad, pos, uv, normal), true, false);
    }

    public static QuadModifier full(BakedQuad quad) {
        float[][] pos = new float[4][3];
        float[][] uv = new float[4][2];
        float[][] normal = new float[4][3];
        float[] colorf = new float[4];
        float[] lightf = new float[2];
        int[][] color = new int[4][4];
        int[][] light = new int[4][2];
        int[] vertexData = quad.m_111303_();
        for (int i = 0; i < 4; ++i) {
            LightUtil.unpack((int[])vertexData, (float[])pos[i], (VertexFormat)DefaultVertexFormat.f_85811_, (int)i, (int)ModelUtils.ELEMENT_POS);
            LightUtil.unpack((int[])vertexData, (float[])uv[i], (VertexFormat)DefaultVertexFormat.f_85811_, (int)i, (int)ModelUtils.ELEMENT_UV);
            LightUtil.unpack((int[])vertexData, (float[])normal[i], (VertexFormat)DefaultVertexFormat.f_85811_, (int)i, (int)ModelUtils.ELEMENT_NORMAL);
            LightUtil.unpack((int[])vertexData, (float[])colorf, (VertexFormat)DefaultVertexFormat.f_85811_, (int)i, (int)ModelUtils.ELEMENT_COLOR);
            LightUtil.unpack((int[])vertexData, (float[])lightf, (VertexFormat)DefaultVertexFormat.f_85811_, (int)i, (int)ModelUtils.ELEMENT_LIGHT);
            color[i][0] = (int)colorf[0];
            color[i][1] = (int)colorf[1];
            color[i][2] = (int)colorf[2];
            color[i][3] = (int)colorf[3];
            light[i][0] = (int)lightf[0];
            light[i][1] = (int)lightf[1];
        }
        return new QuadModifier(new Data(quad, pos, uv, normal, color, light), false, false);
    }

    private QuadModifier(Data data, boolean limited, boolean failed) {
        this.data = data;
        this.limited = limited;
        this.failed = failed;
    }

    public QuadModifier applyIf(Modifier modifier, boolean apply) {
        return apply ? this.apply(modifier) : this;
    }

    public QuadModifier apply(Modifier modifier) {
        if (!this.failed) {
            this.failed = !modifier.accept(this.data);
        }
        return this;
    }

    public void export(List<BakedQuad> quadList) {
        this.export(quadList::add);
    }

    public void export(Consumer<BakedQuad> quadConsumer) {
        if (this.failed) {
            return;
        }
        int[] vertexData = this.data.quad.m_111303_();
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        this.packVertexData(vertexData);
        BakedQuad newQuad = new BakedQuad(vertexData, this.data.quad.m_111305_(), this.data.quad.m_111306_(), this.data.quad.m_173410_(), this.data.quad.m_111307_());
        ModelUtils.fillNormal(newQuad);
        quadConsumer.accept(newQuad);
    }

    public void modifyInPlace() {
        if (this.failed) {
            return;
        }
        this.packVertexData(this.data.quad.m_111303_());
        ModelUtils.fillNormal(this.data.quad);
    }

    private void packVertexData(int[] vertexData) {
        float[] colorf = new float[4];
        float[] lightf = new float[2];
        for (int i = 0; i < 4; ++i) {
            LightUtil.pack((float[])this.data.pos[i], (int[])vertexData, (VertexFormat)DefaultVertexFormat.f_85811_, (int)i, (int)ModelUtils.ELEMENT_POS);
            LightUtil.pack((float[])this.data.uv[i], (int[])vertexData, (VertexFormat)DefaultVertexFormat.f_85811_, (int)i, (int)ModelUtils.ELEMENT_UV);
            LightUtil.pack((float[])this.data.normal[i], (int[])vertexData, (VertexFormat)DefaultVertexFormat.f_85811_, (int)i, (int)ModelUtils.ELEMENT_NORMAL);
            if (this.data.color != null) {
                colorf[0] = this.data.color[i][0];
                colorf[1] = this.data.color[i][1];
                colorf[2] = this.data.color[i][2];
                colorf[3] = this.data.color[i][3];
                LightUtil.pack((float[])colorf, (int[])vertexData, (VertexFormat)DefaultVertexFormat.f_85811_, (int)i, (int)ModelUtils.ELEMENT_COLOR);
            }
            if (this.data.light == null) continue;
            lightf[0] = this.data.light[i][0];
            lightf[1] = this.data.light[i][1];
            LightUtil.pack((float[])lightf, (int[])vertexData, (VertexFormat)DefaultVertexFormat.f_85811_, (int)i, (int)ModelUtils.ELEMENT_LIGHT);
        }
    }

    public QuadModifier derive() {
        if (this.failed) {
            return this.limited ? FAILED : FAILED_FULL;
        }
        return new QuadModifier(new Data(this.data), this.limited, false);
    }

    public boolean hasFailed() {
        return this.failed;
    }

    public record Data(BakedQuad quad, float[][] pos, float[][] uv, float[][] normal, int[][] color, int[][] light) {
        public Data(BakedQuad quad, float[][] pos, float[][] uv, float[][] normal) {
            this(quad, pos, uv, normal, null, null);
        }

        public Data(Data data) {
            this(data.quad, Data.deepCopy(data.pos), Data.deepCopy(data.uv), Data.deepCopy(data.normal), data.color != null ? Data.deepCopy(data.color) : null, data.light != null ? Data.deepCopy(data.light) : null);
        }

        private static float[][] deepCopy(float[][] arr) {
            float[][] newArr = new float[arr.length][];
            for (int i = 0; i < arr.length; ++i) {
                newArr[i] = Arrays.copyOf(arr[i], arr[i].length);
            }
            return newArr;
        }

        private static int[][] deepCopy(int[][] arr) {
            int[][] newArr = new int[arr.length][];
            for (int i = 0; i < arr.length; ++i) {
                newArr[i] = Arrays.copyOf(arr[i], arr[i].length);
            }
            return newArr;
        }
    }

    @FunctionalInterface
    public static interface Modifier {
        public boolean accept(Data var1);
    }
}

