/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.ghost;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.ghost.CamoPair;

public interface GhostRenderBehaviour {
    @Nullable
    default public ItemStack getProxiedStack(ItemStack stack) {
        return null;
    }

    default public boolean mayRender(ItemStack stack, @Nullable ItemStack proxiedStack) {
        BlockItem item;
        Item item2 = stack.m_41720_();
        return item2 instanceof BlockItem && (item = (BlockItem)item2).m_40614_() instanceof IFramedBlock;
    }

    default public boolean hasSecondBlock(ItemStack stack, @Nullable ItemStack proxiedStack) {
        return false;
    }

    @Nullable
    default public BlockState getRenderState(ItemStack stack, @Nullable ItemStack proxiedStack, BlockHitResult hit, BlockPlaceContext ctx, BlockState hitState, boolean secondPass) {
        Block block = ((BlockItem)stack.m_41720_()).m_40614_();
        return block.m_5573_(ctx);
    }

    default public BlockPos getRenderPos(ItemStack stack, @Nullable ItemStack proxiedStack, BlockHitResult hit, BlockPlaceContext ctx, BlockState hitState, BlockPos defaultPos, boolean secondPass) {
        return defaultPos;
    }

    default public boolean canRenderAt(ItemStack stack, @Nullable ItemStack proxiedStack, BlockHitResult hit, BlockPlaceContext ctx, BlockState hitState, BlockState renderState, BlockPos renderPos) {
        Player player;
        Level level = ctx.m_43725_();
        return level.m_45752_(renderState, renderPos, CollisionContext.m_82750_((Entity)(player = Objects.requireNonNull(ctx.m_43723_())))) && level.m_8055_(renderPos).m_60629_(ctx);
    }

    default public CamoPair readCamo(ItemStack stack, @Nullable ItemStack proxiedStack, boolean secondPass) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BlockEntityTag")) {
            CompoundTag tag = stack.m_41783_().m_128469_("BlockEntityTag").m_128469_("camo_state");
            BlockState camoState = NbtUtils.m_129241_((CompoundTag)tag);
            return new CamoPair(camoState, Blocks.f_50016_.m_49966_());
        }
        return CamoPair.EMPTY;
    }

    default public CamoPair postProcessCamo(ItemStack stack, @Nullable ItemStack proxiedStack, BlockPlaceContext ctx, BlockState renderState, boolean secondPass, CamoPair camo) {
        return camo;
    }

    default public IModelData appendModelData(ItemStack stack, @Nullable ItemStack proxiedStack, BlockPlaceContext ctx, BlockState renderState, boolean secondPass, IModelData data) {
        return data;
    }
}

