/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;

public interface IFramedBlock
extends EntityBlock {
    public static final String LOCK_MESSAGE = "msg.framedblocks.lock_state";
    public static final Component STATE_LOCKED = Utils.translate("msg", ".lock_state.locked").m_130940_(ChatFormatting.RED);
    public static final Component STATE_UNLOCKED = Utils.translate("msg", ".lock_state.unlocked").m_130940_(ChatFormatting.GREEN);

    public IBlockType getBlockType();

    @Deprecated(forRemoval=true)
    public static BlockBehaviour.Properties createProperties() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60955_().m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60971_(IFramedBlock::isBlockSuffocating).m_60960_(IFramedBlock::isBlockSuffocating);
    }

    public static BlockBehaviour.Properties createProperties(IBlockType type) {
        return IFramedBlock.createProperties(type, Material.f_76320_);
    }

    public static BlockBehaviour.Properties createProperties(IBlockType type, Material material) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60939_((Material)material).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60971_(IFramedBlock::isBlockSuffocating).m_60960_(IFramedBlock::isBlockSuffocating);
        if (!type.canOccludeWithSolidCamo()) {
            props.m_60955_();
        }
        return props;
    }

    private static boolean isBlockSuffocating(BlockState state, BlockGetter level, BlockPos pos) {
        return ((IFramedBlock)state.m_60734_()).isSuffocating(state, level, pos);
    }

    default public BlockItem createItemBlock() {
        Block block = (Block)this;
        BlockItem item = new BlockItem(block, new Item.Properties().m_41491_(FramedBlocksAPI.getInstance().defaultCreativeTab()));
        item.setRegistryName(block.getRegistryName());
        return item;
    }

    default public void tryApplyCamoImmediately(Level level, BlockPos pos, @Nullable LivingEntity placer, ItemStack stack) {
        if (level.m_5776_()) {
            return;
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BlockEntityTag")) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof FramedBlockEntity) {
                FramedBlockEntity be = (FramedBlockEntity)blockEntity;
                be.checkCamoSolid();
            }
            return;
        }
        if (placer instanceof Player) {
            BlockEntity blockEntity;
            BlockItem item;
            Player player = (Player)placer;
            if (player.m_21205_() != stack) {
                return;
            }
            ItemStack otherStack = player.m_21206_();
            Item item2 = otherStack.m_41720_();
            if (item2 instanceof BlockItem && !((item = (BlockItem)item2).m_40614_() instanceof IFramedBlock) && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
                FramedBlockEntity be = (FramedBlockEntity)blockEntity;
                if (!FramedBlocksAPI.getInstance().isFramedDoubleBlockEntity(be)) {
                    Vec3 hitVec = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                    be.handleInteraction(player, InteractionHand.OFF_HAND, new BlockHitResult(hitVec, Direction.UP, pos, false));
                }
            }
        }
    }

    default public InteractionResult handleUse(Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.getBlockType().canLockState() && hand == InteractionHand.MAIN_HAND && this.lockState(level, pos, player, player.m_21120_(hand))) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (player.m_21120_(hand).m_204117_(Utils.WRENCH)) {
            Rotation rot;
            BlockState state = level.m_8055_(pos);
            BlockState newState = this.rotate(state, hit, rot = player.m_6047_() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90);
            if (newState != state) {
                if (!level.m_5776_()) {
                    level.m_46597_(pos, newState);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.handleInteraction(player, hand, hit);
        }
        return InteractionResult.FAIL;
    }

    default public int getLight(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getLightValue();
        }
        return 0;
    }

    default public SoundType getCamoSound(BlockState state, LevelReader level, BlockPos pos) {
        FramedBlockEntity be;
        BlockState camoState;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && !(camoState = (be = (FramedBlockEntity)blockEntity).getCamoState()).m_60795_()) {
            return camoState.m_60827_();
        }
        return ((Block)this).m_49962_(state);
    }

    default public List<ItemStack> getCamoDrops(List<ItemStack> drops, LootContext.Builder builder) {
        Object object = builder.m_78982_(LootContextParams.f_81462_);
        if (object instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)((Object)object);
            be.addCamoDrops(drops);
        }
        return drops;
    }

    default public CtmPredicate getCtmPredicate() {
        return this.getBlockType().getCtmPredicate();
    }

    @Nonnull
    @Deprecated
    default public BlockState getFacade(@Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nullable Direction side) {
        return Blocks.f_50016_.m_49966_();
    }

    @Nonnull
    default public BlockState getFacade(@Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nullable Direction side, @Nonnull BlockPos connection) {
        BlockEntity blockEntity;
        BlockState state = level.m_8055_(pos);
        if (this.getCtmPredicate().test(state, side) && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getCamoState();
        }
        return Blocks.f_50016_.m_49966_();
    }

    default public boolean isSideHidden(BlockGetter level, BlockPos pos, BlockState state, Direction side) {
        IFramedBlock block;
        Block block2;
        if (level == null) {
            return false;
        }
        BlockPos neighborPos = pos.m_142300_(side);
        BlockState neighborState = level.m_8055_(neighborPos);
        if (FramedBlocksAPI.getInstance().enableIntangibility() && !this.isIntangible(state, level, pos, null) && (block2 = neighborState.m_60734_()) instanceof IFramedBlock && (block = (IFramedBlock)block2).getBlockType().allowMakingIntangible() && block.isIntangible(neighborState, level, neighborPos, null)) {
            return false;
        }
        SideSkipPredicate pred = FramedBlocksAPI.getInstance().detailedCullingEnabled() ? this.getBlockType().getSideSkipPredicate() : SideSkipPredicate.CTM;
        return pred.test(level, pos, state, neighborState, side);
    }

    default public float getCamoSlipperiness(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        FramedBlockEntity be;
        BlockState camoState;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && !(camoState = (be = (FramedBlockEntity)blockEntity).getCamoState(Direction.UP)).m_60795_()) {
            return camoState.getFriction(level, pos, entity);
        }
        return state.m_60734_().m_49958_();
    }

    default public float getCamoExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        FramedBlockEntity be;
        float resistance;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && (resistance = (be = (FramedBlockEntity)blockEntity).getCamoExplosionResistance(explosion)) > 0.0f) {
            return resistance;
        }
        return state.m_60734_().m_7325_();
    }

    default public boolean isCamoFlammable(BlockGetter level, BlockPos pos, Direction face) {
        if (FramedBlocksAPI.getInstance().areBlocksFireproof()) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.isCamoFlammable(face);
        }
        return true;
    }

    default public int getCamoFlammability(BlockGetter level, BlockPos pos, Direction face) {
        FramedBlockEntity be;
        int flammability;
        if (FramedBlocksAPI.getInstance().areBlocksFireproof()) {
            return 0;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && (flammability = (be = (FramedBlockEntity)blockEntity).getCamoFlammability(face)) > -1) {
            return flammability;
        }
        return 20;
    }

    default public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    default public boolean isIntangible(BlockState state, BlockGetter level, BlockPos pos, @Nullable CollisionContext ctx) {
        FramedBlockEntity be;
        if (!FramedBlocksAPI.getInstance().enableIntangibility() || !this.getBlockType().allowMakingIntangible()) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity instanceof FramedBlockEntity && (be = (FramedBlockEntity)blockEntity).isIntangible(ctx);
    }

    default public boolean isSuffocating(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState stateAtPos;
        if (FramedBlocksAPI.getInstance().enableIntangibility() && this.getBlockType().allowMakingIntangible() && (state != (stateAtPos = level.m_8055_(pos)) || this.isIntangible(state, level, pos, null))) {
            return false;
        }
        return state.m_60767_().m_76334_() && state.m_60838_(level, pos);
    }

    default public boolean useCamoOcclusionShapeForLightOcclusion(BlockState state) {
        if (this.getBlockType() != null && !this.getBlockType().canOccludeWithSolidCamo()) {
            return false;
        }
        return state.m_61138_((Property)FramedProperties.SOLID) && (Boolean)state.m_61143_((Property)FramedProperties.SOLID) != false && (Boolean)state.m_61143_((Property)FramedProperties.GLOWING) == false;
    }

    default public VoxelShape getCamoOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.getBlockType().canOccludeWithSolidCamo() && !((Boolean)state.m_61143_((Property)FramedProperties.SOLID)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return state.m_60808_(level, pos);
    }

    default public VoxelShape getCamoVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (this.getBlockType().canOccludeWithSolidCamo() && !((Boolean)state.m_61143_((Property)FramedProperties.SOLID)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return state.m_60742_(level, pos, ctx);
    }

    default public boolean doesHideNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if (!FramedBlocksAPI.getInstance().canHideNeighborFaceInLevel(level)) {
            return false;
        }
        if (neighborState.m_60734_() instanceof IFramedBlock) {
            return false;
        }
        BlockEntity blockEntity = level.getExistingBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            if (neighborState.m_60734_() instanceof HalfTransparentBlock && SideSkipPredicate.CTM.test(level, pos, state, neighborState, dir)) {
                return true;
            }
            return be.isSolidSide(dir) && !be.isIntangible(null);
        }
        return false;
    }

    default public void onStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        BlockEntity blockEntity;
        if (level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            this.onStateChangeClient(level, pos, oldState, newState, be);
        }
    }

    default public void onStateChangeClient(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState, FramedBlockEntity be) {
        be.m_155250_(newState);
        if (this.needCullingUpdateAfterStateChange(level, oldState, newState)) {
            be.updateCulling(true, false);
        }
    }

    default public void updateCulling(LevelAccessor level, BlockPos pos, @Nullable BlockState neighborState, @Nullable Direction side, boolean rerender) {
        BlockEntity blockEntity;
        Preconditions.checkArgument((side == null || neighborState != null ? 1 : 0) != 0, (Object)"Neighbor BlockState cannot be null when a side is provided");
        if (level.m_5776_() && (side == null || !(neighborState.m_60734_() instanceof IFramedBlock)) && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            if (side != null) {
                be.updateCulling(side, rerender);
            } else {
                be.updateCulling(true, rerender);
            }
        }
    }

    default public boolean needCullingUpdateAfterStateChange(LevelReader level, BlockState oldState, BlockState newState) {
        if (!level.m_5776_() || oldState.m_60734_() != newState.m_60734_() || oldState == newState) {
            return false;
        }
        if (this.getBlockType().canOccludeWithSolidCamo()) {
            if (oldState.m_61124_((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf((Boolean)oldState.m_61143_((Property)FramedProperties.SOLID) == false)) == newState) {
                return false;
            }
            if (oldState.m_61124_((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf((Boolean)oldState.m_61143_((Property)FramedProperties.GLOWING) == false)) == newState) {
                return false;
            }
        }
        return true;
    }

    default public boolean lockState(Level level, BlockPos pos, Player player, ItemStack stack) {
        if (stack.m_41720_() != Utils.FRAMED_KEY.get()) {
            return false;
        }
        if (!level.m_5776_()) {
            BlockState state = level.m_8055_(pos);
            boolean locked = (Boolean)state.m_61143_((Property)FramedProperties.STATE_LOCKED);
            player.m_5661_((Component)new TranslatableComponent(LOCK_MESSAGE, new Object[]{locked ? STATE_UNLOCKED : STATE_LOCKED}), true);
            level.m_46597_(pos, (BlockState)state.m_61122_((Property)FramedProperties.STATE_LOCKED));
        }
        return true;
    }

    default public BlockState updateShapeLockable(BlockState state, LevelAccessor level, BlockPos pos, Supplier<BlockState> updateShape) {
        if (!((Boolean)state.m_61143_((Property)FramedProperties.STATE_LOCKED)).booleanValue()) {
            return updateShape.get();
        }
        if (this.getBlockType().supportsWaterLogging() && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return state;
    }

    default public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        return this.rotate(state, hit.m_82434_(), rot);
    }

    default public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        return state.m_60717_(rot);
    }

    default public MaterialColor getCamoMapColor(BlockGetter level, BlockPos pos, MaterialColor defaultColor) {
        FramedBlockEntity be;
        MaterialColor color;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && (color = (be = (FramedBlockEntity)blockEntity).getMapColor()) != null) {
            return color;
        }
        return defaultColor;
    }

    default public Optional<MutableComponent> printCamoBlock(CompoundTag beTag) {
        BlockState camoState = NbtUtils.m_129241_((CompoundTag)beTag.m_128469_("camo_state"));
        if (camoState.m_60795_()) {
            return Optional.empty();
        }
        return Optional.of(camoState.m_60734_().m_49954_().m_130940_(ChatFormatting.WHITE));
    }
}

