/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirit;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.item.spirit.MalumSpiritItem;
import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import com.sammy.malum.core.setup.content.block.BlockRegistry;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.RegistryObject;

public class MalumSpiritType {
    public final Color color;
    public final Color endColor;
    public final String identifier;
    protected Supplier<Item> splinterItem;

    public MalumSpiritType(String identifier, Color color, RegistryObject<Item> splinterItem) {
        this.identifier = identifier;
        this.color = color;
        this.endColor = this.createEndColor(color);
        this.splinterItem = splinterItem;
    }

    public MalumSpiritType(String identifier, Color color, Color endColor, RegistryObject<Item> splinterItem) {
        this.identifier = identifier;
        this.color = color;
        this.endColor = endColor;
        this.splinterItem = splinterItem;
    }

    public Component getComponent(int count) {
        return new TextComponent(" " + count + " ").m_7220_((Component)new TranslatableComponent(this.getDescription())).m_130948_(Style.f_131099_.m_178520_(this.color.getRGB()));
    }

    public String getDescription() {
        return "malum.spirit.description." + this.identifier;
    }

    public Color createEndColor(Color color) {
        return new Color(color.getGreen(), color.getBlue(), color.getRed());
    }

    public MalumSpiritItem getSplinterItem() {
        return (MalumSpiritItem)this.splinterItem.get();
    }

    public ResourceLocation getOverlayTexture() {
        return MalumMod.prefix("block/totem/" + this.identifier + "_glow");
    }

    public BlockState getBlockState(boolean isCorrupt, BlockHitResult hit) {
        Block base = isCorrupt ? (Block)BlockRegistry.SOULWOOD_TOTEM_POLE.get() : (Block)BlockRegistry.RUNEWOOD_TOTEM_POLE.get();
        return (BlockState)((BlockState)base.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)hit.m_82434_())).m_61124_((Property)SpiritTypeRegistry.SPIRIT_TYPE_PROPERTY, (Comparable)((Object)this.identifier));
    }
}

