/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirit;

import com.sammy.malum.core.helper.SpiritHelper;
import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public class MalumEntitySpiritData {
    public static final String SOUL_DATA = "soul_data";
    public static final MalumEntitySpiritData EMPTY = new MalumEntitySpiritData(SpiritTypeRegistry.SACRED_SPIRIT, new ArrayList<SpiritWithCount>());
    public final MalumSpiritType primaryType;
    public final int totalCount;
    public final ArrayList<SpiritWithCount> dataEntries;

    public MalumEntitySpiritData(MalumSpiritType primaryType, ArrayList<SpiritWithCount> dataEntries) {
        this.primaryType = primaryType;
        this.totalCount = dataEntries.stream().mapToInt(d -> d.count).sum();
        this.dataEntries = dataEntries;
    }

    public ArrayList<Component> createTooltip() {
        return this.dataEntries.stream().map(SpiritWithCount::getComponent).collect(Collectors.toCollection(ArrayList::new));
    }

    public void saveTo(CompoundTag tag) {
        tag.m_128365_(SOUL_DATA, (Tag)this.save());
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("primaryType", this.primaryType.identifier);
        tag.m_128405_("dataAmount", this.dataEntries.size());
        for (int i = 0; i < this.dataEntries.size(); ++i) {
            CompoundTag dataTag = this.dataEntries.get(i).save(new CompoundTag());
            tag.m_128365_("dataEntry" + i, (Tag)dataTag);
        }
        return tag;
    }

    public static MalumEntitySpiritData load(CompoundTag tag) {
        CompoundTag nbt = tag.m_128469_(SOUL_DATA);
        String type = nbt.m_128461_("primaryType");
        int dataAmount = nbt.m_128451_("dataAmount");
        if (dataAmount == 0) {
            return EMPTY;
        }
        ArrayList<SpiritWithCount> data = new ArrayList<SpiritWithCount>();
        for (int i = 0; i < dataAmount; ++i) {
            data.add(SpiritWithCount.load(nbt.m_128469_("dataEntry" + i)));
        }
        return new MalumEntitySpiritData(SpiritHelper.getSpiritType(type), data);
    }
}

