/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.rites;

import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.ortus.helpers.BlockHelper;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class MalumRiteType {
    public ArrayList<MalumSpiritType> spirits;
    public String identifier;

    public MalumRiteType(String identifier, MalumSpiritType ... spirits) {
        this.identifier = identifier;
        this.spirits = new ArrayList<MalumSpiritType>(Arrays.asList(spirits));
    }

    public String translationIdentifier() {
        return "malum.gui.rite." + this.identifier;
    }

    public boolean isInstant(boolean corrupted) {
        return false;
    }

    public int defaultRange() {
        return 8;
    }

    public int range(boolean corrupted) {
        return this.defaultRange();
    }

    public int defaultInterval() {
        return 20;
    }

    public int interval(boolean corrupted) {
        return this.defaultInterval();
    }

    public void executeRite(Level level, BlockPos pos, int height, boolean corrupted) {
        if (corrupted) {
            this.corruptedRiteEffect(level, pos, height);
        } else {
            this.riteEffect(level, pos, height);
        }
    }

    public void riteEffect(Level level, BlockPos pos, int height) {
    }

    public void corruptedRiteEffect(Level level, BlockPos pos, int height) {
    }

    public <T extends LivingEntity> ArrayList<T> getNearbyEntities(Class<T> clazz, Level level, BlockPos pos, boolean corrupted) {
        return (ArrayList)level.m_45976_(clazz, new AABB(pos).m_82400_((double)this.range(corrupted)));
    }

    public ArrayList<BlockPos> getNearbyBlocks(Class<?> clazz, Level level, BlockPos pos, boolean corrupted) {
        return BlockHelper.getBlocks((BlockPos)pos, (int)this.range(corrupted), p -> clazz.isInstance(level.m_8055_(p).m_60734_()));
    }

    public ArrayList<BlockPos> getNearbyBlocks(Class<?> clazz, Level level, BlockPos pos, int height, boolean corrupted) {
        int range = this.range(corrupted);
        return BlockHelper.getBlocks((BlockPos)pos, (int)range, (int)height, (int)range, p -> clazz.isInstance(level.m_8055_(p).m_60734_()));
    }

    public ArrayList<BlockPos> getNearbyBlocksUnderBase(Class<?> clazz, Level level, BlockPos pos, boolean corrupted) {
        return BlockHelper.getPlaneOfBlocks((BlockPos)pos.m_7495_(), (int)this.range(corrupted), p -> clazz.isInstance(level.m_8055_(p).m_60734_()));
    }
}

