/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.setup.content.item;

import com.sammy.malum.core.setup.content.item.ItemRegistry;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ArmorTiers {

    public static enum ArmorTierEnum implements ArmorMaterial
    {
        SPIRIT_HUNTER("malum:spirit_hunter", 16, new int[]{2, 4, 5, 1}, 15, () -> SoundEvents.f_11678_, (Supplier<Item>)ItemRegistry.SPIRIT_FABRIC, 0.0f),
        SOUL_STAINED_STEEL("malum:soul_stained_steel", 22, new int[]{2, 6, 7, 3}, 11, () -> SoundEvents.f_11677_, (Supplier<Item>)ItemRegistry.SOUL_STAINED_STEEL_INGOT, 2.0f),
        SOUL_STAINED_STRONGHOLD("malum:soul_stained_stronghold", 36, new int[]{4, 7, 9, 5}, 13, () -> SoundEvents.f_11677_, (Supplier<Item>)ItemRegistry.SOUL_STAINED_STEEL_INGOT, 5.0f);

        private final String name;
        private final int durabilityMultiplier;
        private final int[] damageReduction;
        private final int enchantability;
        private final Supplier<SoundEvent> equipSound;
        private final Supplier<Item> repairItem;
        private final float toughness;
        private static final int[] MAX_DAMAGE_ARRAY;

        private ArmorTierEnum(String name, int durabilityMultiplier, int[] damageReduction, int enchantability, Supplier<SoundEvent> equipSound, Supplier<Item> repairItem, float toughness) {
            this.name = name;
            this.durabilityMultiplier = durabilityMultiplier;
            this.damageReduction = damageReduction;
            this.enchantability = enchantability;
            this.equipSound = equipSound;
            this.repairItem = repairItem;
            this.toughness = toughness;
        }

        public int m_7366_(EquipmentSlot slot) {
            return this.durabilityMultiplier * MAX_DAMAGE_ARRAY[slot.m_20749_()];
        }

        public int m_7365_(EquipmentSlot slot) {
            return this.damageReduction[slot.m_20749_()];
        }

        public int m_6646_() {
            return this.enchantability;
        }

        @Nonnull
        public SoundEvent m_7344_() {
            return this.equipSound.get();
        }

        @Nonnull
        public Ingredient m_6230_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)this.repairItem.get()});
        }

        @Nonnull
        public String m_6082_() {
            return this.name;
        }

        public float m_6651_() {
            return this.toughness;
        }

        public float m_6649_() {
            if (this.equals((Object)SOUL_STAINED_STRONGHOLD)) {
                return 0.1f;
            }
            return 0.0f;
        }

        static {
            MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
        }
    }
}

