/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.setup.content.block;

import com.sammy.malum.client.renderer.block.ItemPedestalRenderer;
import com.sammy.malum.client.renderer.block.ItemStandRenderer;
import com.sammy.malum.client.renderer.block.PlinthRenderer;
import com.sammy.malum.client.renderer.block.SoulVialRenderer;
import com.sammy.malum.client.renderer.block.SpiritAltarRenderer;
import com.sammy.malum.client.renderer.block.SpiritCatalyzerRenderer;
import com.sammy.malum.client.renderer.block.SpiritCrucibleRenderer;
import com.sammy.malum.client.renderer.block.SpiritJarRenderer;
import com.sammy.malum.client.renderer.block.TotemPoleRenderer;
import com.sammy.malum.common.block.ether.EtherBlock;
import com.sammy.malum.common.block.fusion_plate.FusionPlateCoreBlock;
import com.sammy.malum.common.block.mirror.EmitterMirrorBlock;
import com.sammy.malum.common.block.obelisk.BrillianceObeliskCoreBlock;
import com.sammy.malum.common.block.obelisk.RunewoodObeliskCoreBlock;
import com.sammy.malum.common.block.spirit_altar.SpiritAltarBlock;
import com.sammy.malum.common.block.spirit_crucible.SpiritCatalyzerCoreBlock;
import com.sammy.malum.common.block.spirit_crucible.SpiritCrucibleCoreBlock;
import com.sammy.malum.common.block.storage.ItemPedestalBlock;
import com.sammy.malum.common.block.storage.ItemStandBlock;
import com.sammy.malum.common.block.storage.PlinthCoreBlock;
import com.sammy.malum.common.block.storage.SoulVialBlock;
import com.sammy.malum.common.block.storage.SpiritJarBlock;
import com.sammy.malum.common.block.tablet.TwistedTabletBlock;
import com.sammy.malum.common.block.totem.TotemBaseBlock;
import com.sammy.malum.common.block.totem.TotemPoleBlock;
import com.sammy.malum.common.blockentity.EtherBlockEntity;
import com.sammy.malum.common.blockentity.FusionPlateBlockEntity;
import com.sammy.malum.common.blockentity.altar.SpiritAltarTileEntity;
import com.sammy.malum.common.blockentity.crucible.SpiritCatalyzerCoreBlockEntity;
import com.sammy.malum.common.blockentity.crucible.SpiritCrucibleCoreBlockEntity;
import com.sammy.malum.common.blockentity.mirror.EmitterMirrorBlockEntity;
import com.sammy.malum.common.blockentity.obelisk.BrilliantObeliskBlockEntity;
import com.sammy.malum.common.blockentity.obelisk.RunewoodObeliskBlockEntity;
import com.sammy.malum.common.blockentity.storage.ItemPedestalBlockEntity;
import com.sammy.malum.common.blockentity.storage.ItemStandBlockEntity;
import com.sammy.malum.common.blockentity.storage.PlinthCoreBlockEntity;
import com.sammy.malum.common.blockentity.storage.SoulVialBlockEntity;
import com.sammy.malum.common.blockentity.storage.SpiritJarBlockEntity;
import com.sammy.malum.common.blockentity.tablet.TwistedTabletBlockEntity;
import com.sammy.malum.common.blockentity.totem.TotemBaseTileEntity;
import com.sammy.malum.common.blockentity.totem.TotemPoleTileEntity;
import com.sammy.malum.core.setup.content.block.BlockRegistry;
import com.sammy.ortus.setup.OrtusBlockEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockEntityRegistry {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"malum");
    public static final RegistryObject<BlockEntityType<SpiritAltarTileEntity>> SPIRIT_ALTAR = BLOCK_ENTITY_TYPES.register("spirit_altar", () -> BlockEntityType.Builder.m_155273_(SpiritAltarTileEntity::new, (Block[])BlockEntityRegistry.getBlocks(SpiritAltarBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<SpiritJarBlockEntity>> SPIRIT_JAR = BLOCK_ENTITY_TYPES.register("spirit_jar", () -> BlockEntityType.Builder.m_155273_(SpiritJarBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(SpiritJarBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<SoulVialBlockEntity>> SOUL_VIAL = BLOCK_ENTITY_TYPES.register("soul_vial", () -> BlockEntityType.Builder.m_155273_(SoulVialBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(SoulVialBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<SpiritCrucibleCoreBlockEntity>> SPIRIT_CRUCIBLE = BLOCK_ENTITY_TYPES.register("spirit_crucible", () -> BlockEntityType.Builder.m_155273_(SpiritCrucibleCoreBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(SpiritCrucibleCoreBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<SpiritCatalyzerCoreBlockEntity>> SPIRIT_CATALYZER = BLOCK_ENTITY_TYPES.register("spirit_catalyzer", () -> BlockEntityType.Builder.m_155273_(SpiritCatalyzerCoreBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(SpiritCatalyzerCoreBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<TwistedTabletBlockEntity>> TWISTED_TABLET = BLOCK_ENTITY_TYPES.register("twisted_tablet", () -> BlockEntityType.Builder.m_155273_(TwistedTabletBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(TwistedTabletBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<RunewoodObeliskBlockEntity>> RUNEWOOD_OBELISK = BLOCK_ENTITY_TYPES.register("runewood_obelisk", () -> BlockEntityType.Builder.m_155273_(RunewoodObeliskBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(RunewoodObeliskCoreBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<BrilliantObeliskBlockEntity>> BRILLIANT_OBELISK = BLOCK_ENTITY_TYPES.register("brilliant_obelisk", () -> BlockEntityType.Builder.m_155273_(BrilliantObeliskBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(BrillianceObeliskCoreBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<PlinthCoreBlockEntity>> PLINTH = BLOCK_ENTITY_TYPES.register("plinth", () -> BlockEntityType.Builder.m_155273_(PlinthCoreBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(PlinthCoreBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<FusionPlateBlockEntity>> FUSION_PLATE = BLOCK_ENTITY_TYPES.register("fusion_plate", () -> BlockEntityType.Builder.m_155273_(FusionPlateBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(FusionPlateCoreBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<EtherBlockEntity>> ETHER = BLOCK_ENTITY_TYPES.register("ether", () -> BlockEntityType.Builder.m_155273_(EtherBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(EtherBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<ItemStandBlockEntity>> ITEM_STAND = BLOCK_ENTITY_TYPES.register("item_stand", () -> BlockEntityType.Builder.m_155273_(ItemStandBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(ItemStandBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<ItemPedestalBlockEntity>> ITEM_PEDESTAL = BLOCK_ENTITY_TYPES.register("item_pedestal", () -> BlockEntityType.Builder.m_155273_(ItemPedestalBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(ItemPedestalBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<EmitterMirrorBlockEntity>> EMITTER_MIRROR = BLOCK_ENTITY_TYPES.register("emitter_mirror", () -> BlockEntityType.Builder.m_155273_(EmitterMirrorBlockEntity::new, (Block[])BlockEntityRegistry.getBlocks(EmitterMirrorBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<TotemBaseTileEntity>> TOTEM_BASE = BLOCK_ENTITY_TYPES.register("totem_base", () -> BlockEntityType.Builder.m_155273_(TotemBaseTileEntity::new, (Block[])BlockEntityRegistry.getBlocks(TotemBaseBlock.class)).m_58966_(null));
    public static final RegistryObject<BlockEntityType<TotemPoleTileEntity>> TOTEM_POLE = BLOCK_ENTITY_TYPES.register("totem_pole", () -> BlockEntityType.Builder.m_155273_(TotemPoleTileEntity::new, (Block[])BlockEntityRegistry.getBlocks(TotemPoleBlock.class)).m_58966_(null));

    public static Block[] getBlocks(Class<?> ... blockClasses) {
        Collection blocks = BlockRegistry.BLOCKS.getEntries();
        ArrayList<Block> matchingBlocks = new ArrayList<Block>();
        for (RegistryObject registryObject : blocks) {
            if (!Arrays.stream(blockClasses).anyMatch(b -> b.isInstance(registryObject.get()))) continue;
            matchingBlocks.add((Block)registryObject.get());
        }
        return matchingBlocks.toArray(new Block[0]);
    }

    public static Block[] getBlocksExact(Class<?> clazz) {
        Collection blocks = BlockRegistry.BLOCKS.getEntries();
        ArrayList<Block> matchingBlocks = new ArrayList<Block>();
        for (RegistryObject registryObject : blocks) {
            if (!clazz.equals(((Block)registryObject.get()).getClass())) continue;
            matchingBlocks.add((Block)registryObject.get());
        }
        return matchingBlocks.toArray(new Block[0]);
    }

    @Mod.EventBusSubscriber(modid="malum", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientOnly {
        @SubscribeEvent
        public static void registerRenderer(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)SPIRIT_ALTAR.get(), SpiritAltarRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)SPIRIT_CRUCIBLE.get(), SpiritCrucibleRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)SPIRIT_CATALYZER.get(), SpiritCatalyzerRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)TWISTED_TABLET.get(), ItemStandRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)PLINTH.get(), PlinthRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)TOTEM_POLE.get(), TotemPoleRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ITEM_STAND.get(), ItemStandRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ITEM_PEDESTAL.get(), ItemPedestalRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)SPIRIT_JAR.get(), SpiritJarRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)SOUL_VIAL.get(), SoulVialRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)OrtusBlockEntities.SIGN.get(), SignRenderer::new);
        }
    }
}

