/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.helper;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.entity.spirit.SpiritItemEntity;
import com.sammy.malum.core.listeners.SpiritDataReloadListener;
import com.sammy.malum.core.setup.content.AttributeRegistry;
import com.sammy.malum.core.setup.content.SoundRegistry;
import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import com.sammy.malum.core.setup.content.item.MalumEnchantments;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.MalumEntitySpiritData;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.ortus.helpers.ItemHelper;
import com.sammy.ortus.setup.OrtusParticles;
import com.sammy.ortus.setup.OrtusScreenParticles;
import com.sammy.ortus.systems.easing.Easing;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import com.sammy.ortus.systems.rendering.particle.screen.ScreenParticleType;
import com.sammy.ortus.systems.rendering.particle.screen.base.ScreenParticle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class SpiritHelper {
    public static void createSpiritsFromSoul(MalumEntitySpiritData data, Level level, Vec3 position, LivingEntity attacker) {
        ArrayList<ItemStack> spirits = SpiritHelper.getSpiritItemStacks(data, attacker, ItemStack.f_41583_, 2.0f);
        SpiritHelper.createSpiritEntities(spirits, data.totalCount, level, position, attacker);
    }

    public static void createSpiritsFromWeapon(LivingEntity target, LivingEntity attacker, ItemStack harvestStack) {
        ArrayList<ItemStack> spirits = SpiritHelper.getSpiritItemStacks(target, attacker, harvestStack, 1.0f);
        SpiritHelper.createSpiritEntities(spirits, target, attacker);
    }

    public static void createSpiritEntities(LivingEntity target, LivingEntity attacker) {
        ArrayList<ItemStack> spirits = SpiritHelper.getSpiritItemStacks(target);
        if (!spirits.isEmpty()) {
            SpiritHelper.createSpiritEntities(spirits, target, attacker);
        }
    }

    public static void createSpiritEntities(LivingEntity target) {
        ArrayList<ItemStack> spirits = SpiritHelper.getSpiritItemStacks(target);
        if (!spirits.isEmpty()) {
            SpiritHelper.createSpiritEntities(spirits, target, null);
        }
    }

    public static void createSpiritEntities(ArrayList<ItemStack> spirits, LivingEntity target, LivingEntity attacker) {
        if (spirits.isEmpty()) {
            return;
        }
        SpiritHelper.createSpiritEntities(spirits, spirits.stream().mapToInt(ItemStack::m_41613_).sum(), target.f_19853_, target.m_20182_().m_82520_(0.0, (double)(target.m_20192_() / 2.0f), 0.0), attacker);
    }

    public static void createSpiritEntities(MalumEntitySpiritData data, Level level, Vec3 position, LivingEntity attacker) {
        SpiritHelper.createSpiritEntities(SpiritHelper.getSpiritItemStacks(data), data.totalCount, level, position, attacker);
    }

    public static void createSpiritEntities(ArrayList<ItemStack> spirits, float totalCount, Level level, Vec3 position, @Nullable LivingEntity attacker) {
        if (attacker == null) {
            attacker = level.m_5788_(position.f_82479_, position.f_82480_, position.f_82481_, 8.0, e -> true);
        }
        float speed = 0.1f + 0.2f / (totalCount + 1.0f);
        for (ItemStack stack : spirits) {
            int count = stack.m_41613_();
            if (count == 0) continue;
            for (int j = 0; j < count; ++j) {
                SpiritItemEntity entity = new SpiritItemEntity(level, attacker == null ? null : attacker.m_142081_(), ItemHelper.copyWithNewCount((ItemStack)stack, (int)1), position.f_82479_, position.f_82480_, position.f_82481_, Mth.m_14068_((Random)MalumMod.RANDOM, (float)(-speed), (float)speed), Mth.m_14068_((Random)MalumMod.RANDOM, (float)0.015f, (float)0.05f), Mth.m_14068_((Random)MalumMod.RANDOM, (float)(-speed), (float)speed));
                level.m_7967_((Entity)entity);
            }
        }
        level.m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, (SoundEvent)SoundRegistry.SPIRIT_HARVEST.get(), SoundSource.PLAYERS, 1.0f, 0.7f + level.f_46441_.nextFloat() * 0.4f);
    }

    public static MalumSpiritType getSpiritType(String spirit) {
        MalumSpiritType type = SpiritTypeRegistry.SPIRITS.get(spirit);
        return type == null ? SpiritTypeRegistry.SACRED_SPIRIT : type;
    }

    public static MalumEntitySpiritData getEntitySpiritData(LivingEntity entity) {
        return SpiritDataReloadListener.SPIRIT_DATA.get(entity.m_6095_().getRegistryName());
    }

    public static int getEntitySpiritCount(LivingEntity entity) {
        MalumEntitySpiritData bundle = SpiritHelper.getEntitySpiritData(entity);
        if (bundle == null) {
            return 0;
        }
        return bundle.totalCount;
    }

    public static ArrayList<ItemStack> getSpiritItemStacks(LivingEntity entity, LivingEntity attacker, ItemStack harvestStack, float spoilsMultiplier) {
        return SpiritHelper.getSpiritItemStacks(SpiritHelper.getEntitySpiritData(entity), attacker, harvestStack, spoilsMultiplier);
    }

    public static ArrayList<ItemStack> getSpiritItemStacks(MalumEntitySpiritData data, LivingEntity attacker, ItemStack harvestStack, float spoilsMultiplier) {
        ArrayList<ItemStack> spirits = SpiritHelper.getSpiritItemStacks(data);
        if (spirits.isEmpty()) {
            return spirits;
        }
        int spiritBonus = 0;
        if (attacker.m_21051_((Attribute)AttributeRegistry.SPIRIT_SPOILS.get()) != null) {
            spiritBonus = (int)((double)spiritBonus + attacker.m_21133_((Attribute)AttributeRegistry.SPIRIT_SPOILS.get()));
        }
        if (!harvestStack.m_41619_()) {
            int spiritPlunder = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)MalumEnchantments.SPIRIT_PLUNDER.get()), (ItemStack)harvestStack);
            if (spiritPlunder > 0) {
                harvestStack.m_41622_(spiritPlunder, attacker, e -> e.m_21166_(EquipmentSlot.MAINHAND));
            }
            spiritBonus += spiritPlunder;
        }
        int i = 0;
        while ((float)i < (float)spiritBonus * spoilsMultiplier) {
            int random = attacker.f_19853_.f_46441_.nextInt(spirits.size());
            spirits.get(random).m_41769_(1);
            ++i;
        }
        return spirits;
    }

    public static ArrayList<ItemStack> getSpiritItemStacks(LivingEntity entity) {
        return SpiritHelper.getSpiritItemStacks(SpiritHelper.getEntitySpiritData(entity));
    }

    public static ArrayList<ItemStack> getSpiritItemStacks(MalumEntitySpiritData data) {
        ArrayList<ItemStack> spirits = new ArrayList<ItemStack>();
        if (data == null) {
            return spirits;
        }
        for (SpiritWithCount spiritWithCount : data.dataEntries) {
            spirits.add(new ItemStack((ItemLike)spiritWithCount.type.getSplinterItem(), spiritWithCount.count));
        }
        return spirits;
    }

    public static void spawnSpiritParticles(Level level, double x, double y, double z, Color color, Color endColor) {
        SpiritHelper.spawnSpiritParticles(level, x, y, z, 1.0f, Vec3.f_82478_, color, endColor);
    }

    public static void spawnSpiritParticles(Level level, double x, double y, double z, float alphaMultiplier, Vec3 extraVelocity, Color color, Color endColor) {
        Random rand = level.m_5822_();
        ParticleBuilders.create((RegistryObject)OrtusParticles.TWINKLE_PARTICLE).setAlpha(0.21f * alphaMultiplier, 0.0f).setLifetime(10 + rand.nextInt(4)).setScale(0.3f + rand.nextFloat() * 0.1f, 0.0f).setColor(color, endColor).setColorCurveMultiplier(2.0f).randomOffset((double)0.05f).enableNoClip().addMotion(extraVelocity.f_82479_, extraVelocity.f_82480_, extraVelocity.f_82481_).randomMotion((double)0.02f, (double)0.02f).repeat(level, x, y, z, 1);
        ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(0.1f * alphaMultiplier, 0.0f).setLifetime(20 + rand.nextInt(4)).setSpin(Mth.m_14068_((Random)rand, (float)0.05f, (float)0.1f)).setScale(0.2f + rand.nextFloat() * 0.05f, 0.0f).setColor(color, endColor).setColorCurveMultiplier(1.25f).randomOffset((double)0.1f).enableNoClip().addMotion(extraVelocity.f_82479_, extraVelocity.f_82480_, extraVelocity.f_82481_).randomMotion((double)0.02f, (double)0.02f).repeat(level, x, y, z, 1).setAlpha(0.2f * alphaMultiplier, 0.0f).setLifetime(10 + rand.nextInt(2)).setSpin(Mth.m_14068_((Random)rand, (float)0.05f, (float)0.1f)).setScale(0.15f + rand.nextFloat() * 0.05f, 0.0f).randomMotion((double)0.01f, (double)0.01f).repeat(level, x, y, z, 1);
    }

    public static void spawnSoulParticles(Level level, double x, double y, double z, Color color, Color endColor) {
        SpiritHelper.spawnSoulParticles(level, x, y, z, 1.0f, 1.0f, Vec3.f_82478_, color, endColor);
    }

    public static void spawnSoulParticles(Level level, double x, double y, double z, float alphaMultiplier, float scaleMultiplier, Vec3 extraVelocity, Color color, Color endColor) {
        Random rand = level.m_5822_();
        ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(0.1f * alphaMultiplier, 0.0f).setLifetime(8 + rand.nextInt(5)).setScale((0.2f + rand.nextFloat() * 0.2f) * scaleMultiplier, 0.0f).setScaleEasing(Easing.QUINTIC_IN).setColor(color, endColor).randomOffset((double)0.05f).enableNoClip().addMotion(extraVelocity.f_82479_, extraVelocity.f_82480_, extraVelocity.f_82481_).randomMotion((double)(0.01f * scaleMultiplier), (double)(0.01f * scaleMultiplier)).repeat(level, x, y, z, 1);
        ParticleBuilders.create((RegistryObject)OrtusParticles.SMOKE_PARTICLE).setAlpha(0.0f, 0.05f * alphaMultiplier, 0.0f).setAlphaEasing(Easing.CUBIC_IN, Easing.CUBIC_OUT).setLifetime(80 + rand.nextInt(10)).setSpin(0.0f, Mth.m_14068_((Random)rand, (float)0.05f, (float)0.4f)).setSpinOffset(0.05f * (float)level.m_46467_() % 6.28f).setSpinEasing(Easing.CUBIC_OUT).setScale((0.2f + rand.nextFloat() * 0.1f) * scaleMultiplier, 0.1f * scaleMultiplier).setScaleEasing(Easing.QUINTIC_IN).setColor(color, endColor).randomOffset((double)0.1f).enableNoClip().addMotion(extraVelocity.f_82479_, extraVelocity.f_82480_, extraVelocity.f_82481_).randomMotion((double)(0.01f * scaleMultiplier), (double)(0.01f * scaleMultiplier)).repeat(level, x, y, z, 1).setAlpha(0.12f * alphaMultiplier, 0.0f).setLifetime(10 + rand.nextInt(5)).setSpin(0.0f, Mth.m_14068_((Random)rand, (float)0.1f, (float)0.5f)).setScale((0.15f + rand.nextFloat() * 0.1f) * scaleMultiplier, 0.1f * scaleMultiplier).randomMotion((double)(0.03f * scaleMultiplier), (double)(0.03f * scaleMultiplier)).repeat(level, x, y, z, 2);
        ParticleBuilders.create((RegistryObject)OrtusParticles.STAR_PARTICLE).setAlpha((rand.nextFloat() * 0.1f + 0.1f) * alphaMultiplier, 0.0f).setLifetime(20 + rand.nextInt(10)).setSpinOffset(0.025f * (float)level.m_46467_() % 6.28f).setSpin(0.0f, Mth.m_14068_((Random)rand, (float)0.05f, (float)0.4f)).setScale((0.7f + rand.nextFloat() * 0.1f) * scaleMultiplier, 0.1f * scaleMultiplier).setColor(color, endColor).randomOffset((double)0.01f).enableNoClip().addMotion(extraVelocity.f_82479_, extraVelocity.f_82480_, extraVelocity.f_82481_).repeat(level, x, y, z, 1).setLifetime(10 + rand.nextInt(5)).setAlpha((rand.nextFloat() * 0.05f + 0.05f) * alphaMultiplier, 0.0f).setSpin(0.0f, Mth.m_14068_((Random)rand, (float)0.1f, (float)0.5f)).setScale((0.5f + rand.nextFloat() * 0.1f) * scaleMultiplier, 0.1f * scaleMultiplier).repeat(level, x, y, z, 1);
    }

    public static void spawnSpiritScreenParticles(Color color, Color endColor, ItemStack stack, float pXPosition, float pYPosition, ScreenParticle.RenderOrder renderOrder) {
        Random rand = Minecraft.m_91087_().f_91073_.m_5822_();
        ParticleBuilders.create((ScreenParticleType)OrtusScreenParticles.SPARKLE).setAlpha(0.08f, 0.0f).setLifetime(10 + rand.nextInt(10)).setScale(0.8f + rand.nextFloat() * 0.1f, 0.0f).setColor(color, endColor).setColorCurveMultiplier(2.0f).randomOffset((double)0.05f).randomMotion((double)0.05f, (double)0.05f).overwriteRenderOrder(renderOrder).centerOnStack(stack).repeat((double)pXPosition, (double)pYPosition, 1);
        ParticleBuilders.create((ScreenParticleType)OrtusScreenParticles.WISP).setAlpha(0.02f, 0.0f).setLifetime(20 + rand.nextInt(8)).setSpin(Mth.m_14068_((Random)rand, (float)0.2f, (float)0.4f)).setScale(0.6f + rand.nextFloat() * 0.4f, 0.0f).setColor(color, endColor).setColorCurveMultiplier(1.25f).randomOffset((double)0.1f).randomMotion((double)0.4f, (double)0.4f).overwriteRenderOrder(renderOrder).centerOnStack(stack).repeat((double)pXPosition, (double)pYPosition, 1).setLifetime(10 + rand.nextInt(2)).setSpin(Mth.m_14068_((Random)rand, (float)0.05f, (float)0.1f)).setScale(0.8f + rand.nextFloat() * 0.4f, 0.0f).randomMotion((double)0.01f, (double)0.01f).repeat((double)pXPosition, (double)pYPosition, 1);
    }
}

