/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.sammy.malum.common.capability.LivingEntityDataCapability;
import com.sammy.malum.common.entity.boomerang.ScytheBoomerangEntity;
import com.sammy.malum.common.item.spirit.SpiritPouchItem;
import com.sammy.malum.compability.tetra.TetraCompat;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.core.helper.SpiritHelper;
import com.sammy.malum.core.setup.content.DamageSourceRegistry;
import com.sammy.malum.core.setup.content.item.ItemTagRegistry;
import com.sammy.malum.core.systems.item.IMalumEventResponderItem;
import com.sammy.ortus.helpers.ItemHelper;
import com.sammy.ortus.systems.container.ItemInventory;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class SpiritHarvestHandler {
    public static void exposeSoul(LivingHurtEvent event) {
        if (event.isCanceled() || event.getAmount() <= 0.0f) {
            return;
        }
        LivingEntity target = event.getEntityLiving();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            ItemStack stack = attacker.m_21205_();
            if (event.getSource().m_7640_() instanceof ScytheBoomerangEntity) {
                stack = ((ScytheBoomerangEntity)event.getSource().m_7640_()).scythe;
            }
            if (stack.m_204117_(ItemTagRegistry.SOUL_HUNTER_WEAPON) || TetraCompat.LOADED && TetraCompat.LoadedOnly.hasSoulStrike(stack)) {
                LivingEntityDataCapability.getCapability(target).ifPresent(e -> {
                    e.exposedSoul = 200.0f;
                });
            }
        }
        if (event.getSource().m_7640_() != null && event.getSource().m_7640_().m_19880_().contains("malum:soul_arrow")) {
            LivingEntityDataCapability.getCapability(target).ifPresent(e -> {
                e.exposedSoul = 200.0f;
            });
        }
    }

    public static void shatterSoul(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getSource().m_19385_().equals(DamageSourceRegistry.FORCED_SHATTER.m_19385_())) {
            SpiritHelper.createSpiritEntities(event.getEntityLiving());
            return;
        }
        LivingEntity target = event.getEntityLiving();
        LivingEntity attacker = null;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity directAttacker;
            attacker = directAttacker = (LivingEntity)entity;
        }
        if (attacker == null) {
            attacker = target.m_142581_();
        }
        if (attacker != null) {
            LivingEntity finalAttacker = attacker;
            ItemStack stack = attacker.m_21205_();
            DamageSource source = event.getSource();
            Entity entity2 = source.m_7640_();
            if (entity2 instanceof ScytheBoomerangEntity) {
                ScytheBoomerangEntity scytheBoomerang = (ScytheBoomerangEntity)entity2;
                stack = scytheBoomerang.scythe;
            }
            if (!(target instanceof Player)) {
                ItemStack finalStack = stack;
                if (!event.getSource().m_19385_().equals("voodoo_no_shatter")) {
                    LivingEntityDataCapability.getCapability(target).ifPresent(e -> {
                        if (e.exposedSoul > 0.0f && !e.soulless && (!((Boolean)CommonConfig.SOULLESS_SPAWNERS.getConfigValue()).booleanValue() || ((Boolean)CommonConfig.SOULLESS_SPAWNERS.getConfigValue()).booleanValue() && !e.spawnerSpawned)) {
                            SpiritHelper.createSpiritsFromWeapon(target, finalAttacker, finalStack);
                            e.soulless = true;
                        }
                    });
                }
            }
        }
    }

    public static void pickupSpirit(ItemStack stack, LivingEntity collector) {
        if (collector instanceof Player) {
            Player playerEntity = (Player)collector;
            ItemHelper.getEventResponders((LivingEntity)collector).forEach(s -> {
                Item patt4285$temp = s.m_41720_();
                if (patt4285$temp instanceof IMalumEventResponderItem) {
                    IMalumEventResponderItem eventItem = (IMalumEventResponderItem)patt4285$temp;
                    eventItem.pickupSpirit(collector, stack, true);
                }
            });
            for (NonNullList playerInventory : playerEntity.m_150109_().f_35979_) {
                for (ItemStack item : playerInventory) {
                    ItemInventory inventory;
                    ItemStack result;
                    if (!(item.m_41720_() instanceof SpiritPouchItem) || !(result = (inventory = SpiritPouchItem.getInventory(item)).m_19173_(stack)).m_41619_()) continue;
                    Level level = playerEntity.f_19853_;
                    level.m_6263_(null, playerEntity.m_20185_(), playerEntity.m_20186_() + 0.5, playerEntity.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    return;
                }
            }
        }
        ItemHelper.giveItemToEntity((ItemStack)stack, (LivingEntity)collector);
    }
}

