/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.capability.LivingEntityDataCapability;
import com.sammy.malum.common.capability.PlayerDataCapability;
import com.sammy.malum.common.entity.spirit.SoulEntity;
import com.sammy.malum.common.item.spirit.SoulStaveItem;
import com.sammy.malum.common.packets.particle.SoulPurgeParticlePacket;
import com.sammy.malum.core.helper.SpiritHelper;
import com.sammy.malum.core.setup.server.PacketRegistry;
import com.sammy.ortus.handlers.RenderHandler;
import com.sammy.ortus.helpers.RenderHelper;
import com.sammy.ortus.setup.OrtusRenderTypes;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.network.PacketDistributor;

public class SoulHarvestHandler {
    public static void specialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        Entity entity;
        if (event.getSpawnReason() != null && (entity = event.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            LivingEntityDataCapability.getCapability(livingEntity).ifPresent(ec -> {
                if (event.getSpawnReason().equals((Object)MobSpawnType.SPAWNER)) {
                    ec.spawnerSpawned = true;
                }
            });
        }
    }

    public static void addEntity(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            LivingEntityDataCapability.getCapability(livingEntity).ifPresent(ec -> {
                ec.spiritData = SpiritHelper.getEntitySpiritData(livingEntity);
                if (livingEntity instanceof Mob) {
                    Mob mob = (Mob)livingEntity;
                    if (ec.soulless) {
                        SoulHarvestHandler.removeSentience(mob);
                    }
                }
            });
        }
    }

    public static void entityTarget(LivingSetAttackTargetEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            LivingEntityDataCapability.getCapability((LivingEntity)mob).ifPresent(ec -> {
                if (ec.soulless) {
                    mob.f_21362_ = null;
                }
            });
        }
    }

    public static void entityTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        LivingEntityDataCapability.getCapability(entity).ifPresent(ec -> {
            Player player;
            if (ec.exposedSoul > 0.0f) {
                ec.exposedSoul -= 1.0f;
            }
            if (ec.ownerUUID != null && ec.soulHarvestProgress > 0.0f && (player = entity.f_19853_.m_46003_(ec.ownerUUID)) != null) {
                PlayerDataCapability.getCapability(player).ifPresent(c -> {
                    if (!player.m_6117_() && ec.soulHarvestProgress > 10.0f) {
                        ec.soulHarvestProgress -= 2.0f;
                    }
                    if (!(!(ec.soulHarvestProgress <= 10.0f) || ec.soulless || c.targetedSoulUUID != null && entity.m_142081_().equals(c.targetedSoulUUID))) {
                        ec.soulHarvestProgress -= 0.5f;
                        if (ec.soulHarvestProgress == 0.0f) {
                            ec.ownerUUID = null;
                        }
                    }
                });
            }
        });
    }

    public static void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        PlayerDataCapability.getCapability(player).ifPresent(c -> {
            boolean isHoldingStave = player.m_21093_(s -> s.m_41720_() instanceof SoulStaveItem);
            if (isHoldingStave) {
                LivingEntity livingEntity;
                Entity entity;
                int harvestVFXCap;
                boolean isUsingStave = player.m_6117_();
                int n = harvestVFXCap = isUsingStave ? 160 : 10;
                if (c.targetedSoulUUID != null && (entity = player.f_19853_.m_6815_(c.targetedSoulId)) instanceof LivingEntity) {
                    livingEntity = (LivingEntity)entity;
                    LivingEntityDataCapability.getCapability(livingEntity).ifPresent(ec -> {
                        if (ec.soulHarvestProgress < (float)harvestVFXCap) {
                            ec.soulHarvestProgress += 1.0f;
                        }
                    });
                }
                if (isUsingStave) {
                    if (player.f_19853_ instanceof ServerLevel && c.targetedSoulUUID != null && (entity = player.f_19853_.m_6815_(c.targetedSoulId)) instanceof LivingEntity) {
                        livingEntity = (LivingEntity)entity;
                        LivingEntityDataCapability.getCapability(livingEntity).ifPresent(ec -> {
                            if (ec.getHarvestProgress() >= 150.0f) {
                                Vec3 position = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20192_() / 2.0f), 0.0);
                                SoulEntity soulEntity = new SoulEntity(entity.f_19853_, SpiritHelper.getEntitySpiritData(livingEntity), player.m_142081_(), position.f_82479_, position.f_82480_, position.f_82481_, Mth.m_14068_((Random)MalumMod.RANDOM, (float)-0.1f, (float)0.1f), 0.05f + Mth.m_14068_((Random)MalumMod.RANDOM, (float)0.05f, (float)0.15f), Mth.m_14068_((Random)MalumMod.RANDOM, (float)-0.1f, (float)0.1f));
                                player.f_19853_.m_7967_((Entity)soulEntity);
                                PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new SoulPurgeParticlePacket(ec.spiritData.primaryType.color, ec.spiritData.primaryType.endColor, position.f_82479_, position.f_82480_, position.f_82481_));
                                if (livingEntity instanceof Mob) {
                                    Mob mob = (Mob)livingEntity;
                                    SoulHarvestHandler.removeSentience(mob);
                                }
                                ec.soulless = true;
                                ec.ownerUUID = player.m_142081_();
                                player.m_21011_(player.m_7655_(), true);
                                player.m_21253_();
                                LivingEntityDataCapability.sync(livingEntity);
                            }
                        });
                    }
                } else {
                    --c.soulFetchCooldown;
                    if (c.soulFetchCooldown <= 0) {
                        c.soulFetchCooldown = 5;
                        ArrayList entities = new ArrayList(player.f_19853_.m_6443_(LivingEntity.class, player.m_142469_().m_82400_(7.0), e -> !e.m_142081_().equals(player.m_142081_())));
                        double biggestAngle = 0.0;
                        LivingEntity chosenEntity = null;
                        for (LivingEntity entity2 : entities) {
                            Vec3 directionToEntity;
                            Vec3 lookDirection;
                            double angle;
                            if (!entity2.m_6084_() || LivingEntityDataCapability.isSoulless(entity2) || !LivingEntityDataCapability.hasSpiritData(entity2) || !((angle = (lookDirection = player.m_20154_()).m_82526_(directionToEntity = entity2.m_20182_().m_82546_(player.m_20182_()).m_82541_())) > biggestAngle) || !(angle > 0.5)) continue;
                            biggestAngle = angle;
                            chosenEntity = entity2;
                        }
                        if (!(chosenEntity == null || chosenEntity.m_142081_().equals(c.targetedSoulUUID) && LivingEntityDataCapability.getOwner(chosenEntity) != null)) {
                            c.targetedSoulUUID = chosenEntity.m_142081_();
                            c.targetedSoulId = chosenEntity.m_142049_();
                            LivingEntityDataCapability.getCapability(chosenEntity).ifPresent(ec -> {
                                ec.ownerUUID = player.m_142081_();
                            });
                            if (chosenEntity.f_19853_ instanceof ServerLevel) {
                                LivingEntityDataCapability.sync(chosenEntity);
                            }
                        }
                        if (chosenEntity == null) {
                            c.targetedSoulUUID = null;
                            c.targetedSoulId = -1;
                        }
                    }
                }
            } else if (c.targetedSoulUUID != null) {
                c.targetedSoulUUID = null;
                c.targetedSoulId = -1;
            }
        });
    }

    public static void removeSentience(Mob mob) {
        mob.f_21345_.m_148105_().removeIf(g -> g.m_26015_() instanceof LookAtPlayerGoal || g.m_26015_() instanceof MeleeAttackGoal || g.m_26015_() instanceof SwellGoal || g.m_26015_() instanceof PanicGoal || g.m_26015_() instanceof RandomLookAroundGoal || g.m_26015_() instanceof AvoidEntityGoal);
    }

    public static class ClientOnly {
        private static final ResourceLocation SOUL_NOISE = MalumMod.prefix("textures/vfx/noise/soul_noise.png");
        private static final RenderType SOUL_NOISE_TYPE = (RenderType)OrtusRenderTypes.RADIAL_NOISE.apply(SOUL_NOISE);
        private static final ResourceLocation PREVIEW_NOISE = MalumMod.prefix("textures/vfx/noise/harvest_noise.png");
        private static final RenderType PREVIEW_NOISE_TYPE = (RenderType)OrtusRenderTypes.RADIAL_SCATTER_NOISE.apply(PREVIEW_NOISE);

        public static void addRenderLayer(EntityRenderer<?> render) {
            if (render instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingRenderer = (LivingEntityRenderer)render;
                livingRenderer.m_115326_(new HarvestRenderLayer(livingRenderer));
            }
        }

        public static void renderSoulHarvestEffects(PoseStack poseStack, LivingEntity target, Player player, Color color, float alphaAndScale, float harvestProgress, float partialTicks) {
            if (alphaAndScale > 0.0f) {
                poseStack.m_85836_();
                AABB boundingBox = target.m_142469_();
                Vec3 playerPosition = new Vec3(player.f_19854_, player.f_19855_, player.f_19856_).m_165921_(player.m_20182_(), (double)partialTicks);
                Vec3 entityPosition = new Vec3(target.f_19854_, target.f_19855_, target.f_19856_).m_165921_(target.m_20182_(), (double)partialTicks);
                Vec3 toPlayer = playerPosition.m_82546_(entityPosition).m_82541_().m_82542_(boundingBox.m_82362_() * 0.5, 0.0, boundingBox.m_82385_() * 0.5);
                VertexConsumer soulNoise = RenderHandler.DELAYED_RENDER.m_6299_(OrtusRenderTypes.queueUniformChanges((RenderType)SOUL_NOISE_TYPE, instance -> {
                    instance.m_173356_("Speed").m_5985_(4500.0f);
                    instance.m_173356_("Intensity").m_5985_(45.0f);
                }));
                VertexConsumer previewNoise = RenderHandler.DELAYED_RENDER.m_6299_(OrtusRenderTypes.queueUniformChanges((RenderType)PREVIEW_NOISE_TYPE, instance -> {
                    instance.m_173356_("Speed").m_5985_(-3500.0f);
                    instance.m_173356_("ScatterPower").m_5985_(-60.0f);
                    instance.m_173356_("ScatterFrequency").m_5985_(-0.2f);
                    instance.m_173356_("Intensity").m_5985_(55.0f);
                }));
                poseStack.m_85837_(toPlayer.f_82479_, toPlayer.f_82480_ + (double)(target.m_20206_() / 2.0f), toPlayer.f_82481_);
                poseStack.m_85845_(Minecraft.m_91087_().m_91290_().m_114470_());
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                RenderHelper.create().setColor(color.brighter()).setAlpha(alphaAndScale * 0.6f).setLight(0xF000F0).renderQuad(soulNoise, poseStack, alphaAndScale * 0.9f).setColor(color.darker()).renderQuad(previewNoise, poseStack, Math.min(1.0f, alphaAndScale * 1.3f));
                poseStack.m_85849_();
            }
        }

        public static class HarvestRenderLayer<T extends LivingEntity, M extends EntityModel<T>>
        extends RenderLayer<T, M> {
            public HarvestRenderLayer(RenderLayerParent<T, M> parent) {
                super(parent);
            }

            public void render(PoseStack poseStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float partialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
                LivingEntityDataCapability.getCapability(pLivingEntity).ifPresent(c -> {
                    Player player;
                    if (c.ownerUUID != null && (player = pLivingEntity.f_19853_.m_46003_(c.ownerUUID)) != null && player.m_6084_() && pLivingEntity.m_6084_()) {
                        poseStack.m_85849_();
                        ClientOnly.renderSoulHarvestEffects(poseStack, pLivingEntity, player, c.spiritData.primaryType.color, c.getPreviewProgress() / 10.0f, c.getHarvestProgress(), partialTicks);
                        poseStack.m_85836_();
                    }
                });
            }
        }
    }
}

