/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.data.builder.vanilla;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;

public class StackedMalumCookingRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final int resultCount;
    private final Ingredient ingredient;
    private final float experience;
    private final int cookingTime;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private final SimpleCookingSerializer<?> serializer;

    private StackedMalumCookingRecipeBuilder(ItemLike pResult, int resultCount, Ingredient pIngredient, float pExperience, int pCookingTime, SimpleCookingSerializer<?> pSerializer) {
        this.result = pResult.m_5456_();
        this.resultCount = resultCount;
        this.ingredient = pIngredient;
        this.experience = pExperience;
        this.cookingTime = pCookingTime;
        this.serializer = pSerializer;
    }

    public static StackedMalumCookingRecipeBuilder cookingWithCount(Ingredient pIngredient, ItemLike pResult, int resultCount, float pExperience, int pCookingTime, SimpleCookingSerializer<?> pSerializer) {
        return new StackedMalumCookingRecipeBuilder(pResult, resultCount, pIngredient, pExperience, pCookingTime, pSerializer);
    }

    public static StackedMalumCookingRecipeBuilder campfireCookingWithCount(Ingredient pIngredient, ItemLike pResult, int resultCount, float pExperience, int pCookingTime) {
        return StackedMalumCookingRecipeBuilder.cookingWithCount(pIngredient, pResult, resultCount, pExperience, pCookingTime, RecipeSerializer.f_44094_);
    }

    public static StackedMalumCookingRecipeBuilder blastingWithCount(Ingredient pIngredient, ItemLike pResult, int resultCount, float pExperience, int pCookingTime) {
        return StackedMalumCookingRecipeBuilder.cookingWithCount(pIngredient, pResult, resultCount, pExperience, pCookingTime, RecipeSerializer.f_44092_);
    }

    public static StackedMalumCookingRecipeBuilder smeltingWithCount(Ingredient pIngredient, ItemLike pResult, int resultCount, float pExperience, int pCookingTime) {
        return StackedMalumCookingRecipeBuilder.cookingWithCount(pIngredient, pResult, resultCount, pExperience, pCookingTime, RecipeSerializer.f_44091_);
    }

    public static StackedMalumCookingRecipeBuilder smoking(Ingredient pIngredient, ItemLike pResult, int resultCount, float pExperience, int pCookingTime) {
        return StackedMalumCookingRecipeBuilder.cookingWithCount(pIngredient, pResult, resultCount, pExperience, pCookingTime, RecipeSerializer.f_44093_);
    }

    public StackedMalumCookingRecipeBuilder unlockedBy(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public StackedMalumCookingRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_142700_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.ensureValid(pRecipeId);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.group == null ? "" : this.group, this.ingredient, this.result, this.resultCount, this.experience, this.cookingTime, this.advancement, new ResourceLocation(pRecipeId.m_135827_(), "recipes/" + this.result.m_41471_().m_40783_() + "/" + pRecipeId.m_135815_()), (RecipeSerializer<? extends AbstractCookingRecipe>)this.serializer));
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + pId);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final Item result;
        private final int resultCount;
        private final float experience;
        private final int cookingTime;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final RecipeSerializer<? extends AbstractCookingRecipe> serializer;

        public Result(ResourceLocation pId, String pGroup, Ingredient pIngredient, Item pResult, int resultCount, float pExperience, int pCookingTime, Advancement.Builder pAdvancement, ResourceLocation pAdvancementId, RecipeSerializer<? extends AbstractCookingRecipe> pSerializer) {
            this.id = pId;
            this.group = pGroup;
            this.ingredient = pIngredient;
            this.result = pResult;
            this.resultCount = resultCount;
            this.experience = pExperience;
            this.cookingTime = pCookingTime;
            this.advancement = pAdvancement;
            this.advancementId = pAdvancementId;
            this.serializer = pSerializer;
        }

        public void m_7917_(JsonObject pJson) {
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            pJson.add("ingredient", this.ingredient.m_43942_());
            JsonObject object = new JsonObject();
            object.addProperty("item", Registry.f_122827_.m_7981_((Object)this.result).toString());
            object.addProperty("count", (Number)this.resultCount);
            pJson.add("result", (JsonElement)object);
            pJson.addProperty("experience", (Number)Float.valueOf(this.experience));
            pJson.addProperty("cookingtime", (Number)this.cookingTime);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

