/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.data.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.MalumMod;
import com.sammy.malum.core.setup.content.RecipeSerializerRegistry;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.ortus.systems.recipe.IngredientWithCount;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SpiritRepairRecipeBuilder {
    public final String inputLookup;
    public final float durabilityPercentage;
    public final ArrayList<Item> inputs = new ArrayList();
    public final IngredientWithCount repairMaterial;
    public final ArrayList<SpiritWithCount> spirits = new ArrayList();

    public SpiritRepairRecipeBuilder(String inputLookup, float durabilityPercentage, Ingredient repairMaterial, int repairMaterialCount) {
        this.inputLookup = inputLookup;
        this.durabilityPercentage = durabilityPercentage;
        this.repairMaterial = new IngredientWithCount(repairMaterial, repairMaterialCount);
    }

    public SpiritRepairRecipeBuilder(float durabilityPercentage, Ingredient repairMaterial, int repairMaterialCount) {
        this.inputLookup = "none";
        this.durabilityPercentage = durabilityPercentage;
        this.repairMaterial = new IngredientWithCount(repairMaterial, repairMaterialCount);
    }

    public SpiritRepairRecipeBuilder addItem(Item item) {
        this.inputs.add(item);
        return this;
    }

    public SpiritRepairRecipeBuilder addSpirit(MalumSpiritType type, int count) {
        this.spirits.add(new SpiritWithCount(type, count));
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String recipeName) {
        this.build(consumerIn, MalumMod.prefix("spirit_crucible/repair/" + recipeName));
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.inputLookup, this.durabilityPercentage, this.inputs, this.repairMaterial, this.spirits));
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        this.build(consumerIn, this.inputs.get(0).getRegistryName().m_135815_());
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        public final String inputLookup;
        public final float durabilityPercentage;
        public final ArrayList<Item> input;
        public final IngredientWithCount repairMaterial;
        public final ArrayList<SpiritWithCount> spirits;

        public Result(ResourceLocation id, String inputLookup, float durabilityPercentage, ArrayList<Item> input, IngredientWithCount repairMaterial, ArrayList<SpiritWithCount> spirits) {
            this.id = id;
            this.inputLookup = inputLookup;
            this.durabilityPercentage = durabilityPercentage;
            this.input = input;
            this.repairMaterial = repairMaterial;
            this.spirits = spirits;
        }

        public void m_7917_(JsonObject json) {
            JsonArray inputs = new JsonArray();
            for (Item item : this.input) {
                inputs.add(item.getRegistryName().toString());
            }
            JsonArray spirits = new JsonArray();
            for (SpiritWithCount spirit : this.spirits) {
                spirits.add((JsonElement)spirit.serialize());
            }
            if (this.inputLookup != null) {
                json.addProperty("inputLookup", this.inputLookup);
            }
            json.addProperty("durabilityPercentage", (Number)Float.valueOf(this.durabilityPercentage));
            json.add("inputs", (JsonElement)inputs);
            json.add("repairMaterial", (JsonElement)this.repairMaterial.serialize());
            json.add("spirits", (JsonElement)spirits);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipeSerializerRegistry.REPAIR_RECIPE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

