/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.data.builder;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.MalumMod;
import com.sammy.malum.core.setup.content.RecipeSerializerRegistry;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.ortus.systems.recipe.IngredientWithCount;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class SpiritInfusionRecipeBuilder {
    private final IngredientWithCount input;
    private final IngredientWithCount output;
    private final List<SpiritWithCount> spirits = Lists.newArrayList();
    private final List<IngredientWithCount> extraItems = Lists.newArrayList();

    public SpiritInfusionRecipeBuilder(Ingredient input, int inputCount, Ingredient output, int outputCount) {
        this.input = new IngredientWithCount(input, inputCount);
        this.output = new IngredientWithCount(output, outputCount);
    }

    public SpiritInfusionRecipeBuilder(Ingredient input, int inputCount, Item output, int outputCount) {
        this.input = new IngredientWithCount(input, inputCount);
        this.output = new IngredientWithCount(Ingredient.m_43929_((ItemLike[])new ItemLike[]{output}), outputCount);
    }

    public SpiritInfusionRecipeBuilder(Item input, int inputCount, Ingredient output, int outputCount) {
        this.input = new IngredientWithCount(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), inputCount);
        this.output = new IngredientWithCount(output, outputCount);
    }

    public SpiritInfusionRecipeBuilder(Item input, int inputCount, Item output, int outputCount) {
        this.input = new IngredientWithCount(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), inputCount);
        this.output = new IngredientWithCount(Ingredient.m_43929_((ItemLike[])new ItemLike[]{output}), outputCount);
    }

    public SpiritInfusionRecipeBuilder addExtraItem(Ingredient ingredient, int count) {
        this.extraItems.add(new IngredientWithCount(ingredient, count));
        return this;
    }

    public SpiritInfusionRecipeBuilder addExtraItem(Item input, int count) {
        this.extraItems.add(new IngredientWithCount(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), count));
        return this;
    }

    public SpiritInfusionRecipeBuilder addSpirit(MalumSpiritType type, int count) {
        this.spirits.add(new SpiritWithCount(type, count));
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String recipeName) {
        this.build(consumerIn, MalumMod.prefix("spirit_infusion/" + recipeName));
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        this.build(consumerIn, this.output.getStack().m_41720_().getRegistryName().m_135815_());
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.input, this.output, this.spirits, this.extraItems));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final IngredientWithCount input;
        private final IngredientWithCount output;
        private final List<SpiritWithCount> spirits;
        private final List<IngredientWithCount> extraItems;

        public Result(ResourceLocation id, IngredientWithCount input, IngredientWithCount output, List<SpiritWithCount> spirits, List<IngredientWithCount> extraItems) {
            this.id = id;
            this.input = input;
            this.output = output;
            this.spirits = spirits;
            this.extraItems = extraItems;
        }

        public void m_7917_(JsonObject json) {
            JsonObject inputObject = this.input.serialize();
            JsonObject outputObject = this.output.serialize();
            JsonArray extraItems = new JsonArray();
            for (IngredientWithCount extraItem : this.extraItems) {
                extraItems.add((JsonElement)extraItem.serialize());
            }
            JsonArray spirits = new JsonArray();
            for (SpiritWithCount spirit : this.spirits) {
                spirits.add((JsonElement)spirit.serialize());
            }
            json.add("input", (JsonElement)inputObject);
            json.add("output", (JsonElement)outputObject);
            json.add("extra_items", (JsonElement)extraItems);
            json.add("spirits", (JsonElement)spirits);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipeSerializerRegistry.INFUSION_RECIPE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

