/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.data.builder;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.MalumMod;
import com.sammy.malum.core.setup.content.RecipeSerializerRegistry;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.ortus.systems.recipe.IngredientWithCount;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SpiritFocusingRecipeBuilder {
    private final int time;
    private final int durabilityCost;
    private final Ingredient input;
    private final IngredientWithCount output;
    private final List<SpiritWithCount> spirits = Lists.newArrayList();

    public SpiritFocusingRecipeBuilder(int time, int durabilityCost, Ingredient input, Ingredient output, int outputCount) {
        this.time = time;
        this.durabilityCost = durabilityCost;
        this.input = input;
        this.output = new IngredientWithCount(output, outputCount);
    }

    public SpiritFocusingRecipeBuilder addSpirit(MalumSpiritType type, int count) {
        this.spirits.add(new SpiritWithCount(type, count));
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String recipeName) {
        this.build(consumerIn, MalumMod.prefix("spirit_crucible/" + recipeName));
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        this.build(consumerIn, this.output.getStack().m_41720_().getRegistryName().m_135815_());
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.time, this.durabilityCost, this.input, this.output, this.spirits));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final int time;
        private final int durabilityCost;
        private final Ingredient input;
        private final IngredientWithCount output;
        private final List<SpiritWithCount> spirits;

        public Result(ResourceLocation id, int time, int durabilityCost, Ingredient input, IngredientWithCount output, List<SpiritWithCount> spirits) {
            this.id = id;
            this.time = time;
            this.durabilityCost = durabilityCost;
            this.input = input;
            this.output = output;
            this.spirits = spirits;
        }

        public void m_7917_(JsonObject json) {
            JsonObject inputObject = this.input.m_43942_().getAsJsonObject();
            JsonObject outputObject = this.output.serialize();
            JsonArray spirits = new JsonArray();
            for (SpiritWithCount spirit : this.spirits) {
                spirits.add((JsonElement)spirit.serialize());
            }
            json.addProperty("time", (Number)this.time);
            json.addProperty("durabilityCost", (Number)this.durabilityCost);
            json.add("input", (JsonElement)inputObject);
            json.add("output", (JsonElement)outputObject);
            json.add("spirits", (JsonElement)spirits);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipeSerializerRegistry.FOCUSING_RECIPE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

