/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.data.builder;

import com.google.gson.JsonObject;
import com.sammy.malum.MalumMod;
import com.sammy.malum.core.setup.content.RecipeSerializerRegistry;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;

public class BlockTransmutationRecipeBuilder {
    private final Block input;
    private final Block output;

    public BlockTransmutationRecipeBuilder(Block input, Block output) {
        this.input = input;
        this.output = output;
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String recipeName) {
        this.build(consumerIn, MalumMod.prefix("block_transmutation/" + recipeName));
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        this.build(consumerIn, this.output.getRegistryName().m_135815_());
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.input, this.output));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Block input;
        private final Block output;

        public Result(ResourceLocation id, Block input, Block output) {
            this.id = id;
            this.input = input;
            this.output = output;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("input", this.input.getRegistryName().toString());
            json.addProperty("output", this.output.getRegistryName().toString());
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipeSerializerRegistry.BLOCK_TRANSMUTATION_RECIPE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

