/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.data;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.ether.EtherBlock;
import com.sammy.malum.common.block.ether.EtherBrazierBlock;
import com.sammy.malum.common.block.ether.EtherTorchBlock;
import com.sammy.malum.common.item.NodeItem;
import com.sammy.malum.common.item.ether.AbstractEtherItem;
import com.sammy.malum.common.item.impetus.CrackedImpetusItem;
import com.sammy.malum.common.item.impetus.ImpetusItem;
import com.sammy.malum.common.item.spirit.MalumSpiritItem;
import com.sammy.malum.common.item.spirit.SoulStaveItem;
import com.sammy.malum.common.item.tools.MalumScytheItem;
import com.sammy.malum.core.setup.content.item.ItemRegistry;
import com.sammy.ortus.helpers.DataHelper;
import com.sammy.ortus.systems.item.ModCombatItem;
import com.sammy.ortus.systems.multiblock.MultiBlockItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class MalumItemModels
extends ItemModelProvider {
    private static final ResourceLocation GENERATED = new ResourceLocation("item/generated");
    private static final ResourceLocation HANDHELD = new ResourceLocation("item/handheld");

    public MalumItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "malum", existingFileHelper);
    }

    protected void registerModels() {
        HashSet items = new HashSet(ItemRegistry.ITEMS.getEntries());
        DataHelper.takeAll(items, i -> i.get() instanceof MalumScytheItem);
        DataHelper.takeAll(items, i -> i.get() instanceof MalumSpiritItem).forEach(this::spiritSplinterItem);
        DataHelper.takeAll(items, i -> i.get() instanceof NodeItem).forEach(this::nodeItem);
        DataHelper.takeAll(items, i -> i.get() instanceof ImpetusItem || i.get() instanceof CrackedImpetusItem).forEach(this::impetusItem);
        DataHelper.takeAll(items, i -> i.get() instanceof MultiBlockItem).forEach(this::multiBlockItem);
        DataHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).m_40614_() instanceof WallBlock).forEach(this::wallBlockItem);
        DataHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).m_40614_() instanceof FenceBlock).forEach(this::fenceBlockItem);
        DataHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).m_40614_() instanceof DoorBlock).forEach(this::generatedItem);
        DataHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).m_40614_() instanceof TrapDoorBlock).forEach(this::trapdoorBlockItem);
        DataHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).m_40614_() instanceof PressurePlateBlock).forEach(this::pressurePlateBlockItem);
        DataHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).m_40614_() instanceof ButtonBlock).forEach(this::buttonBlockItem);
        DataHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).m_40614_() instanceof BushBlock && !(((BlockItem)i.get()).m_40614_() instanceof DoublePlantBlock)).forEach(this::blockGeneratedItem);
        DataHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).m_40614_() instanceof DoublePlantBlock).forEach(this::generatedItem);
        DataHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).m_40614_() instanceof EtherBrazierBlock).forEach(this::etherBrazierItem);
        DataHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).m_40614_() instanceof LanternBlock).forEach(this::generatedItem);
        DataHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).m_40614_() instanceof EtherTorchBlock).forEach(this::etherTorchItem);
        DataHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).m_40614_() instanceof TorchBlock).forEach(this::generatedItem);
        DataHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).m_40614_() instanceof EtherBlock).forEach(this::etherItem);
        DataHelper.takeAll(items, i -> i.get() instanceof SignItem).forEach(this::generatedItem);
        DataHelper.takeAll(items, i -> i.get() instanceof BlockItem).forEach(this::blockItem);
        DataHelper.takeAll(items, i -> i.get() instanceof DiggerItem).forEach(this::handheldItem);
        DataHelper.takeAll(items, i -> i.get() instanceof SoulStaveItem).forEach(this::handheldItem);
        DataHelper.takeAll(items, i -> i.get() instanceof ModCombatItem).forEach(this::handheldItem);
        DataHelper.takeAll(items, i -> i.get() instanceof SwordItem).forEach(this::handheldItem);
        DataHelper.takeAll(items, i -> i.get() instanceof BowItem).forEach(this::handheldItem);
        items.forEach(this::generatedItem);
    }

    private void multiBlockItem(RegistryObject<Item> i) {
        String name = Registry.f_122827_.m_7981_((Object)((Item)i.get())).m_135815_();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(MalumMod.prefix("item/" + name + "_item")));
    }

    private void nodeItem(RegistryObject<Item> i) {
        String name = Registry.f_122827_.m_7981_((Object)((Item)i.get())).m_135815_();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumMod.prefix("item/impetus/" + name));
    }

    private void impetusItem(RegistryObject<Item> i) {
        String name = Registry.f_122827_.m_7981_((Object)((Item)i.get())).m_135815_();
        ArrayList split = (ArrayList)DataHelper.reverseOrder(new ArrayList(), Arrays.asList(name.split("_")));
        split.remove(0);
        String alteredName = String.join((CharSequence)"_", split);
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumMod.prefix("item/impetus/" + alteredName));
    }

    private void spiritSplinterItem(RegistryObject<Item> i) {
        String name = Registry.f_122827_.m_7981_((Object)((Item)i.get())).m_135815_();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumMod.prefix("item/spirit_shard"));
    }

    private void etherBrazierItem(RegistryObject<Item> i) {
        String name = Registry.f_122827_.m_7981_((Object)((Item)i.get())).m_135815_();
        String textureName = name.substring(0, 8) + "ether_brazier";
        AbstractEtherItem etherItem = (AbstractEtherItem)((Object)i.get());
        if (etherItem.iridescent) {
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumMod.prefix("item/iridescent_ether_brazier"))).texture("layer1", MalumMod.prefix("item/" + textureName))).texture("layer2", MalumMod.prefix("item/iridescent_ether_brazier_overlay"));
            return;
        }
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumMod.prefix("item/ether_brazier_overlay"))).texture("layer1", MalumMod.prefix("item/" + textureName));
    }

    private void etherTorchItem(RegistryObject<Item> i) {
        String name = Registry.f_122827_.m_7981_((Object)((Item)i.get())).m_135815_();
        AbstractEtherItem etherItem = (AbstractEtherItem)((Object)i.get());
        if (etherItem.iridescent) {
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumMod.prefix("item/iridescent_ether_torch"))).texture("layer1", MalumMod.prefix("item/ether_torch"))).texture("layer2", MalumMod.prefix("item/iridescent_ether_torch_overlay"));
            return;
        }
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumMod.prefix("item/ether_torch_overlay"))).texture("layer1", MalumMod.prefix("item/ether_torch"));
    }

    private void etherItem(RegistryObject<Item> i) {
        String name = Registry.f_122827_.m_7981_((Object)((Item)i.get())).m_135815_();
        AbstractEtherItem etherItem = (AbstractEtherItem)((Object)i.get());
        if (etherItem.iridescent) {
            ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumMod.prefix("item/iridescent_ether"))).texture("layer1", MalumMod.prefix("item/iridescent_ether_overlay"));
            return;
        }
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumMod.prefix("item/ether"));
    }

    private void handheldItem(RegistryObject<Item> i) {
        String name = Registry.f_122827_.m_7981_((Object)((Item)i.get())).m_135815_();
        ((ItemModelBuilder)this.withExistingParent(name, HANDHELD)).texture("layer0", MalumMod.prefix("item/" + name));
    }

    private void generatedItem(RegistryObject<Item> i) {
        String name = Registry.f_122827_.m_7981_((Object)((Item)i.get())).m_135815_();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumMod.prefix("item/" + name));
    }

    private void blockGeneratedItem(RegistryObject<Item> i) {
        String name = Registry.f_122827_.m_7981_((Object)((Item)i.get())).m_135815_();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumMod.prefix("block/" + name));
    }

    private void blockItem(RegistryObject<Item> i) {
        String name = Registry.f_122827_.m_7981_((Object)((Item)i.get())).m_135815_();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(MalumMod.prefix("block/" + name)));
    }

    private void trapdoorBlockItem(RegistryObject<Item> i) {
        String name = Registry.f_122827_.m_7981_((Object)((Item)i.get())).m_135815_();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(MalumMod.prefix("block/" + name + "_bottom")));
    }

    private void fenceBlockItem(RegistryObject<Item> i) {
        String name = Registry.f_122827_.m_7981_((Object)((Item)i.get())).m_135815_();
        String baseName = name.substring(0, name.length() - 6);
        this.fenceInventory(name, MalumMod.prefix("block/" + baseName));
    }

    private void wallBlockItem(RegistryObject<Item> i) {
        String name = Registry.f_122827_.m_7981_((Object)((Item)i.get())).m_135815_();
        String baseName = name.substring(0, name.length() - 5);
        this.wallInventory(name, MalumMod.prefix("block/" + baseName));
    }

    private void pressurePlateBlockItem(RegistryObject<Item> i) {
        String name = Registry.f_122827_.m_7981_((Object)((Item)i.get())).m_135815_();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(MalumMod.prefix("block/" + name + "_up")));
    }

    private void buttonBlockItem(RegistryObject<Item> i) {
        String name = Registry.f_122827_.m_7981_((Object)((Item)i.get())).m_135815_();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(MalumMod.prefix("block/" + name + "_inventory")));
    }

    public String m_6055_() {
        return "Malum Item Models";
    }
}

