/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.data;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.MalumLeavesBlock;
import com.sammy.malum.common.block.ether.EtherBlock;
import com.sammy.malum.common.block.ether.EtherBrazierBlock;
import com.sammy.malum.common.block.ether.EtherTorchBlock;
import com.sammy.malum.common.block.ether.EtherWallTorchBlock;
import com.sammy.malum.common.block.mirror.WallMirrorBlock;
import com.sammy.malum.common.block.storage.ItemPedestalBlock;
import com.sammy.malum.common.block.storage.ItemStandBlock;
import com.sammy.malum.common.block.totem.TotemBaseBlock;
import com.sammy.malum.common.block.totem.TotemPoleBlock;
import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import com.sammy.malum.core.setup.content.block.BlockRegistry;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.ortus.helpers.DataHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class MalumBlockStates
extends BlockStateProvider {
    public MalumBlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "malum", exFileHelper);
    }

    @Nonnull
    public String m_6055_() {
        return "Malum BlockStates";
    }

    protected void registerStatesAndModels() {
        HashSet blocks = new HashSet(BlockRegistry.BLOCKS.getEntries());
        ArrayList<RegistryObject<Block>> customModels = new ArrayList<RegistryObject<Block>>(List.of(BlockRegistry.TWISTED_TABLET, BlockRegistry.SOULWOOD_FUSION_PLATE_COMPONENT, BlockRegistry.SPIRIT_CATALYZER, BlockRegistry.SPIRIT_CATALYZER_COMPONENT));
        ArrayList<RegistryObject> predefinedModels = new ArrayList<RegistryObject>(List.of(BlockRegistry.SOULWOOD_FUSION_PLATE, BlockRegistry.SPIRIT_ALTAR, BlockRegistry.SOUL_VIAL, BlockRegistry.SPIRIT_JAR, BlockRegistry.BRILLIANT_OBELISK, BlockRegistry.BRILLIANT_OBELISK_COMPONENT, BlockRegistry.RUNEWOOD_OBELISK, BlockRegistry.RUNEWOOD_OBELISK_COMPONENT, BlockRegistry.SPIRIT_CRUCIBLE, BlockRegistry.SPIRIT_CRUCIBLE_COMPONENT, BlockRegistry.SOULWOOD_PLINTH, BlockRegistry.SOULWOOD_PLINTH_COMPONENT));
        ArrayList<RegistryObject<Block>> layeredModels = new ArrayList<RegistryObject<Block>>(List.of(BlockRegistry.BRILLIANT_STONE, BlockRegistry.BRILLIANT_STONE, BlockRegistry.BLAZING_QUARTZ_ORE));
        DataHelper.takeAll(blocks, customModels::contains);
        DataHelper.takeAll(blocks, predefinedModels::contains).forEach(this::customBlock);
        DataHelper.takeAll(blocks, layeredModels::contains).forEach(this::layeredBlock);
        DataHelper.takeAll(blocks, b -> ((Block)b.get()).getRegistryName().m_135815_().startsWith("cut_") && ((Block)b.get()).getRegistryName().m_135815_().endsWith("_planks")).forEach(this::cutPlanksBlock);
        DataHelper.takeAll(blocks, b -> ((Block)b.get()).getRegistryName().m_135815_().startsWith("cut_")).forEach(this::cutBlock);
        DataHelper.takeAll(blocks, b -> ((Block)b.get()).m_7705_().endsWith("_cap")).forEach(this::pillarCapBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof SignBlock).forEach(this::signBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof TotemBaseBlock).forEach(this::totemBaseBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof TotemPoleBlock).forEach(this::totemPoleBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof ItemPedestalBlock).forEach(this::itemPedestalBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof ItemStandBlock).forEach(this::itemStandBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof GrassBlock).forEach(this::grassBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof StairBlock).forEach(this::stairsBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof RotatedPillarBlock).forEach(this::logBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof WallBlock).forEach(this::wallBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof FenceBlock).forEach(this::fenceBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof FenceGateBlock).forEach(this::fenceGateBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof DoorBlock).forEach(this::doorBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof TrapDoorBlock).forEach(this::trapdoorBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof PressurePlateBlock).forEach(this::pressurePlateBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof ButtonBlock).forEach(this::buttonBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof DoublePlantBlock).forEach(this::tallPlantBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof BushBlock).forEach(this::plantBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof LanternBlock).forEach(this::lanternBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof MalumLeavesBlock).forEach(this::malumLeavesBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof EtherBrazierBlock).forEach(this::brazierBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof EtherWallTorchBlock).forEach(this::wallEtherTorchBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof EtherTorchBlock).forEach(this::etherTorchBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof EtherBlock).forEach(this::etherBlock);
        DataHelper.takeAll(blocks, b -> b.get() instanceof WallMirrorBlock).forEach(this::wallMirrorBlock);
        Collection slabs = DataHelper.takeAll(blocks, b -> b.get() instanceof SlabBlock);
        blocks.forEach(this::basicBlock);
        slabs.forEach(this::slabBlock);
    }

    public void basicBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get());
    }

    public void signBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String particleName = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_().replaceFirst("_wall", "").replaceFirst("_sign", "") + "_planks";
        ModelBuilder sign = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/air"))).texture("particle", MalumMod.prefix("block/" + particleName));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> MalumBlockStates.lambda$signBlock$28((ModelFile)sign, arg_0));
    }

    public void customBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        ModelFile.ExistingModelFile model = this.models().getExistingFile(MalumMod.prefix("block/" + name));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> MalumBlockStates.lambda$customBlock$29((ModelFile)model, arg_0));
    }

    public void layeredBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String glow = name + "_glow";
        ModelBuilder glowModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, MalumMod.prefix("block/templates/template_glowing_block"))).texture("all", MalumMod.prefix("block/" + name))).texture("particle", MalumMod.prefix("block/" + name))).texture("glow", MalumMod.prefix("block/" + glow));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> MalumBlockStates.lambda$layeredBlock$30((ModelFile)glowModel, arg_0));
    }

    public void rotatedBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        ModelBuilder file = this.models().cubeAll(name, MalumMod.prefix("block/" + name));
        this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().modelForState().modelFile((ModelFile)file).nextModel().modelFile((ModelFile)file).rotationY(90).nextModel().modelFile((ModelFile)file).rotationY(180).nextModel().modelFile((ModelFile)file).rotationY(270).addModel();
    }

    public void wallMirrorBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String particleName = "block_of_hallowed_gold";
        ModelBuilder stand = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, MalumMod.prefix("block/templates/template_item_stand"))).texture("stand", MalumMod.prefix("block/tainted_rock_item_stand"))).texture("particle", MalumMod.prefix("block/" + particleName));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)stand).rotationX(90).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)stand).rotationX(90).rotationY(270).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)stand).rotationX(90).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)stand).rotationX(90).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)stand).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)stand).addModel();
    }

    public void etherBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        ModelBuilder empty = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/air"))).texture("particle", MalumMod.prefix("item/ether"));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> MalumBlockStates.lambda$etherBlock$31((ModelFile)empty, arg_0));
    }

    public void etherTorchBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        ModelBuilder torch = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, MalumMod.prefix("block/templates/template_ether_torch"))).texture("torch", MalumMod.prefix("block/ether_torch"))).texture("colored", MalumMod.prefix("block/ether_torch_overlay"))).texture("particle", MalumMod.prefix("block/runewood_planks"));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> MalumBlockStates.lambda$etherTorchBlock$32((ModelFile)torch, arg_0));
    }

    public void wallEtherTorchBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        ModelBuilder torch = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, MalumMod.prefix("block/templates/template_ether_torch_wall"))).texture("torch", MalumMod.prefix("block/ether_torch"))).texture("colored", MalumMod.prefix("block/ether_torch_overlay"))).texture("particle", MalumMod.prefix("block/runewood_planks"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)WallTorchBlock.f_58119_, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)torch).rotationY(270).addModel()).partialState().with((Property)WallTorchBlock.f_58119_, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)torch).rotationY(180).addModel()).partialState().with((Property)WallTorchBlock.f_58119_, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)torch).rotationY(90).addModel()).partialState().with((Property)WallTorchBlock.f_58119_, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)torch).addModel();
    }

    public void torchBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        ModelBuilder torch = this.models().torchWall(((Block)blockRegistryObject.get()).getRegistryName().m_135815_(), MalumMod.prefix("block/" + name));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> MalumBlockStates.lambda$torchBlock$33((ModelFile)torch, arg_0));
    }

    public void wallTorchBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        ModelBuilder torch = this.models().torchWall(((Block)blockRegistryObject.get()).getRegistryName().m_135815_(), MalumMod.prefix("block/" + name.substring(5)));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)WallTorchBlock.f_58119_, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)torch).rotationY(270).addModel()).partialState().with((Property)WallTorchBlock.f_58119_, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)torch).rotationY(180).addModel()).partialState().with((Property)WallTorchBlock.f_58119_, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)torch).rotationY(90).addModel()).partialState().with((Property)WallTorchBlock.f_58119_, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)torch).addModel();
    }

    public void itemStandBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        Object particleName = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_().replaceFirst("_item_stand", "");
        if (!((String)particleName).endsWith("_rock")) {
            particleName = (String)particleName + "_planks";
        }
        ModelBuilder stand = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, MalumMod.prefix("block/templates/template_item_stand"))).texture("stand", MalumMod.prefix("block/" + name))).texture("particle", MalumMod.prefix("block/" + (String)particleName));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)stand).rotationX(90).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)stand).rotationX(90).rotationY(270).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)stand).rotationX(90).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)stand).rotationX(90).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)stand).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)stand).addModel();
    }

    public void itemPedestalBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        Object particleName = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_().replaceFirst("_item_pedestal", "");
        String modelLocation = "block/templates/template_rock_item_pedestal";
        if (!((String)particleName).endsWith("_rock")) {
            particleName = (String)particleName + "_planks";
            modelLocation = "block/templates/template_wood_item_pedestal";
        }
        ModelBuilder pedestal = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, MalumMod.prefix(modelLocation))).texture("pedestal", MalumMod.prefix("block/" + name))).texture("particle", MalumMod.prefix("block/" + (String)particleName));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> MalumBlockStates.lambda$itemPedestalBlock$34((ModelFile)pedestal, arg_0));
    }

    public void cutBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String baseName = "polished_" + name.substring(4);
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)this.models().cubeBottomTop(name, MalumMod.prefix("block/" + name), MalumMod.prefix("block/" + baseName), MalumMod.prefix("block/" + baseName)));
    }

    public void cutPlanksBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String baseName = name.substring(0, name.length() - "_planks".length()).substring(4) + "_panel";
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)this.models().cubeBottomTop(name, MalumMod.prefix("block/" + name), MalumMod.prefix("block/" + name), MalumMod.prefix("block/" + baseName)));
    }

    public void grassBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        ModelBuilder file = this.models().cubeBottomTop(name, MalumMod.prefix("block/" + name + "_side"), new ResourceLocation("block/dirt"), MalumMod.prefix("block/" + name + "_top"));
        this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().modelForState().modelFile((ModelFile)file).nextModel().modelFile((ModelFile)file).rotationY(90).nextModel().modelFile((ModelFile)file).rotationY(180).nextModel().modelFile((ModelFile)file).rotationY(270).addModel();
    }

    public void totemBaseBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String woodName = name.substring(0, 8);
        ResourceLocation side = MalumMod.prefix("block/" + woodName + "_log");
        ResourceLocation top = MalumMod.prefix("block/" + woodName + "_log_top");
        ResourceLocation planks = MalumMod.prefix("block/" + woodName + "_planks");
        ResourceLocation panel = MalumMod.prefix("block/" + woodName + "_panel");
        ModelBuilder base = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, MalumMod.prefix("block/templates/template_totem_base"))).texture("side", side)).texture("top", top)).texture("planks", planks)).texture("panel", panel);
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)base);
    }

    public void totemPoleBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String woodName = name.substring(0, 8);
        ResourceLocation side = MalumMod.prefix("block/" + woodName + "_log");
        ResourceLocation top = MalumMod.prefix("block/" + woodName + "_log_top");
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(s -> {
            String type = (String)((Object)s.m_61143_((Property)SpiritTypeRegistry.SPIRIT_TYPE_PROPERTY));
            MalumSpiritType spiritType = SpiritTypeRegistry.SPIRITS.get(type);
            ModelBuilder pole = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_" + spiritType.identifier, MalumMod.prefix("block/templates/template_totem_pole"))).texture("side", side)).texture("top", top)).texture("front", MalumMod.prefix("block/totem/" + spiritType.identifier + "_" + woodName + "_cutout"));
            return ConfiguredModel.builder().modelFile((ModelFile)pole).rotationY(((int)((Direction)s.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build();
        });
    }

    public void malumLeavesBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        ModelBuilder leaves = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/leaves"))).texture("all", MalumMod.prefix("block/" + name));
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)leaves);
    }

    public void pillarCapBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String baseName = name.substring(0, name.length() - 11);
        String pillarName = name.substring(0, name.length() - 4) + "_top";
        this.directionalBlock((Block)blockRegistryObject.get(), (ModelFile)this.models().cubeBottomTop(name, MalumMod.prefix("block/" + name), MalumMod.prefix("block/" + pillarName), MalumMod.prefix("block/smooth_" + baseName)));
    }

    public void trapdoorBlock(RegistryObject<Block> blockRegistryObject) {
        this.trapdoorBlock((TrapDoorBlock)blockRegistryObject.get(), this.blockTexture((Block)blockRegistryObject.get()), true);
    }

    public void doorBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        this.doorBlock((DoorBlock)blockRegistryObject.get(), MalumMod.prefix("block/" + name + "_bottom"), MalumMod.prefix("block/" + name + "_top"));
    }

    public void fenceGateBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String baseName = name.substring(0, name.length() - 11);
        this.fenceGateBlock((FenceGateBlock)blockRegistryObject.get(), MalumMod.prefix("block/" + baseName));
    }

    public void fenceBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String baseName = name.substring(0, name.length() - 6);
        this.fenceBlock((FenceBlock)blockRegistryObject.get(), MalumMod.prefix("block/" + baseName));
    }

    public void wallBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String baseName = name.substring(0, name.length() - 5);
        this.wallBlock((WallBlock)blockRegistryObject.get(), MalumMod.prefix("block/" + baseName));
    }

    public void stairsBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String baseName = name.substring(0, name.length() - 7);
        this.stairsBlock((StairBlock)blockRegistryObject.get(), MalumMod.prefix("block/" + baseName));
    }

    public void pressurePlateBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String baseName = name.substring(0, name.length() - 15);
        ModelBuilder pressurePlateDown = ((BlockModelBuilder)this.models().withExistingParent(name + "_down", new ResourceLocation("block/pressure_plate_down"))).texture("texture", MalumMod.prefix("block/" + baseName));
        ModelBuilder pressurePlateUp = ((BlockModelBuilder)this.models().withExistingParent(name + "_up", new ResourceLocation("block/pressure_plate_up"))).texture("texture", MalumMod.prefix("block/" + baseName));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)pressurePlateDown).addModel()).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)pressurePlateUp).addModel();
    }

    public void brazierBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String textureName = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_().replaceFirst("_iridescent", "");
        String particleName = textureName.replaceFirst("_ether_brazier", "") + "_rock";
        ModelBuilder brazier = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, MalumMod.prefix("block/templates/template_ether_brazier"))).texture("brazier", MalumMod.prefix("block/" + textureName))).texture("particle", MalumMod.prefix("block/" + particleName));
        ModelBuilder brazier_hanging = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_hanging", MalumMod.prefix("block/templates/template_ether_brazier_hanging"))).texture("brazier", MalumMod.prefix("block/" + textureName))).texture("particle", MalumMod.prefix("block/" + particleName));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)brazier).addModel()).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(true)).with((Property)EtherBrazierBlock.ROTATED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)brazier_hanging).addModel()).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(true)).with((Property)EtherBrazierBlock.ROTATED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)brazier_hanging).rotationY(90).addModel();
    }

    public void lanternBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        ModelBuilder lantern = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/templates/template_lantern"))).texture("lantern", MalumMod.prefix("block/" + name));
        ModelBuilder hangingLantern = ((BlockModelBuilder)this.models().withExistingParent(name + "_hanging", new ResourceLocation("block/templates/template_hanging_lantern"))).texture("lantern", MalumMod.prefix("block/" + name));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)hangingLantern).addModel()).partialState().with((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)lantern).addModel();
    }

    public void buttonBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String baseName = name.substring(0, name.length() - 7);
        ModelBuilder buttom = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/button"))).texture("texture", MalumMod.prefix("block/" + baseName));
        ModelBuilder buttonPressed = ((BlockModelBuilder)this.models().withExistingParent(name + "_pressed", new ResourceLocation("block/button_pressed"))).texture("texture", MalumMod.prefix("block/" + baseName));
        Function<BlockState, ModelFile> modelFunc = arg_0 -> MalumBlockStates.lambda$buttonBlock$36((ModelFile)buttom, arg_0);
        Function<BlockState, ModelFile> pressedModelFunc = arg_0 -> MalumBlockStates.lambda$buttonBlock$37((ModelFile)buttonPressed, arg_0);
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(s -> ConfiguredModel.builder().modelFile((Boolean)s.m_61143_((Property)BlockStateProperties.f_61448_) != false ? (ModelFile)pressedModelFunc.apply((BlockState)s) : (ModelFile)modelFunc.apply((BlockState)s)).uvLock(((AttachFace)s.m_61143_((Property)BlockStateProperties.f_61376_)).equals((Object)AttachFace.WALL)).rotationX(((AttachFace)s.m_61143_((Property)BlockStateProperties.f_61376_)).ordinal() * 90).rotationY(((int)((Direction)s.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180 + (s.m_61143_((Property)BlockStateProperties.f_61376_) == AttachFace.CEILING ? 180 : 0)) % 360).build());
        ((BlockModelBuilder)this.models().withExistingParent(name + "_inventory", new ResourceLocation("block/button_inventory"))).texture("texture", MalumMod.prefix("block/" + baseName));
    }

    public void tallPlantBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        ModelBuilder bottom = ((BlockModelBuilder)this.models().withExistingParent(name + "_bottom", new ResourceLocation("block/cross"))).texture("cross", MalumMod.prefix("block/" + name + "_bottom"));
        ModelBuilder top = ((BlockModelBuilder)this.models().withExistingParent(name + "_top", new ResourceLocation("block/cross"))).texture("cross", MalumMod.prefix("block/" + name + "_top"));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER).modelForState().modelFile((ModelFile)bottom).addModel()).partialState().with((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER).modelForState().modelFile((ModelFile)top).addModel();
    }

    public void plantBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        ModelBuilder cross = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/cross"))).texture("cross", MalumMod.prefix("block/" + name));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> MalumBlockStates.lambda$plantBlock$39((ModelFile)cross, arg_0));
    }

    public void slabBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String baseName = name.substring(0, name.length() - 5);
        this.slabBlock((SlabBlock)blockRegistryObject.get(), MalumMod.prefix(baseName), MalumMod.prefix("block/" + baseName));
    }

    public void logBlock(RegistryObject<Block> blockRegistryObject) {
        if (blockRegistryObject.equals(BlockRegistry.RUNEWOOD) || blockRegistryObject.equals(BlockRegistry.STRIPPED_RUNEWOOD) || blockRegistryObject.equals(BlockRegistry.SOULWOOD) || blockRegistryObject.equals(BlockRegistry.STRIPPED_SOULWOOD)) {
            this.woodBlock(blockRegistryObject);
            return;
        }
        this.logBlock((RotatedPillarBlock)blockRegistryObject.get());
    }

    public void woodBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.f_122824_.m_7981_((Object)((Block)blockRegistryObject.get())).m_135815_();
        String baseName = name + "_log";
        this.axisBlock((RotatedPillarBlock)blockRegistryObject.get(), MalumMod.prefix("block/" + baseName), MalumMod.prefix("block/" + baseName));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$plantBlock$39(ModelFile cross, BlockState s) {
        return ConfiguredModel.builder().modelFile(cross).build();
    }

    private static /* synthetic */ ModelFile lambda$buttonBlock$37(ModelFile buttonPressed, BlockState $) {
        return buttonPressed;
    }

    private static /* synthetic */ ModelFile lambda$buttonBlock$36(ModelFile buttom, BlockState $) {
        return buttom;
    }

    private static /* synthetic */ ConfiguredModel[] lambda$itemPedestalBlock$34(ModelFile pedestal, BlockState s) {
        return ConfiguredModel.builder().modelFile(pedestal).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$torchBlock$33(ModelFile torch, BlockState s) {
        return ConfiguredModel.builder().modelFile(torch).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$etherTorchBlock$32(ModelFile torch, BlockState s) {
        return ConfiguredModel.builder().modelFile(torch).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$etherBlock$31(ModelFile empty, BlockState s) {
        return ConfiguredModel.builder().modelFile(empty).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$layeredBlock$30(ModelFile glowModel, BlockState s) {
        return ConfiguredModel.builder().modelFile(glowModel).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$customBlock$29(ModelFile model, BlockState s) {
        return ConfiguredModel.builder().modelFile(model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$signBlock$28(ModelFile sign, BlockState s) {
        return ConfiguredModel.builder().modelFile(sign).build();
    }
}

