/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.data;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.sammy.malum.common.block.ether.EtherBlock;
import com.sammy.malum.common.block.storage.SoulVialBlock;
import com.sammy.malum.common.block.storage.SpiritJarBlock;
import com.sammy.malum.core.setup.content.block.BlockRegistry;
import com.sammy.malum.core.setup.content.item.ItemRegistry;
import com.sammy.ortus.helpers.DataHelper;
import com.sammy.ortus.systems.block.OrtusBlockProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetContainerContents;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class MalumBlockLootTables
extends LootTableProvider {
    private static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    private static final LootItemCondition.Builder HAS_NO_SILK_TOUCH = HAS_SILK_TOUCH.m_81807_();
    private static final LootItemCondition.Builder HAS_SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_}));
    private static final LootItemCondition.Builder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.m_7818_(HAS_SILK_TOUCH);
    private static final LootItemCondition.Builder HAS_NO_SHEARS_OR_SILK_TOUCH = HAS_SHEARS_OR_SILK_TOUCH.m_81807_();
    private static final Set<Item> EXPLOSION_RESISTANT = (Set)Stream.of(Blocks.f_50260_, Blocks.f_50273_, Blocks.f_50569_, Blocks.f_50310_, Blocks.f_50312_, Blocks.f_50316_, Blocks.f_50314_, Blocks.f_50318_, Blocks.f_50320_, Blocks.f_50456_, Blocks.f_50525_, Blocks.f_50521_, Blocks.f_50522_, Blocks.f_50466_, Blocks.f_50464_, Blocks.f_50523_, Blocks.f_50460_, Blocks.f_50465_, Blocks.f_50462_, Blocks.f_50459_, Blocks.f_50458_, Blocks.f_50463_, Blocks.f_50520_, Blocks.f_50524_, Blocks.f_50457_, Blocks.f_50461_).map(ItemLike::m_5456_).collect(ImmutableSet.toImmutableSet());
    private static final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> tables = new ArrayList<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>>();

    public MalumBlockLootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    public String m_6055_() {
        return "Malum Loot Tables";
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        HashSet blocks = new HashSet(BlockRegistry.BLOCKS.getEntries());
        DataHelper.takeAll(blocks, b -> ((Block)b.get()).f_60439_ instanceof OrtusBlockProperties && ((OrtusBlockProperties)((Block)b.get()).f_60439_).getThrowawayData().hasCustomLoot);
        DataHelper.takeAll(blocks, b -> b.get() instanceof SaplingBlock).forEach(b -> this.add((Block)b.get(), MalumBlockLootTables.createSingleItemTable((ItemLike)((Block)b.get()).m_5456_())));
        DataHelper.takeAll(blocks, b -> b.get() instanceof DoublePlantBlock).forEach(b -> this.add((Block)b.get(), MalumBlockLootTables.createSingleItemTableWithSilkTouchOrShears((Block)b.get(), (ItemLike)((Block)b.get()).m_5456_())));
        DataHelper.takeAll(blocks, b -> b.get() instanceof BushBlock).forEach(b -> this.add((Block)b.get(), MalumBlockLootTables.createSingleItemTableWithSilkTouchOrShears((Block)b.get(), (ItemLike)((Block)b.get()).m_5456_())));
        DataHelper.takeAll(blocks, b -> b.get() instanceof GrassBlock).forEach(b -> this.add((Block)b.get(), MalumBlockLootTables.createSingleItemTableWithSilkTouch((Block)b.get(), (ItemLike)Items.f_42329_)));
        DataHelper.takeAll(blocks, b -> b.get() instanceof SlabBlock).forEach(b -> this.add((Block)b.get(), MalumBlockLootTables.createSlabItemTable((Block)b.get())));
        DataHelper.takeAll(blocks, b -> b.get() instanceof DoorBlock).forEach(b -> this.add((Block)b.get(), MalumBlockLootTables.createDoorTable((Block)b.get())));
        DataHelper.takeAll(blocks, b -> b.get() instanceof EtherBlock).forEach(b -> this.add((Block)b.get(), MalumBlockLootTables.createEtherDrop((Block)b.get())));
        DataHelper.takeAll(blocks, b -> b.get() instanceof SpiritJarBlock).forEach(b -> this.add((Block)b.get(), MalumBlockLootTables.createJarDrop((Block)b.get())));
        DataHelper.takeAll(blocks, b -> b.get() instanceof SoulVialBlock).forEach(b -> this.add((Block)b.get(), MalumBlockLootTables.createVialDrop((Block)b.get())));
        DataHelper.takeAll(blocks, b -> true).forEach(b -> this.add((Block)b.get(), MalumBlockLootTables.createSingleItemTable((ItemLike)((Block)b.get()).m_5456_())));
        this.add((Block)BlockRegistry.RUNEWOOD_LEAVES.get(), (Block b) -> MalumBlockLootTables.createLeavesDrops(b, (Block)BlockRegistry.RUNEWOOD_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add((Block)BlockRegistry.SOULWOOD_LEAVES.get(), (Block b) -> MalumBlockLootTables.createLeavesDrops(b, (Block)BlockRegistry.SOULWOOD_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add((Block)BlockRegistry.BRILLIANT_STONE.get(), MalumBlockLootTables.createOreDrop((Block)BlockRegistry.BRILLIANT_STONE.get(), (Item)ItemRegistry.CLUSTER_OF_BRILLIANCE.get()));
        this.add((Block)BlockRegistry.BRILLIANT_DEEPSLATE.get(), MalumBlockLootTables.createOreDrop((Block)BlockRegistry.BRILLIANT_DEEPSLATE.get(), (Item)ItemRegistry.CLUSTER_OF_BRILLIANCE.get()));
        this.add((Block)BlockRegistry.SOULSTONE_ORE.get(), MalumBlockLootTables.createOreDrop((Block)BlockRegistry.SOULSTONE_ORE.get(), (Item)ItemRegistry.RAW_SOULSTONE.get()));
        this.add((Block)BlockRegistry.DEEPSLATE_SOULSTONE_ORE.get(), MalumBlockLootTables.createOreDrop((Block)BlockRegistry.DEEPSLATE_SOULSTONE_ORE.get(), (Item)ItemRegistry.RAW_SOULSTONE.get()));
        this.add((Block)BlockRegistry.BLAZING_QUARTZ_ORE.get(), MalumBlockLootTables.createOreDrop((Block)BlockRegistry.BLAZING_QUARTZ_ORE.get(), (Item)ItemRegistry.BLAZING_QUARTZ.get()));
        return this.tables;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
        map.forEach((loc, table) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)loc, (LootTable)table));
    }

    protected static <T> T applyExplosionDecay(ItemLike p_124132_, FunctionUserBuilder<T> p_124133_) {
        return (T)(!EXPLOSION_RESISTANT.contains(p_124132_.m_5456_()) ? p_124133_.m_5577_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()) : p_124133_.m_5476_());
    }

    protected static <T> T applyExplosionCondition(ItemLike p_124135_, ConditionUserBuilder<T> p_124136_) {
        return (T)(!EXPLOSION_RESISTANT.contains(p_124135_.m_5456_()) ? p_124136_.m_6509_(ExplosionCondition.m_81661_()) : p_124136_.m_5476_());
    }

    protected static LootTable.Builder createEtherDrop(Block block) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)MalumBlockLootTables.applyExplosionCondition((ItemLike)block, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("firstColor", "display.firstColor").m_80279_("secondColor", "display.secondColor")))));
    }

    protected static LootTable.Builder createJarDrop(Block block) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)MalumBlockLootTables.applyExplosionCondition((ItemLike)block, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("spirit", "spirit").m_80279_("count", "count")))));
    }

    protected static LootTable.Builder createVialDrop(Block block) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)MalumBlockLootTables.applyExplosionCondition((ItemLike)block, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("spirit_data", "spirit_data")))));
    }

    protected static LootTable.Builder createSingleItemTable(ItemLike p_124127_) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)MalumBlockLootTables.applyExplosionCondition(p_124127_, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_124127_))));
    }

    protected static LootTable.Builder createSelfDropDispatchTable(Block p_124172_, LootItemCondition.Builder p_124173_, LootPoolEntryContainer.Builder<?> p_124174_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)p_124172_).m_6509_(p_124173_)).m_7170_(p_124174_)));
    }

    protected static LootTable.Builder createSilkTouchDispatchTable(Block p_124169_, LootPoolEntryContainer.Builder<?> p_124170_) {
        return MalumBlockLootTables.createSelfDropDispatchTable(p_124169_, HAS_SILK_TOUCH, p_124170_);
    }

    protected static LootTable.Builder createShearsDispatchTable(Block p_124268_, LootPoolEntryContainer.Builder<?> p_124269_) {
        return MalumBlockLootTables.createSelfDropDispatchTable(p_124268_, HAS_SHEARS, p_124269_);
    }

    protected static LootTable.Builder createSilkTouchOrShearsDispatchTable(Block p_124284_, LootPoolEntryContainer.Builder<?> p_124285_) {
        return MalumBlockLootTables.createSelfDropDispatchTable(p_124284_, HAS_SHEARS_OR_SILK_TOUCH, p_124285_);
    }

    protected static LootTable.Builder createSingleItemTableWithSilkTouch(Block p_124258_, ItemLike p_124259_) {
        return MalumBlockLootTables.createSilkTouchDispatchTable(p_124258_, (LootPoolEntryContainer.Builder)MalumBlockLootTables.applyExplosionCondition((ItemLike)p_124258_, LootItem.m_79579_((ItemLike)p_124259_)));
    }

    protected static LootTable.Builder createSingleItemTableWithSilkTouchOrShears(Block p_124258_, ItemLike p_124259_) {
        return MalumBlockLootTables.createSilkTouchOrShearsDispatchTable(p_124258_, (LootPoolEntryContainer.Builder)MalumBlockLootTables.applyExplosionCondition((ItemLike)p_124258_, LootItem.m_79579_((ItemLike)p_124259_)));
    }

    protected static LootTable.Builder createSingleItemTable(ItemLike p_176040_, NumberProvider p_176041_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)MalumBlockLootTables.applyExplosionDecay(p_176040_, LootItem.m_79579_((ItemLike)p_176040_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)p_176041_)))));
    }

    protected static LootTable.Builder createSingleItemTableWithSilkTouch(Block p_176043_, ItemLike p_176044_, NumberProvider p_176045_) {
        return MalumBlockLootTables.createSilkTouchDispatchTable(p_176043_, (LootPoolEntryContainer.Builder)MalumBlockLootTables.applyExplosionDecay((ItemLike)p_176043_, LootItem.m_79579_((ItemLike)p_176044_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)p_176045_))));
    }

    protected static LootTable.Builder createSilkTouchOnlyTable(ItemLike p_124251_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_6509_(HAS_SILK_TOUCH).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_124251_)));
    }

    protected static LootTable.Builder createPotFlowerItemTable(ItemLike p_124271_) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)MalumBlockLootTables.applyExplosionCondition((ItemLike)Blocks.f_50276_, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50276_)))).m_79161_((LootPool.Builder)MalumBlockLootTables.applyExplosionCondition(p_124271_, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_124271_))));
    }

    protected static LootTable.Builder createSlabItemTable(Block p_124291_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)MalumBlockLootTables.applyExplosionDecay((ItemLike)p_124291_, LootItem.m_79579_((ItemLike)p_124291_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_124291_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))))));
    }

    protected static <T extends Comparable<T> & StringRepresentable> LootTable.Builder createSinglePropConditionTable(Block p_124162_, Property<T> p_124163_, T p_124164_) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)MalumBlockLootTables.applyExplosionCondition((ItemLike)p_124162_, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)p_124162_).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_124162_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(p_124163_, p_124164_))))));
    }

    protected static LootTable.Builder createNameableBlockEntityTable(Block p_124293_) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)MalumBlockLootTables.applyExplosionCondition((ItemLike)p_124293_, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_124293_).m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)))));
    }

    protected static LootTable.Builder createShulkerBoxDrop(Block p_124295_) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)MalumBlockLootTables.applyExplosionCondition((ItemLike)p_124295_, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_124295_).m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Lock", "BlockEntityTag.Lock").m_80279_("LootTable", "BlockEntityTag.LootTable").m_80279_("LootTableSeed", "BlockEntityTag.LootTableSeed")).m_5577_((LootItemFunction.Builder)SetContainerContents.m_193036_((BlockEntityType)BlockEntityType.f_58939_).m_80930_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)ShulkerBoxBlock.f_56184_))))));
    }

    protected static LootTable.Builder createCopperOreDrops(Block p_176047_) {
        return MalumBlockLootTables.createSilkTouchDispatchTable(p_176047_, (LootPoolEntryContainer.Builder)MalumBlockLootTables.applyExplosionDecay((ItemLike)p_176047_, LootItem.m_79579_((ItemLike)Items.f_151051_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))));
    }

    protected static LootTable.Builder createLapisOreDrops(Block p_176049_) {
        return MalumBlockLootTables.createSilkTouchDispatchTable(p_176049_, (LootPoolEntryContainer.Builder)MalumBlockLootTables.applyExplosionDecay((ItemLike)p_176049_, LootItem.m_79579_((ItemLike)Items.f_42534_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))));
    }

    protected static LootTable.Builder createRedstoneOreDrops(Block p_176051_) {
        return MalumBlockLootTables.createSilkTouchDispatchTable(p_176051_, (LootPoolEntryContainer.Builder)MalumBlockLootTables.applyExplosionDecay((ItemLike)p_176051_, LootItem.m_79579_((ItemLike)Items.f_42451_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)5.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))));
    }

    protected static LootTable.Builder createBannerDrop(Block p_124297_) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)MalumBlockLootTables.applyExplosionCondition((ItemLike)p_124297_, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_124297_).m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Patterns", "BlockEntityTag.Patterns")))));
    }

    protected static LootTable.Builder createBeeNestDrop(Block p_124299_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_6509_(HAS_SILK_TOUCH).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_124299_).m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Bees", "BlockEntityTag.Bees")).m_5577_((LootItemFunction.Builder)CopyBlockState.m_80062_((Block)p_124299_).m_80084_((Property)BeehiveBlock.f_49564_))));
    }

    protected static LootTable.Builder createBeeHiveDrop(Block p_124301_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)p_124301_).m_6509_(HAS_SILK_TOUCH)).m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Bees", "BlockEntityTag.Bees")).m_5577_((LootItemFunction.Builder)CopyBlockState.m_80062_((Block)p_124301_).m_80084_((Property)BeehiveBlock.f_49564_)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_124301_))));
    }

    protected static LootTable.Builder createCaveVinesDrop(Block p_176053_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151079_)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_176053_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)CaveVines.f_152949_, true))));
    }

    protected static LootTable.Builder createOreDrop(Block p_124140_, Item p_124141_) {
        return MalumBlockLootTables.createSilkTouchDispatchTable(p_124140_, (LootPoolEntryContainer.Builder)MalumBlockLootTables.applyExplosionDecay((ItemLike)p_124140_, LootItem.m_79579_((ItemLike)p_124141_).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))));
    }

    protected static LootTable.Builder createMushroomBlockDrop(Block p_124278_, ItemLike p_124279_) {
        return MalumBlockLootTables.createSilkTouchDispatchTable(p_124278_, (LootPoolEntryContainer.Builder)MalumBlockLootTables.applyExplosionDecay((ItemLike)p_124278_, LootItem.m_79579_((ItemLike)p_124279_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)-6.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LimitCount.m_165215_((IntRange)IntRange.m_165026_((int)0)))));
    }

    protected static LootTable.Builder createGrassDrops(Block p_124303_) {
        return MalumBlockLootTables.createShearsDispatchTable(p_124303_, (LootPoolEntryContainer.Builder)MalumBlockLootTables.applyExplosionDecay((ItemLike)p_124303_, ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42404_).m_6509_(LootItemRandomChanceCondition.m_81927_((float)0.125f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)2))));
    }

    protected static LootTable.Builder createStemDrops(Block p_124255_, Item p_124256_) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)MalumBlockLootTables.applyExplosionDecay((ItemLike)p_124255_, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_124256_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.06666667f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_124255_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)StemBlock.f_57013_, 0)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.13333334f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_124255_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)StemBlock.f_57013_, 1)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.2f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_124255_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)StemBlock.f_57013_, 2)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.26666668f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_124255_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)StemBlock.f_57013_, 3)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.33333334f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_124255_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)StemBlock.f_57013_, 4)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.4f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_124255_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)StemBlock.f_57013_, 5)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.46666667f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_124255_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)StemBlock.f_57013_, 6)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.53333336f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_124255_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)StemBlock.f_57013_, 7)))))));
    }

    protected static LootTable.Builder createAttachedStemDrops(Block p_124275_, Item p_124276_) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)MalumBlockLootTables.applyExplosionDecay((ItemLike)p_124275_, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_124276_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.53333336f))))));
    }

    protected static LootTable.Builder createShearsOnlyDrop(ItemLike p_124287_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(HAS_SHEARS).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_124287_)));
    }

    protected static LootTable.Builder createGlowLichenDrops(Block p_176055_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)MalumBlockLootTables.applyExplosionDecay((ItemLike)p_176055_, ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)p_176055_).m_6509_(HAS_SHEARS)).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_176055_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)PipeBlock.f_55149_, true)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_176055_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)PipeBlock.f_55151_, true)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_176055_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)PipeBlock.f_55148_, true)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_176055_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)PipeBlock.f_55150_, true)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_176055_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)PipeBlock.f_55152_, true)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_176055_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)PipeBlock.f_55153_, true)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)-1.0f), (boolean)true)))));
    }

    protected static LootTable.Builder createLeavesDrops(Block p_124158_, Block p_124159_, float ... p_124160_) {
        return MalumBlockLootTables.createSilkTouchOrShearsDispatchTable(p_124158_, ((LootPoolSingletonContainer.Builder)MalumBlockLootTables.applyExplosionCondition((ItemLike)p_124158_, LootItem.m_79579_((ItemLike)p_124159_))).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])p_124160_))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79076_(((LootPoolSingletonContainer.Builder)MalumBlockLootTables.applyExplosionDecay((ItemLike)p_124158_, LootItem.m_79579_((ItemLike)Items.f_42398_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
    }

    protected static LootTable.Builder createOakLeavesDrops(Block p_124264_, Block p_124265_, float ... p_124266_) {
        return MalumBlockLootTables.createLeavesDrops(p_124264_, p_124265_, p_124266_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79076_(((LootPoolSingletonContainer.Builder)MalumBlockLootTables.applyExplosionCondition((ItemLike)p_124264_, LootItem.m_79579_((ItemLike)Items.f_42410_))).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
    }

    protected static LootTable.Builder createCropDrops(Block p_124143_, Item p_124144_, Item p_124145_, LootItemCondition.Builder p_124146_) {
        return (LootTable.Builder)MalumBlockLootTables.applyExplosionDecay((ItemLike)p_124143_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)p_124144_).m_6509_(p_124146_)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_124145_)))).m_79161_(LootPool.m_79043_().m_6509_(p_124146_).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_124145_).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))));
    }

    protected static LootTable.Builder createDoublePlantShearsDrop(Block p_124305_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_6509_(HAS_SHEARS).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_124305_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)))));
    }

    protected static LootTable.Builder createDoublePlantWithSeedDrops(Block p_124261_, Block p_124262_) {
        AlternativesEntry.Builder builder = ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)p_124262_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f))).m_6509_(HAS_SHEARS)).m_7170_(((LootPoolSingletonContainer.Builder)MalumBlockLootTables.applyExplosionCondition((ItemLike)p_124261_, LootItem.m_79579_((ItemLike)Items.f_42404_))).m_6509_(LootItemRandomChanceCondition.m_81927_((float)0.125f)));
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)builder).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_124261_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER))).m_6509_(LocationCheck.m_81727_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{p_124261_}).m_17929_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER).m_67706_()).m_17931_()), (BlockPos)new BlockPos(0, 1, 0)))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)builder).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_124261_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER))).m_6509_(LocationCheck.m_81727_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{p_124261_}).m_17929_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER).m_67706_()).m_17931_()), (BlockPos)new BlockPos(0, -1, 0))));
    }

    protected static LootTable.Builder createCandleDrops(Block p_176057_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)MalumBlockLootTables.applyExplosionDecay((ItemLike)p_176057_, LootItem.m_79579_((ItemLike)p_176057_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_176057_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CandleBlock.f_152790_, 2)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_176057_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CandleBlock.f_152790_, 3)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_176057_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CandleBlock.f_152790_, 4)))))));
    }

    protected static LootTable.Builder createCandleCakeDrops(Block p_176059_) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)p_176059_)));
    }

    public static LootTable.Builder noDrop() {
        return LootTable.m_79147_();
    }

    public static LootTable.Builder createDoorTable(Block p_124138_) {
        return MalumBlockLootTables.createSinglePropConditionTable(p_124138_, DoorBlock.f_52730_, DoubleBlockHalf.LOWER);
    }

    protected Iterable<Block> getKnownBlocks() {
        return Registry.f_122824_;
    }

    public void dropPottedContents(Block p_124253_) {
        this.add(p_124253_, (Block p_176061_) -> MalumBlockLootTables.createPotFlowerItemTable((ItemLike)((FlowerPotBlock)p_176061_).m_53560_()));
    }

    public void otherWhenSilkTouch(Block p_124155_, Block p_124156_) {
        this.add(p_124155_, MalumBlockLootTables.createSilkTouchOnlyTable((ItemLike)p_124156_));
    }

    public void dropOther(Block p_124148_, ItemLike p_124149_) {
        this.add(p_124148_, MalumBlockLootTables.createSingleItemTable(p_124149_));
    }

    public void dropWhenSilkTouch(Block p_124273_) {
        this.otherWhenSilkTouch(p_124273_, p_124273_);
    }

    public void dropSelf(Block p_124289_) {
        this.dropOther(p_124289_, (ItemLike)p_124289_);
    }

    protected void add(Block p_124176_, Function<Block, LootTable.Builder> p_124177_) {
        this.add(p_124176_, p_124177_.apply(p_124176_));
    }

    protected void add(Block block, LootTable.Builder builder) {
        this.add(block.m_60589_(), builder);
    }

    protected void add(ResourceLocation path, LootTable.Builder lootTable) {
        this.tables.add((Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>)Pair.of(() -> lootBuilder -> lootBuilder.accept(path, lootTable), (Object)LootContextParamSets.f_81421_));
    }
}

