/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compability.jei.categories;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ProgressionBookScreen;
import com.sammy.malum.core.setup.content.item.ItemRegistry;
import com.sammy.malum.core.systems.rites.MalumRiteType;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SpiritRiteRecipeCategory
implements IRecipeCategory<MalumRiteType> {
    public static final ResourceLocation UID = MalumMod.prefix("spirit_rite");
    private final IDrawable background;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final Font font;

    public SpiritRiteRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(142, 185);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("malum", "textures/gui/spirit_rite_jei.png"), 0, 0, 142, 183);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ItemRegistry.RUNEWOOD_TOTEM_BASE.get()));
        this.font = Minecraft.m_91087_().f_91062_;
    }

    public void draw(MalumRiteType rite, PoseStack poseStack, double mouseX, double mouseY) {
        this.overlay.draw(poseStack);
        ProgressionBookScreen.renderText(poseStack, (Component)new TranslatableComponent(rite.translationIdentifier()), 106 - this.font.m_92895_(rite.translationIdentifier()) / 2, 160);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends MalumRiteType> getRecipeClass() {
        return MalumRiteType.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("malum.jei." + UID.m_135815_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(MalumRiteType rite, IIngredients iIngredients) {
        ArrayList items = new ArrayList();
        rite.spirits.forEach(spirit -> items.add(spirit.getSplinterItem().m_7968_()));
        iIngredients.setInputs(VanillaTypes.ITEM, items);
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, MalumRiteType rite, IIngredients iIngredients) {
        for (int i = 0; i < rite.spirits.size(); ++i) {
            iRecipeLayout.getItemStacks().init(i, true, 62, 120 - 20 * i);
            iRecipeLayout.getItemStacks().set(i, rite.spirits.get(i).getSplinterItem().m_7968_());
        }
    }
}

