/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compability.jei.categories;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ProgressionBookScreen;
import com.sammy.malum.common.recipe.SpiritRepairRecipe;
import com.sammy.malum.compability.jei.JEIHandler;
import com.sammy.malum.core.setup.content.item.ItemRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SpiritRepairRecipeCategory
implements IRecipeCategory<SpiritRepairRecipe> {
    public static final ResourceLocation UID = MalumMod.prefix("spirit_repair");
    private final IDrawable background;
    private final IDrawable overlay;
    private final IDrawable icon;

    public SpiritRepairRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(142, 185);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("malum", "textures/gui/spirit_repair_jei.png"), 0, 0, 142, 183);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ItemRegistry.SPIRIT_CRUCIBLE.get()));
    }

    public void draw(SpiritRepairRecipe recipe, PoseStack poseStack, double mouseX, double mouseY) {
        this.overlay.draw(poseStack);
        if (recipe.spirits.size() > 0) {
            ProgressionBookScreen.renderItemFrames(poseStack, 61, 12, false, recipe.spirits.size());
        }
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends SpiritRepairRecipe> getRecipeClass() {
        return SpiritRepairRecipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("malum.jei." + UID.m_135815_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(SpiritRepairRecipe recipe, IIngredients iIngredients) {
        ArrayList items = (ArrayList)recipe.inputs.stream().map(Item::m_7968_).collect(Collectors.toList());
        iIngredients.setOutputs(VanillaTypes.ITEM, (List)items);
        recipe.spirits.forEach(i -> items.add(i.getStack()));
        items.addAll(recipe.repairMaterial.getStacks());
        iIngredients.setInputs(VanillaTypes.ITEM, (List)items);
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, SpiritRepairRecipe recipe, IIngredients iIngredients) {
        int index = 0;
        List repaired = recipe.inputs.stream().map(Item::m_7968_).collect(Collectors.toList());
        ArrayList repairIngredient = recipe.repairMaterial.getStacks();
        ArrayList damaged = repaired.stream().map(ItemStack::m_41777_).peek(s -> s.m_41721_((int)((float)s.m_41776_() * recipe.durabilityPercentage))).collect(Collectors.toCollection(ArrayList::new));
        index = JEIHandler.addItemsToJei(iRecipeLayout, 61, 12, false, recipe.spirits, index);
        iRecipeLayout.getItemStacks().init(index + 1, true, 81, 56);
        iRecipeLayout.getItemStacks().set(index + 1, (List)damaged);
        iRecipeLayout.getItemStacks().init(index + 2, true, 62, 123);
        iRecipeLayout.getItemStacks().set(index + 2, repaired.stream().map(SpiritRepairRecipe::getRepairRecipeOutput).collect(Collectors.toList()));
        iRecipeLayout.getItemStacks().init(index + 3, true, 43, 56);
        iRecipeLayout.getItemStacks().set(index + 3, (List)repairIngredient);
    }
}

