/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compability.jei.categories;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ProgressionBookScreen;
import com.sammy.malum.common.recipe.SpiritFocusingRecipe;
import com.sammy.malum.compability.jei.JEIHandler;
import com.sammy.malum.core.setup.content.item.ItemRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SpiritFocusingRecipeCategory
implements IRecipeCategory<SpiritFocusingRecipe> {
    public static final ResourceLocation UID = MalumMod.prefix("spirit_focusing");
    private final IDrawable background;
    private final IDrawable overlay;
    private final IDrawable icon;

    public SpiritFocusingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(142, 185);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("malum", "textures/gui/spirit_focusing_jei.png"), 0, 0, 142, 183);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ItemRegistry.SPIRIT_CRUCIBLE.get()));
    }

    public void draw(SpiritFocusingRecipe recipe, PoseStack poseStack, double mouseX, double mouseY) {
        this.overlay.draw(poseStack);
        if (recipe.spirits.size() > 0) {
            ProgressionBookScreen.renderItemFrames(poseStack, 61, 12, false, recipe.spirits.size());
        }
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends SpiritFocusingRecipe> getRecipeClass() {
        return SpiritFocusingRecipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("malum.jei." + UID.m_135815_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(SpiritFocusingRecipe recipe, IIngredients iIngredients) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(Arrays.asList(recipe.input.m_43908_()));
        recipe.spirits.forEach(ingredient -> items.add(ingredient.getStack()));
        iIngredients.setInputs(VanillaTypes.ITEM, items);
        iIngredients.setOutputs(VanillaTypes.ITEM, (List)recipe.output.getStacks());
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, SpiritFocusingRecipe recipe, IIngredients iIngredients) {
        int index = 0;
        index = JEIHandler.addItemsToJei(iRecipeLayout, 61, 12, false, recipe.spirits, index);
        iRecipeLayout.getItemStacks().init(index + 1, true, 62, 56);
        iRecipeLayout.getItemStacks().set(index + 1, Arrays.asList(recipe.input.m_43908_()));
        iRecipeLayout.getItemStacks().init(index + 2, true, 62, 123);
        iRecipeLayout.getItemStacks().set(index + 2, (List)recipe.output.getStacks());
    }
}

