/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compability.jei;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.recipe.BlockTransmutationRecipe;
import com.sammy.malum.common.recipe.SpiritFocusingRecipe;
import com.sammy.malum.common.recipe.SpiritInfusionRecipe;
import com.sammy.malum.common.recipe.SpiritRepairRecipe;
import com.sammy.malum.compability.farmersdelight.FarmersDelightCompat;
import com.sammy.malum.compability.jei.categories.BlockTransmutationRecipeCategory;
import com.sammy.malum.compability.jei.categories.SpiritFocusingRecipeCategory;
import com.sammy.malum.compability.jei.categories.SpiritInfusionRecipeCategory;
import com.sammy.malum.compability.jei.categories.SpiritRepairRecipeCategory;
import com.sammy.malum.compability.jei.categories.SpiritRiteRecipeCategory;
import com.sammy.malum.core.setup.content.SpiritRiteRegistry;
import com.sammy.malum.core.setup.content.item.ItemRegistry;
import com.sammy.ortus.systems.recipe.IRecipeComponent;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@JeiPlugin
public class JEIHandler
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("malum", "main");

    public static int addItemsToJei(IRecipeLayout iRecipeLayout, int left, int top, boolean vertical, List<? extends IRecipeComponent> components, int baseIndex) {
        int slots = components.size();
        if (vertical) {
            top -= 10 * (slots - 1);
        } else {
            left -= 10 * (slots - 1);
        }
        for (int i = 0; i < slots; ++i) {
            int offset = i * 20;
            int oLeft = left + 1 + (vertical ? 0 : offset);
            int oTop = top + 1 + (vertical ? offset : 0);
            ItemStack stack = components.get(i).getStack();
            iRecipeLayout.getItemStacks().init(baseIndex + i, true, oLeft, oTop);
            iRecipeLayout.getItemStacks().set(baseIndex + i, stack);
        }
        return baseIndex + components.size() + 1;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new SpiritInfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new BlockTransmutationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SpiritFocusingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SpiritRiteRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SpiritRepairRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        registry.addRecipes(SpiritInfusionRecipe.getRecipes((Level)level), SpiritInfusionRecipeCategory.UID);
        registry.addRecipes(BlockTransmutationRecipe.getRecipes((Level)level), BlockTransmutationRecipeCategory.UID);
        registry.addRecipes(SpiritFocusingRecipe.getRecipes((Level)level), SpiritFocusingRecipeCategory.UID);
        registry.addRecipes(SpiritRiteRegistry.RITES, SpiritRiteRecipeCategory.UID);
        registry.addRecipes(SpiritRepairRecipe.getRecipes((Level)level), SpiritRepairRecipeCategory.UID);
        if (FarmersDelightCompat.LOADED) {
            FarmersDelightCompat.LoadedOnly.addInfo(registry);
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.SPIRIT_ALTAR.get()), new ResourceLocation[]{SpiritInfusionRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.RUNEWOOD_TOTEM_BASE.get()), new ResourceLocation[]{SpiritRiteRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.SOULWOOD_TOTEM_BASE.get()), new ResourceLocation[]{BlockTransmutationRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.SPIRIT_CRUCIBLE.get()), new ResourceLocation[]{SpiritFocusingRecipeCategory.UID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.SPIRIT_CRUCIBLE.get()), new ResourceLocation[]{SpiritRepairRecipeCategory.UID});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IRecipeManager recipeRegistry = jeiRuntime.getRecipeManager();
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        recipeManager.m_44043_(MalumMod.prefix("the_device")).ifPresent(r -> recipeRegistry.hideRecipe(r, VanillaRecipeCategoryUid.CRAFTING));
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }
}

