/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldgen;

import com.sammy.malum.common.block.MalumLeavesBlock;
import com.sammy.malum.common.block.MalumSaplingBlock;
import com.sammy.malum.core.setup.content.block.BlockRegistry;
import com.sammy.ortus.helpers.BlockHelper;
import com.sammy.ortus.helpers.DataHelper;
import com.sammy.ortus.systems.worldgen.OrtusBlockFiller;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class RunewoodTreeFeature
extends Feature<NoneFeatureConfiguration> {
    private static final int minimumSapBlockCount = 2;
    private static final int extraSapBlockCount = 1;
    private static final int minimumTrunkHeight = 7;
    private static final int extraTrunkHeight = 3;
    private static final int minimumSideTrunkHeight = 0;
    private static final int extraSideTrunkHeight = 2;
    private static final int minimumDownwardsBranchOffset = 2;
    private static final int extraDownwardsBranchOffset = 2;
    private static final int minimumBranchCoreOffset = 2;
    private static final int branchCoreOffsetExtra = 1;
    private static final int minimumBranchHeight = 3;
    private static final int branchHeightExtra = 2;

    public RunewoodTreeFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int[] sapBlockIndexes;
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random rand = context.m_159776_();
        if (level.m_46859_(pos.m_7495_()) || !((Block)BlockRegistry.RUNEWOOD_SAPLING.get()).m_49966_().m_60710_((LevelReader)level, pos)) {
            return false;
        }
        BlockState defaultLog = ((Block)BlockRegistry.RUNEWOOD_LOG.get()).m_49966_();
        OrtusBlockFiller treeFiller = new OrtusBlockFiller(false);
        OrtusBlockFiller leavesFiller = new OrtusBlockFiller(true);
        int trunkHeight = 7 + rand.nextInt(4);
        BlockPos trunkTop = pos.m_6630_(trunkHeight);
        Direction[] directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
        for (int i = 0; i <= trunkHeight; ++i) {
            BlockPos trunkPos = pos.m_6630_(i);
            if (!RunewoodTreeFeature.canPlace(level, trunkPos)) {
                return false;
            }
            treeFiller.entries.add(new OrtusBlockFiller.BlockStateEntry(defaultLog, trunkPos));
        }
        RunewoodTreeFeature.makeLeafBlob(leavesFiller, rand, trunkTop);
        for (Direction direction : directions) {
            int sideTrunkHeight = 0 + rand.nextInt(3);
            for (int i = 0; i < sideTrunkHeight; ++i) {
                BlockPos sideTrunkPos = pos.m_142300_(direction).m_6630_(i);
                if (!RunewoodTreeFeature.canPlace(level, sideTrunkPos)) {
                    return false;
                }
                treeFiller.entries.add(new OrtusBlockFiller.BlockStateEntry(defaultLog, sideTrunkPos));
            }
            RunewoodTreeFeature.downwardsTrunk(level, treeFiller, pos.m_142300_(direction));
        }
        for (Direction direction : directions) {
            int branchCoreOffset = 2 + rand.nextInt(3);
            int branchOffset = 2 + rand.nextInt(2);
            BlockPos branchStartPos = trunkTop.m_6625_(branchCoreOffset).m_5484_(direction, branchOffset);
            for (int i = 0; i < branchOffset; ++i) {
                BlockPos branchConnectionPos = branchStartPos.m_5484_(direction.m_122424_(), i);
                if (!RunewoodTreeFeature.canPlace(level, branchConnectionPos)) {
                    return false;
                }
                treeFiller.entries.add(new OrtusBlockFiller.BlockStateEntry((BlockState)defaultLog.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()), branchConnectionPos));
            }
            int branchHeight = 3 + rand.nextInt(3);
            for (int i = 0; i < branchHeight; ++i) {
                BlockPos branchPos = branchStartPos.m_6630_(i);
                if (!RunewoodTreeFeature.canPlace(level, branchPos)) {
                    return false;
                }
                treeFiller.entries.add(new OrtusBlockFiller.BlockStateEntry(defaultLog, branchPos));
            }
            RunewoodTreeFeature.makeLeafBlob(leavesFiller, rand, branchStartPos.m_6630_(1));
        }
        int sapBlockCount = 2 + rand.nextInt(2);
        int[] nArray = sapBlockIndexes = DataHelper.nextInts((Random)rand, (int)sapBlockCount, (int)treeFiller.entries.size());
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer index = nArray[i];
            OrtusBlockFiller.BlockStateEntry oldEntry = (OrtusBlockFiller.BlockStateEntry)treeFiller.entries.get(index);
            BlockState newState = BlockHelper.getBlockStateWithExistingProperties((BlockState)oldEntry.state, (BlockState)((Block)BlockRegistry.EXPOSED_RUNEWOOD_LOG.get()).m_49966_());
            treeFiller.replaceAt(index.intValue(), new OrtusBlockFiller.BlockStateEntry(newState, oldEntry.pos));
        }
        treeFiller.fill(level);
        leavesFiller.fill(level);
        return true;
    }

    public static void downwardsTrunk(WorldGenLevel level, OrtusBlockFiller filler, BlockPos pos) {
        BlockPos trunkPos;
        int i = 0;
        while (RunewoodTreeFeature.canPlace(level, trunkPos = pos.m_6625_(++i))) {
            filler.entries.add(new OrtusBlockFiller.BlockStateEntry(((Block)BlockRegistry.RUNEWOOD_LOG.get()).m_49966_(), trunkPos));
            if (i <= level.m_151558_()) continue;
            break;
        }
    }

    public static void makeLeafBlob(OrtusBlockFiller filler, Random rand, BlockPos pos) {
        RunewoodTreeFeature.makeLeafSlice(filler, pos, 1, 0);
        RunewoodTreeFeature.makeLeafSlice(filler, pos.m_6630_(1), 2, 1);
        RunewoodTreeFeature.makeLeafSlice(filler, pos.m_6630_(2), 2, 2);
        RunewoodTreeFeature.makeLeafSlice(filler, pos.m_6630_(3), 2, 3);
        RunewoodTreeFeature.makeLeafSlice(filler, pos.m_6630_(4), 1, 4);
    }

    public static void makeLeafSlice(OrtusBlockFiller filler, BlockPos pos, int leavesSize, int leavesColor) {
        for (int x = -leavesSize; x <= leavesSize; ++x) {
            for (int z = -leavesSize; z <= leavesSize; ++z) {
                if (Math.abs(x) == leavesSize && Math.abs(z) == leavesSize) continue;
                BlockPos leavesPos = new BlockPos((Vec3i)pos).m_142082_(x, 0, z);
                filler.entries.add(new OrtusBlockFiller.BlockStateEntry((BlockState)((BlockState)((Block)BlockRegistry.RUNEWOOD_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1))).m_61124_((Property)MalumLeavesBlock.COLOR, (Comparable)Integer.valueOf(leavesColor)), leavesPos));
            }
        }
    }

    public static boolean canPlace(WorldGenLevel level, BlockPos pos) {
        if (level.m_151570_(pos)) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        return state.m_60734_() instanceof MalumSaplingBlock || level.m_46859_(pos) || state.m_60767_().m_76336_();
    }
}

