/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite;

import com.sammy.malum.common.packets.particle.MagicParticlePacket;
import com.sammy.malum.core.setup.content.DamageSourceRegistry;
import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import com.sammy.malum.core.setup.server.PacketRegistry;
import com.sammy.malum.core.systems.rites.MalumRiteType;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class EldritchWickedRiteType
extends MalumRiteType {
    public EldritchWickedRiteType() {
        super("eldritch_wicked_rite", SpiritTypeRegistry.ELDRITCH_SPIRIT, SpiritTypeRegistry.ARCANE_SPIRIT, SpiritTypeRegistry.WICKED_SPIRIT, SpiritTypeRegistry.WICKED_SPIRIT);
    }

    @Override
    public int range(boolean corrupted) {
        return this.defaultRange() / 2;
    }

    @Override
    public void riteEffect(Level level, BlockPos pos, int height) {
        if (!level.f_46443_) {
            this.getNearbyEntities(LivingEntity.class, level, pos, false).forEach(e -> {
                if (!(e instanceof Player)) {
                    e.m_6469_(DamageSourceRegistry.VOODOO, 5.0f);
                }
            });
        }
    }

    @Override
    public void corruptedRiteEffect(Level level, BlockPos pos, int height) {
        if (!level.f_46443_) {
            ArrayList<Animal> entities = this.getNearbyEntities(Animal.class, level, pos, true);
            if (entities.size() < 30) {
                return;
            }
            int maxKills = entities.size() - 30;
            for (Animal entity : entities) {
                if (!entity.m_27593_() && entity.m_146764_() > 0) {
                    entity.m_6469_(DamageSourceRegistry.VOODOO, entity.m_21233_());
                    PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new MagicParticlePacket(SpiritTypeRegistry.WICKED_SPIRIT_COLOR, entity.m_142538_().m_123341_(), (float)entity.m_142538_().m_123342_() + entity.m_20206_() / 2.0f, entity.m_142538_().m_123343_()));
                    --maxKills;
                }
                if (maxKills > 0) continue;
                return;
            }
        }
    }
}

