/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite;

import com.sammy.malum.common.packets.particle.BlockMistParticlePacket;
import com.sammy.malum.common.packets.particle.MagicParticlePacket;
import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import com.sammy.malum.core.setup.server.PacketRegistry;
import com.sammy.malum.core.systems.rites.MalumRiteType;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class EldritchSacredRiteType
extends MalumRiteType {
    public EldritchSacredRiteType() {
        super("eldritch_sacred_rite", SpiritTypeRegistry.ELDRITCH_SPIRIT, SpiritTypeRegistry.ARCANE_SPIRIT, SpiritTypeRegistry.SACRED_SPIRIT, SpiritTypeRegistry.SACRED_SPIRIT);
    }

    @Override
    public int range(boolean corrupted) {
        return this.defaultRange() / 2;
    }

    @Override
    public int interval(boolean corrupted) {
        return this.defaultInterval() * 3;
    }

    @Override
    public void riteEffect(Level level, BlockPos pos, int height) {
        if (!level.f_46443_) {
            this.getNearbyBlocks(BonemealableBlock.class, level, pos, false).forEach(p -> {
                if (level.f_46441_.nextFloat() <= 0.06f) {
                    BlockState state = level.m_8055_(p);
                    for (int i = 0; i < 5 + level.f_46441_.nextInt(3); ++i) {
                        state.m_60735_((ServerLevel)level, p, level.f_46441_);
                    }
                    BlockPos particlePos = state.m_60815_() ? p : p.m_7495_();
                    PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)new BlockMistParticlePacket(SpiritTypeRegistry.SACRED_SPIRIT_COLOR, particlePos.m_123341_(), particlePos.m_123342_(), particlePos.m_123343_()));
                }
            });
        }
    }

    @Override
    public void corruptedRiteEffect(Level level, BlockPos pos, int height) {
        if (!level.f_46443_) {
            ArrayList<Animal> entities = this.getNearbyEntities(Animal.class, level, pos, true);
            entities.removeIf(e -> e.m_146764_() < 0);
            if (entities.size() > 30) {
                return;
            }
            entities.forEach(e -> {
                if (e.m_5957_() && e.m_146764_() == 0 && level.f_46441_.nextFloat() <= 0.05f) {
                    e.m_27601_(600);
                    PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> e), (Object)new MagicParticlePacket(SpiritTypeRegistry.SACRED_SPIRIT_COLOR, e.m_142538_().m_123341_(), (float)e.m_142538_().m_123342_() + e.m_20206_() / 2.0f, e.m_142538_().m_123343_()));
                }
            });
        }
    }
}

