/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite;

import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import com.sammy.malum.core.systems.rites.MalumRiteType;
import com.sammy.ortus.setup.OrtusParticles;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public class EldritchInfernalRiteType
extends MalumRiteType {
    public EldritchInfernalRiteType() {
        super("eldritch_infernal_rite", SpiritTypeRegistry.ELDRITCH_SPIRIT, SpiritTypeRegistry.ARCANE_SPIRIT, SpiritTypeRegistry.INFERNAL_SPIRIT, SpiritTypeRegistry.INFERNAL_SPIRIT);
    }

    @Override
    public int interval(boolean corrupted) {
        return corrupted ? this.defaultInterval() : this.defaultInterval() * 3;
    }

    @Override
    public int range(boolean corrupted) {
        return this.defaultRange() / 4;
    }

    @Override
    public void riteEffect(Level level, BlockPos pos, int height) {
        BlockState filter = level.m_8055_(pos.m_7495_());
        Optional fillerOptional = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{new ItemStack((ItemLike)filter.m_60734_().m_5456_(), 1)}), level);
        ArrayList<BlockPos> positions = this.getNearbyBlocksUnderBase(Block.class, level, pos, false);
        positions.removeIf(p -> {
            if (p.m_123341_() == pos.m_123341_() && p.m_123343_() == pos.m_123343_()) {
                return true;
            }
            BlockState state = level.m_8055_(p);
            return fillerOptional.isPresent() && !filter.m_60795_() && !filter.m_60713_(state.m_60734_());
        });
        positions.forEach(p -> {
            SmeltingRecipe recipe;
            ItemStack output;
            BlockState state = level.m_8055_(p);
            Optional optional = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{new ItemStack((ItemLike)state.m_60734_().m_5456_(), 1)}), level);
            if (optional.isPresent() && (output = (recipe = (SmeltingRecipe)optional.get()).m_8043_()).m_41720_() instanceof BlockItem) {
                if (!level.f_46443_) {
                    Block block = ((BlockItem)output.m_41720_()).m_40614_();
                    BlockState newState = block.m_49966_();
                    level.m_46597_(p, newState);
                    level.m_46796_(2001, p, Block.m_49956_((BlockState)newState));
                } else {
                    this.particles(level, (BlockPos)p);
                }
            }
        });
    }

    @Override
    public void corruptedRiteEffect(Level level, BlockPos pos, int height) {
        ArrayList<BlockPos> positions = this.getNearbyBlocksUnderBase(Block.class, level, pos, false);
        positions.removeIf(p -> p.m_123341_() == pos.m_123341_() && p.m_123343_() == pos.m_123343_() || !level.m_8055_(p).m_60713_(Blocks.f_50069_));
        positions.forEach(p -> {
            BlockState netherrack = Blocks.f_50134_.m_49966_();
            if (!level.f_46443_) {
                level.m_46597_(p, netherrack);
                level.m_46796_(2001, p, Block.m_49956_((BlockState)netherrack));
            } else {
                this.particles(level, (BlockPos)p);
            }
        });
    }

    public void particles(Level level, BlockPos pos) {
        Color color = SpiritTypeRegistry.INFERNAL_SPIRIT_COLOR;
        ParticleBuilders.create((RegistryObject)OrtusParticles.TWINKLE_PARTICLE).setAlpha(0.4f, 0.0f).setLifetime(20).setSpin(0.3f).setScale(0.2f, 0.0f).setColor(color, color).enableNoClip().randomOffset((double)0.1f, (double)0.1f).randomMotion((double)0.001f, (double)0.001f).evenlyRepeatEdges(level, pos, 4, new Direction[]{Direction.UP, Direction.DOWN});
        ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(0.1f, 0.0f).setLifetime(40).setSpin(0.1f).setScale(0.6f, 0.0f).setColor(color, color).randomOffset((double)0.2f).enableNoClip().randomMotion((double)0.001f, (double)0.001f).evenlyRepeatEdges(level, pos, 6, new Direction[]{Direction.UP, Direction.DOWN});
    }
}

