/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite;

import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import com.sammy.malum.core.systems.rites.MalumRiteType;
import com.sammy.ortus.setup.OrtusParticles;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public class EldritchEarthenRiteType
extends MalumRiteType {
    public EldritchEarthenRiteType() {
        super("eldritch_earthen_rite", SpiritTypeRegistry.ELDRITCH_SPIRIT, SpiritTypeRegistry.ARCANE_SPIRIT, SpiritTypeRegistry.EARTHEN_SPIRIT, SpiritTypeRegistry.EARTHEN_SPIRIT);
    }

    @Override
    public int interval(boolean corrupted) {
        return corrupted ? this.defaultInterval() : this.defaultInterval() * 3;
    }

    @Override
    public int range(boolean corrupted) {
        return this.defaultRange() / 4;
    }

    @Override
    public void riteEffect(Level level, BlockPos pos, int height) {
        BlockState filter = level.m_8055_(pos.m_7495_());
        ArrayList<BlockPos> positions = this.getNearbyBlocksUnderBase(Block.class, level, pos, false);
        positions.removeIf(p -> {
            if (p.m_123341_() == pos.m_123341_() && p.m_123343_() == pos.m_123343_()) {
                return true;
            }
            BlockState state = level.m_8055_(p);
            if (state.m_60795_()) {
                return true;
            }
            return !filter.m_60795_() && !filter.m_60713_(state.m_60734_());
        });
        positions.forEach(p -> {
            boolean canBreak;
            BlockState state = level.m_8055_(p);
            boolean bl = canBreak = state.m_204336_(BlockTags.f_144286_) || state.m_204336_(BlockTags.f_144285_) || state.m_204336_(BlockTags.f_144284_);
            if (canBreak) {
                if (!level.f_46443_) {
                    level.m_46961_(p, true);
                } else {
                    this.particles(level, (BlockPos)p);
                }
            }
        });
    }

    @Override
    public void corruptedRiteEffect(Level level, BlockPos pos, int height) {
        ArrayList<BlockPos> positions = this.getNearbyBlocksUnderBase(Block.class, level, pos, false);
        positions.removeIf(p -> p.m_123341_() == pos.m_123341_() && p.m_123343_() == pos.m_123343_() || !level.m_8055_(p).m_60795_());
        positions.forEach(p -> {
            BlockState cobblestone = Blocks.f_50652_.m_49966_();
            if (!level.f_46443_) {
                level.m_46597_(p, cobblestone);
                level.m_46796_(2001, p, Block.m_49956_((BlockState)cobblestone));
            } else {
                this.particles(level, (BlockPos)p);
            }
        });
    }

    public void particles(Level level, BlockPos pos) {
        Color color = SpiritTypeRegistry.EARTHEN_SPIRIT_COLOR;
        ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(0.2f, 0.0f).setLifetime(20).setSpin(0.2f).setScale(0.4f, 0.0f).setColor(color, color).enableNoClip().randomOffset((double)0.1f, (double)0.1f).randomMotion((double)0.001f, (double)0.001f).evenlyRepeatEdges(level, pos, 4, new Direction[]{Direction.UP, Direction.DOWN});
        ParticleBuilders.create((RegistryObject)OrtusParticles.SMOKE_PARTICLE).setAlpha(0.1f, 0.0f).setLifetime(40).setSpin(0.1f).setScale(0.6f, 0.0f).setColor(color, color).randomOffset((double)0.2f).enableNoClip().randomMotion((double)0.001f, (double)0.001f).evenlyRepeatEdges(level, pos, 6, new Direction[]{Direction.UP, Direction.DOWN});
    }
}

