/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite;

import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import com.sammy.malum.core.systems.rites.MalumRiteType;
import com.sammy.ortus.setup.OrtusParticles;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.RegistryObject;

public class EldritchAqueousRiteType
extends MalumRiteType {
    private static final BlockState OBSIDIAN = Blocks.f_50080_.m_49966_();
    private static final BlockState ICE = Blocks.f_50126_.m_49966_();

    public EldritchAqueousRiteType() {
        super("eldritch_aqueous_rite", SpiritTypeRegistry.ELDRITCH_SPIRIT, SpiritTypeRegistry.ARCANE_SPIRIT, SpiritTypeRegistry.AQUEOUS_SPIRIT, SpiritTypeRegistry.AQUEOUS_SPIRIT);
    }

    @Override
    public int interval(boolean corrupted) {
        return corrupted ? this.defaultInterval() * 5 : this.defaultInterval() * 2;
    }

    @Override
    public int range(boolean corrupted) {
        return corrupted ? this.defaultRange() / 4 : this.defaultRange();
    }

    @Override
    public void riteEffect(Level level, BlockPos pos, int height) {
        ArrayList<BlockPos> positions = this.getNearbyBlocks(PointedDripstoneBlock.class, level, pos, false);
        positions.removeIf(p -> !PointedDripstoneBlock.m_154203_((BlockState)level.m_8055_(p), (LevelReader)level, (BlockPos)p));
        positions.forEach(p -> {
            if (level.f_46443_) {
                this.particles(level, (BlockPos)p);
            } else if (level.f_46441_.nextFloat() < 0.1f) {
                level.m_8055_(p).m_60735_((ServerLevel)level, p, level.f_46441_);
            }
        });
    }

    @Override
    public void corruptedRiteEffect(Level level, BlockPos pos, int height) {
        ArrayList<BlockPos> positions = this.getNearbyBlocksUnderBase(Block.class, level, pos, false);
        positions.removeIf(p -> p.m_123341_() == pos.m_123341_() && p.m_123343_() == pos.m_123343_() || level.m_8055_(p).m_60819_().m_76178_());
        positions.forEach(p -> {
            FluidState fluidState = level.m_6425_(p);
            BlockState state = null;
            if (fluidState.m_192917_((Fluid)Fluids.f_76193_)) {
                state = ICE;
            } else if (fluidState.m_192917_((Fluid)Fluids.f_76195_)) {
                state = OBSIDIAN;
            }
            if (state == null) {
                return;
            }
            if (!level.f_46443_) {
                level.m_46597_(p, state);
                level.m_46796_(2001, p, Block.m_49956_((BlockState)state));
            } else {
                this.particles(level, (BlockPos)p);
            }
        });
    }

    public void particles(Level level, BlockPos pos) {
        Color color = SpiritTypeRegistry.AQUEOUS_SPIRIT_COLOR;
        ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(0.2f, 0.0f).setLifetime(20).setSpin(0.2f).setScale(0.4f, 0.0f).setColor(color, color).enableNoClip().randomOffset((double)0.1f, (double)0.1f).randomMotion((double)0.001f, (double)0.001f).evenlyRepeatEdges(level, pos, 6, new Direction[]{Direction.UP});
        ParticleBuilders.create((RegistryObject)OrtusParticles.TWINKLE_PARTICLE).setAlpha(0.1f, 0.0f).setLifetime(40).setSpin(0.1f).setScale(0.6f, 0.0f).setColor(color, color).randomOffset((double)0.2f).enableNoClip().randomMotion((double)0.001f, (double)0.001f).evenlyRepeatEdges(level, pos, 8, new Direction[]{Direction.UP});
    }
}

