/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite;

import com.sammy.malum.common.packets.particle.BlockSparkleParticlePacket;
import com.sammy.malum.common.packets.particle.MagicParticlePacket;
import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import com.sammy.malum.core.setup.content.potion.EffectRegistry;
import com.sammy.malum.core.setup.server.PacketRegistry;
import com.sammy.malum.core.systems.rites.MalumRiteType;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class EldritchAerialRiteType
extends MalumRiteType {
    public EldritchAerialRiteType() {
        super("eldritch_aerial_rite", SpiritTypeRegistry.ELDRITCH_SPIRIT, SpiritTypeRegistry.ARCANE_SPIRIT, SpiritTypeRegistry.AERIAL_SPIRIT, SpiritTypeRegistry.AERIAL_SPIRIT);
    }

    @Override
    public int interval(boolean corrupted) {
        return corrupted ? this.defaultInterval() : this.defaultInterval() * 3;
    }

    @Override
    public int range(boolean corrupted) {
        return this.defaultRange() / 4;
    }

    @Override
    public void riteEffect(Level level, BlockPos pos, int height) {
        if (!level.f_46443_) {
            BlockState filter = level.m_8055_(pos.m_7495_());
            ArrayList<BlockPos> positions = this.getNearbyBlocksUnderBase(Block.class, level, pos, false);
            positions.removeIf(p -> {
                if (p.m_123341_() == pos.m_123341_() && p.m_123343_() == pos.m_123343_()) {
                    return true;
                }
                BlockState state = level.m_8055_(p);
                if (state.m_60795_()) {
                    return true;
                }
                return !filter.m_60795_() && !filter.m_60713_(state.m_60734_());
            });
            positions.forEach(p -> {
                BlockState stateBelow = level.m_8055_(p.m_7495_());
                if (!stateBelow.m_60815_() || stateBelow.m_204336_(BlockTags.f_13031_)) {
                    BlockState state = level.m_8055_(p);
                    FallingBlockEntity.m_201971_((Level)level, (BlockPos)p, (BlockState)state);
                    PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)new BlockSparkleParticlePacket(SpiritTypeRegistry.AERIAL_SPIRIT_COLOR, p.m_123341_(), p.m_123342_(), p.m_123343_()));
                }
            });
        }
    }

    @Override
    public void corruptedRiteEffect(Level level, BlockPos pos, int height) {
        if (!level.f_46443_) {
            this.getNearbyEntities(Player.class, level, pos, false).forEach(e -> {
                if (e.m_21124_((MobEffect)EffectRegistry.CORRUPTED_AERIAL_AURA.get()) == null) {
                    PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> e), (Object)new MagicParticlePacket(SpiritTypeRegistry.AERIAL_SPIRIT_COLOR, e.m_142538_().m_123341_(), (float)e.m_142538_().m_123342_() + e.m_20206_() / 2.0f, e.m_142538_().m_123343_()));
                }
                e.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.CORRUPTED_AERIAL_AURA.get(), 100, 40));
            });
        }
    }
}

