/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite;

import com.sammy.malum.common.blockentity.totem.TotemBaseTileEntity;
import com.sammy.malum.common.blockentity.totem.TotemPoleTileEntity;
import com.sammy.malum.common.recipe.BlockTransmutationRecipe;
import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import com.sammy.malum.core.setup.content.block.BlockRegistry;
import com.sammy.malum.core.systems.rites.MalumRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.ortus.helpers.BlockHelper;
import com.sammy.ortus.setup.OrtusParticles;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public class ArcaneRiteType
extends MalumRiteType {
    public ArcaneRiteType() {
        super("arcane_rite", SpiritTypeRegistry.ARCANE_SPIRIT, SpiritTypeRegistry.ARCANE_SPIRIT, SpiritTypeRegistry.ARCANE_SPIRIT, SpiritTypeRegistry.ARCANE_SPIRIT, SpiritTypeRegistry.ARCANE_SPIRIT);
    }

    @Override
    public boolean isInstant(boolean corrupted) {
        return !corrupted;
    }

    @Override
    public int interval(boolean corrupted) {
        return this.defaultInterval() * 5;
    }

    @Override
    public int range(boolean corrupted) {
        return this.defaultRange() / 4;
    }

    @Override
    public void riteEffect(Level level, BlockPos pos, int height) {
        if (level.f_46443_) {
            return;
        }
        for (int i = 1; i <= 5; ++i) {
            BlockPos totemPos = pos.m_6630_(i);
            BlockEntity blockEntity = level.m_7702_(totemPos);
            if (!(blockEntity instanceof TotemPoleTileEntity)) continue;
            TotemPoleTileEntity totemPoleTile = (TotemPoleTileEntity)blockEntity;
            MalumSpiritType type = totemPoleTile.f_58855_;
            BlockState state = BlockHelper.setBlockStateWithExistingProperties((Level)level, (BlockPos)totemPos, (BlockState)((Block)BlockRegistry.SOULWOOD_TOTEM_POLE.get()).m_49966_(), (int)3);
            TotemPoleTileEntity newTileEntity = new TotemPoleTileEntity(totemPos, state);
            newTileEntity.m_142339_(level);
            newTileEntity.create(type);
            level.m_151523_((BlockEntity)newTileEntity);
            level.m_46597_(totemPos, state);
            level.m_46796_(2001, totemPos, Block.m_49956_((BlockState)state));
        }
        BlockState state = BlockHelper.setBlockStateWithExistingProperties((Level)level, (BlockPos)pos, (BlockState)((Block)BlockRegistry.SOULWOOD_TOTEM_BASE.get()).m_49966_(), (int)3);
        level.m_151523_((BlockEntity)new TotemBaseTileEntity(pos, state));
        level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
    }

    @Override
    public void corruptedRiteEffect(Level level, BlockPos pos, int height) {
        BlockState filter = level.m_8055_(pos.m_7495_());
        BlockTransmutationRecipe fillerRecipe = BlockTransmutationRecipe.getRecipe(level, filter.m_60734_());
        ArrayList<BlockPos> positions = this.getNearbyBlocks(Block.class, level, pos.m_6630_(2), 3, false);
        positions.removeIf(p -> {
            if (p.m_123341_() == pos.m_123341_() && p.m_123343_() == pos.m_123343_()) {
                return true;
            }
            BlockState state = level.m_8055_(p);
            return fillerRecipe != null && !filter.m_60795_() && !filter.m_60713_(state.m_60734_());
        });
        positions.forEach(p -> {
            BlockState state = level.m_8055_(p);
            BlockTransmutationRecipe recipe = BlockTransmutationRecipe.getRecipe(level, state.m_60734_());
            if (recipe != null) {
                if (!level.f_46443_) {
                    Block block = recipe.output;
                    BlockEntity entity = level.m_7702_(p);
                    BlockState newState = BlockHelper.setBlockStateWithExistingProperties((Level)level, (BlockPos)p, (BlockState)block.m_49966_(), (int)3);
                    level.m_46796_(2001, p, Block.m_49956_((BlockState)newState));
                    if (block instanceof EntityBlock) {
                        BlockEntity newEntity;
                        EntityBlock entityBlock = (EntityBlock)block;
                        if (entity != null && (newEntity = entityBlock.m_142194_(pos, newState)) != null && newEntity.getClass().equals(entity.getClass())) {
                            level.m_151523_(entity);
                        }
                    }
                } else {
                    this.particles(level, (BlockPos)p);
                }
            }
        });
    }

    public void particles(Level level, BlockPos pos) {
        Color color = SpiritTypeRegistry.ARCANE_SPIRIT_COLOR;
        ParticleBuilders.create((RegistryObject)OrtusParticles.TWINKLE_PARTICLE).setAlpha(0.4f, 0.0f).setLifetime(20).setSpin(0.3f).setScale(0.2f, 0.0f).setColor(color, color).enableNoClip().randomOffset((double)0.1f, (double)0.1f).randomMotion((double)0.001f, (double)0.001f).evenlyRepeatEdges(level, pos, 4, new Direction[]{Direction.UP, Direction.DOWN});
        ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(0.1f, 0.0f).setLifetime(40).setSpin(0.1f).setScale(0.6f, 0.0f).setColor(color, color).randomOffset((double)0.2f).enableNoClip().randomMotion((double)0.001f, (double)0.001f).evenlyRepeatEdges(level, pos, 6, new Direction[]{Direction.UP, Direction.DOWN});
    }
}

