/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritaffinity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector4f;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.capability.PlayerDataCapability;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.core.setup.content.AttributeRegistry;
import com.sammy.malum.core.setup.content.SoundRegistry;
import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import com.sammy.malum.core.systems.spirit.MalumSpiritAffinity;
import com.sammy.ortus.helpers.RenderHelper;
import com.sammy.ortus.setup.OrtusShaders;
import com.sammy.ortus.systems.rendering.ExtendedShaderInstance;
import com.sammy.ortus.systems.rendering.ShaderHolder;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class EarthenAffinity
extends MalumSpiritAffinity {
    public EarthenAffinity() {
        super(SpiritTypeRegistry.EARTHEN_SPIRIT);
    }

    public static void recoverHeartOfStone(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        PlayerDataCapability.getCapability(player).ifPresent(c -> {
            AttributeInstance cap = player.m_21051_((Attribute)AttributeRegistry.HEART_OF_STONE_CAP.get());
            if (cap != null) {
                if ((double)c.heartOfStone < cap.m_22135_() && c.heartOfStoneProgress <= 0.0f) {
                    float hungerCost = EarthenAffinity.getHeartOfStoneHungerCost(player);
                    FoodData data = player.m_36324_();
                    if ((float)data.m_38702_() > hungerCost) {
                        data.m_38703_(hungerCost);
                        c.heartOfStone += 1.0f;
                        c.heartOfStoneProgress = EarthenAffinity.getHeartOfStoneCooldown(player);
                        if (player.f_19853_.f_46443_ && !player.m_7500_()) {
                            player.m_5496_((SoundEvent)SoundRegistry.HEART_OF_STONE_GROW.get(), 1.0f, Mth.m_14068_((Random)player.m_21187_(), (float)0.4f, (float)1.2f));
                        }
                    }
                } else {
                    c.heartOfStoneProgress -= 1.0f;
                }
                if ((double)c.heartOfStone > cap.m_22135_()) {
                    c.heartOfStone = (float)cap.m_22135_();
                }
            }
        });
    }

    public static void consumeHeartOfStone(LivingHurtEvent event) {
        if (event.isCanceled() || event.getAmount() <= 0.0f) {
            return;
        }
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.f_19853_.f_46443_) {
                PlayerDataCapability.getCapability(player).ifPresent(c -> {
                    if (c.heartOfStone > 0.0f) {
                        float absorbed = Math.min(event.getAmount(), c.heartOfStone);
                        AttributeInstance strength = player.m_21051_((Attribute)AttributeRegistry.HEART_OF_STONE_STRENGTH.get());
                        if (strength != null) {
                            c.heartOfStone = strength.m_22135_() != 0.0 ? (float)Math.max(0.0, (double)c.heartOfStone - (double)absorbed / strength.m_22135_()) : 0.0f;
                            c.heartOfStoneProgress = EarthenAffinity.getHeartOfStoneCooldown(player) * 2;
                            player.f_19853_.m_5594_(null, player.m_142538_(), (SoundEvent)SoundRegistry.HEART_OF_STONE_HIT.get(), SoundSource.PLAYERS, 1.0f, Mth.m_14068_((Random)player.m_21187_(), (float)1.5f, (float)2.0f));
                            event.setAmount(event.getAmount() - absorbed);
                            PlayerDataCapability.syncTrackingAndSelf(player);
                        }
                    }
                });
            }
        }
    }

    public static int getHeartOfStoneHungerCost(Player player) {
        return (int)((Double)CommonConfig.HEART_OF_STONE_COST.getConfigValue() * player.m_21133_((Attribute)AttributeRegistry.HEART_OF_STONE_COST.get()));
    }

    public static int getHeartOfStoneCooldown(Player player) {
        return (int)((double)((Integer)CommonConfig.HEART_OF_STONE_RATE.getConfigValue()).intValue() * Math.exp(-0.2 * player.m_21133_((Attribute)AttributeRegistry.HEART_OF_STONE_RECOVERY_SPEED.get())));
    }

    public static class ClientOnly {
        private static final ResourceLocation ICONS_TEXTURE = MalumMod.prefix("textures/gui/icons.png");

        public static void renderHeartOfStone(RenderGameOverlayEvent.Post event) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && !player.m_7500_() && !player.m_5833_()) {
                PlayerDataCapability.getCapability((Player)player).ifPresent(c -> {
                    PoseStack poseStack = event.getMatrixStack();
                    float absorb = Mth.m_14167_((float)player.m_6103_());
                    float maxHealth = (float)player.m_21051_(Attributes.f_22276_).m_22135_();
                    int left = event.getWindow().m_85445_() / 2 - 91;
                    int top = event.getWindow().m_85446_() - ((ForgeIngameGui)Minecraft.m_91087_().f_91065_).left_height;
                    int healthRows = Mth.m_14167_((float)((maxHealth + absorb) / 2.0f / 10.0f));
                    int rowHeight = Math.max(10 - (healthRows - 2), 3);
                    poseStack.m_85836_();
                    RenderSystem.m_69458_((boolean)false);
                    RenderSystem.m_69478_();
                    RenderSystem.m_69453_();
                    RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS_TEXTURE);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)OrtusShaders.DISTORTED_TEXTURE.getInstance().get();
                    shaderInstance.m_173356_("YFrequency").m_5985_(35.0f);
                    shaderInstance.m_173356_("XFrequency").m_5985_(25.0f);
                    shaderInstance.m_173356_("Speed").m_5985_(1000.0f);
                    shaderInstance.m_173356_("Intensity").m_5985_(500.0f);
                    int i = 0;
                    while ((double)i < Math.ceil(c.heartOfStone / 3.0f)) {
                        int row = (int)(Math.ceil(i) / 10.0);
                        int x = left + i % 10 * 8;
                        int y = top - row * 3 + rowHeight * 2 - 5;
                        int progress = (int)Math.min(3.0f, c.heartOfStone - (float)(i * 3));
                        int xTextureOffset = 1 + (3 - progress) * 15;
                        shaderInstance.m_173356_("UVCoordinates").m_142558_(new Vector4f((float)xTextureOffset / 256.0f, (float)(xTextureOffset + 12) / 256.0f, 0.00390625f, 0.046875f));
                        shaderInstance.m_173356_("TimeOffset").m_5985_((float)i * 250.0f);
                        RenderHelper.blit((PoseStack)poseStack, (ShaderHolder)OrtusShaders.DISTORTED_TEXTURE, (int)(x - 2), (int)(y - 2), (double)13.0, (double)13.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)xTextureOffset, (float)1.0f, (float)256.0f);
                        ++i;
                    }
                    shaderInstance.setUniformDefaults();
                    RenderSystem.m_69458_((boolean)true);
                    RenderSystem.m_69461_();
                    poseStack.m_85849_();
                });
            }
        }
    }
}

