/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritaffinity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector4f;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.capability.PlayerDataCapability;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.core.setup.content.AttributeRegistry;
import com.sammy.malum.core.setup.content.DamageSourceRegistry;
import com.sammy.malum.core.setup.content.SoundRegistry;
import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import com.sammy.malum.core.setup.content.item.ItemRegistry;
import com.sammy.malum.core.systems.spirit.MalumSpiritAffinity;
import com.sammy.ortus.handlers.ScreenParticleHandler;
import com.sammy.ortus.helpers.CurioHelper;
import com.sammy.ortus.helpers.RenderHelper;
import com.sammy.ortus.setup.OrtusScreenParticles;
import com.sammy.ortus.setup.OrtusShaders;
import com.sammy.ortus.systems.rendering.ExtendedShaderInstance;
import com.sammy.ortus.systems.rendering.ShaderHolder;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import com.sammy.ortus.systems.rendering.particle.screen.ScreenParticleType;
import com.sammy.ortus.systems.rendering.particle.screen.base.ScreenParticle;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ArcaneAffinity
extends MalumSpiritAffinity {
    public ArcaneAffinity() {
        super(SpiritTypeRegistry.ARCANE_SPIRIT);
    }

    public static void recoverSoulWard(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        PlayerDataCapability.getCapability(player).ifPresent(c -> {
            AttributeInstance cap = player.m_21051_((Attribute)AttributeRegistry.SOUL_WARD_CAP.get());
            if (cap != null) {
                if ((double)c.soulWard < cap.m_22135_() && c.soulWardProgress <= 0.0f) {
                    c.soulWard += 1.0f;
                    if (player.f_19853_.f_46443_ && !player.m_7500_()) {
                        player.m_5496_((double)c.soulWard >= cap.m_22135_() ? (SoundEvent)SoundRegistry.SOUL_WARD_CHARGE.get() : (SoundEvent)SoundRegistry.SOUL_WARD_GROW.get(), 1.0f, Mth.m_14068_((Random)player.m_21187_(), (float)0.6f, (float)1.4f));
                    }
                    c.soulWardProgress = ArcaneAffinity.getSoulWardCooldown(player);
                } else {
                    c.soulWardProgress -= 1.0f;
                }
                if ((double)c.soulWard > cap.m_22135_()) {
                    c.soulWard = (float)cap.m_22135_();
                }
            }
        });
    }

    public static void consumeSoulWard(LivingHurtEvent event) {
        if (event.isCanceled() || event.getAmount() <= 0.0f) {
            return;
        }
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.f_19853_.f_46443_) {
                PlayerDataCapability.getCapability(player).ifPresent(c -> {
                    AttributeInstance instance = player.m_21051_((Attribute)AttributeRegistry.SOUL_WARD_SHATTER_COOLDOWN.get());
                    if (instance != null) {
                        c.soulWardProgress = (float)((double)((Integer)CommonConfig.SOUL_WARD_RATE.getConfigValue() * 6) * Math.exp(-0.15 * instance.m_22135_()));
                        if (c.soulWard > 0.0f) {
                            DamageSource source = event.getSource();
                            float amount = event.getAmount();
                            float multiplier = source.m_19387_() ? ((Double)CommonConfig.SOUL_WARD_MAGIC.getConfigValue()).floatValue() : ((Double)CommonConfig.SOUL_WARD_PHYSICAL.getConfigValue()).floatValue();
                            float result = amount * multiplier;
                            float absorbed = amount - result;
                            double strength = player.m_21133_((Attribute)AttributeRegistry.SOUL_WARD_STRENGTH.get());
                            c.soulWard = strength != 0.0 ? (float)Math.max(0.0, (double)c.soulWard - (double)absorbed / strength) : 0.0f;
                            player.f_19853_.m_5594_(null, player.m_142538_(), (SoundEvent)SoundRegistry.SOUL_WARD_HIT.get(), SoundSource.PLAYERS, 1.0f, Mth.m_14068_((Random)player.m_21187_(), (float)1.5f, (float)2.0f));
                            event.setAmount(result);
                            if (source.m_7639_() != null && CurioHelper.hasCurioEquipped((LivingEntity)player, ItemRegistry.MAGEBANE_BELT)) {
                                EntityDamageSource entityDamageSource;
                                if (source instanceof EntityDamageSource && (entityDamageSource = (EntityDamageSource)source).m_19403_()) {
                                    return;
                                }
                                source.m_7639_().m_6469_(DamageSourceRegistry.causeMagebaneDamage((Entity)player), absorbed + 2.0f);
                            }
                            PlayerDataCapability.syncTrackingAndSelf(player);
                        }
                    }
                });
            }
        }
    }

    public static int getSoulWardCooldown(Player player) {
        return (int)((double)((Integer)CommonConfig.SOUL_WARD_RATE.getConfigValue()).intValue() * Math.exp(-0.15 * player.m_21133_((Attribute)AttributeRegistry.SOUL_WARD_RECOVERY_SPEED.get())));
    }

    public static class ClientOnly {
        private static final ResourceLocation ICONS_TEXTURE = MalumMod.prefix("textures/gui/icons.png");

        public static void renderSoulWard(RenderGameOverlayEvent.Post event) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && !player.m_7500_() && !player.m_5833_()) {
                PlayerDataCapability.getCapability((Player)player).ifPresent(c -> {
                    PoseStack poseStack = event.getMatrixStack();
                    if (c.soulWard > 0.0f) {
                        float absorb = Mth.m_14167_((float)player.m_6103_());
                        float maxHealth = (float)player.m_21051_(Attributes.f_22276_).m_22135_();
                        float armor = (float)player.m_21051_(Attributes.f_22284_).m_22135_();
                        int left = event.getWindow().m_85445_() / 2 - 91;
                        int top = event.getWindow().m_85446_() - ((ForgeIngameGui)Minecraft.m_91087_().f_91065_).left_height;
                        if (armor == 0.0f) {
                            top += 4;
                        }
                        int healthRows = Mth.m_14167_((float)((maxHealth + absorb) / 2.0f / 10.0f));
                        int rowHeight = Math.max(10 - (healthRows - 2), 3);
                        poseStack.m_85836_();
                        RenderSystem.m_69458_((boolean)false);
                        RenderSystem.m_69478_();
                        RenderSystem.m_69453_();
                        RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS_TEXTURE);
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)OrtusShaders.DISTORTED_TEXTURE.getInstance().get();
                        shaderInstance.m_173356_("YFrequency").m_5985_(15.0f);
                        shaderInstance.m_173356_("XFrequency").m_5985_(15.0f);
                        shaderInstance.m_173356_("Speed").m_5985_(550.0f);
                        shaderInstance.m_173356_("Intensity").m_5985_(600.0f);
                        int i = 0;
                        while ((double)i < Math.ceil(c.soulWard / 3.0f)) {
                            int row = (int)(Math.ceil(i) / 10.0);
                            int x = left + i % 10 * 8;
                            int y = top - row * 4 + rowHeight * 2 - 15;
                            int progress = Math.min(3, (int)c.soulWard - i * 3);
                            int xTextureOffset = 1 + (3 - progress) * 15;
                            shaderInstance.m_173356_("UVCoordinates").m_142558_(new Vector4f((float)xTextureOffset / 256.0f, (float)(xTextureOffset + 12) / 256.0f, 0.0625f, 0.109375f));
                            shaderInstance.m_173356_("TimeOffset").m_5985_((float)i * 150.0f);
                            RenderHelper.blit((PoseStack)poseStack, (ShaderHolder)OrtusShaders.DISTORTED_TEXTURE, (int)(x - 2), (int)(y - 2), (double)13.0, (double)13.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)xTextureOffset, (float)16.0f, (float)256.0f);
                            if (ScreenParticleHandler.canSpawnParticles) {
                                ParticleBuilders.create((ScreenParticleType)OrtusScreenParticles.WISP).setLifetime(20).setColor(SpiritTypeRegistry.ARCANE_SPIRIT_COLOR, SpiritTypeRegistry.ARCANE_SPIRIT.endColor).setAlphaCurveMultiplier(0.75f).setScale(0.2f * (float)progress, 0.0f).setAlpha(0.05f, 0.0f).setSpin(Minecraft.m_91087_().f_91073_.f_46441_.nextFloat() * 6.28f).setSpinOffset(Minecraft.m_91087_().f_91073_.f_46441_.nextFloat() * 6.28f).randomOffset(2.0).randomMotion(0.5, 0.5).overwriteRenderOrder(ScreenParticle.RenderOrder.BEFORE_UI).repeat((double)(x + 5), (double)(y + 5), 1);
                            }
                            ++i;
                        }
                        shaderInstance.setUniformDefaults();
                        RenderSystem.m_69458_((boolean)true);
                        RenderSystem.m_69461_();
                        poseStack.m_85849_();
                    }
                });
            }
        }
    }
}

