/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe.vanilla;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.sammy.malum.core.setup.content.RecipeSerializerRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class NBTCarryRecipe
extends CustomRecipe
implements IShapedRecipe<CraftingContainer> {
    public static final String NAME = "nbt_carry";
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    public final int recipeWidth;
    public final int recipeHeight;
    public final Ingredient nbtCarry;
    public final NonNullList<Ingredient> recipeItems;
    public final ItemStack recipeOutput;
    public final String group;

    public NBTCarryRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, Ingredient nbtCarry, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(idIn);
        this.group = groupIn;
        this.recipeWidth = recipeWidthIn;
        this.recipeHeight = recipeHeightIn;
        this.nbtCarry = nbtCarry;
        this.recipeItems = recipeItemsIn;
        this.recipeOutput = recipeOutputIn;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.NBT_CARRY_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public boolean matches(CraftingContainer inv, Level level) {
        for (int i = 0; i <= inv.m_39347_() - this.recipeWidth; ++i) {
            for (int j = 0; j <= inv.m_39346_() - this.recipeHeight; ++j) {
                if (this.checkMatch(inv, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(CraftingContainer craftingInventory, int width, int height, boolean p_77573_4_) {
        for (int i = 0; i < craftingInventory.m_39347_(); ++i) {
            for (int j = 0; j < craftingInventory.m_39346_(); ++j) {
                int k = i - width;
                int l = j - height;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.recipeWidth && l < this.recipeHeight) {
                    ingredient = p_77573_4_ ? (Ingredient)this.recipeItems.get(this.recipeWidth - k - 1 + l * this.recipeWidth) : (Ingredient)this.recipeItems.get(k + l * this.recipeWidth);
                }
                if (ingredient.test(craftingInventory.m_8020_(i + j * craftingInventory.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack stack = this.recipeOutput.m_41777_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack oldStack = inv.m_8020_(i);
            if (!this.nbtCarry.test(oldStack) || !oldStack.m_41782_()) continue;
            stack.m_41751_(oldStack.m_41783_());
        }
        return stack;
    }

    public boolean m_5598_() {
        return false;
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_() {
        return this.recipeOutput;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.recipeWidth && height >= this.recipeHeight;
    }

    public int getRecipeWidth() {
        return this.recipeWidth;
    }

    public int getRecipeHeight() {
        return this.recipeHeight;
    }

    private static NonNullList<Ingredient> deserializeIngredients(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)(patternWidth * patternHeight), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < toShrink.length; ++i1) {
            String s = toShrink[i1];
            i = Math.min(i, NBTCarryRecipe.firstNonSpace(s));
            int j1 = NBTCarryRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[toShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = toShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] patternFromJson(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    private static Map<String, Ingredient> deserializeKey(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static ItemStack deserializeItem(JsonObject object) {
        String s = GsonHelper.m_13906_((JsonObject)object, (String)"item");
        Registry.f_122827_.m_6612_(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1);
        return CraftingHelper.getItemStack((JsonObject)object, (boolean)true);
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<NBTCarryRecipe> {
        public NBTCarryRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Map<String, Ingredient> map = NBTCarryRecipe.deserializeKey(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] astring = NBTCarryRecipe.shrink(NBTCarryRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList<Ingredient> nonnulllist = NBTCarryRecipe.deserializeIngredients(astring, map, i, j);
            Ingredient nbtCarry = Ingredient.m_43917_((JsonElement)json.get("nbtCarry"));
            ItemStack itemstack = NBTCarryRecipe.deserializeItem(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new NBTCarryRecipe(recipeId, s, i, j, nbtCarry, nonnulllist, itemstack);
        }

        public NBTCarryRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            int j = buffer.m_130242_();
            String s = buffer.m_130136_(Short.MAX_VALUE);
            NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            Ingredient nbtCarry = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack itemstack = buffer.m_130267_();
            return new NBTCarryRecipe(recipeId, s, i, j, nbtCarry, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public void toNetwork(FriendlyByteBuf buffer, NBTCarryRecipe recipe) {
            buffer.m_130130_(recipe.recipeWidth);
            buffer.m_130130_(recipe.recipeHeight);
            buffer.m_130070_(recipe.group);
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(buffer);
            }
            recipe.nbtCarry.m_43923_(buffer);
            buffer.m_130055_(recipe.recipeOutput);
        }
    }
}

