/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.sammy.malum.core.setup.content.RecipeSerializerRegistry;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.ortus.systems.recipe.IOrtusRecipe;
import com.sammy.ortus.systems.recipe.IngredientWithCount;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SpiritInfusionRecipe
extends IOrtusRecipe {
    public static final String NAME = "spirit_infusion";
    private final ResourceLocation id;
    public final IngredientWithCount input;
    public final IngredientWithCount output;
    public final ArrayList<SpiritWithCount> spirits;
    public final ArrayList<IngredientWithCount> extraItems;

    public SpiritInfusionRecipe(ResourceLocation id, IngredientWithCount input, IngredientWithCount output, ArrayList<SpiritWithCount> spirits, ArrayList<IngredientWithCount> extraItems) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.spirits = spirits;
        this.extraItems = extraItems;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.INFUSION_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ArrayList<ItemStack> getSortedSpirits(ArrayList<ItemStack> stacks) {
        ArrayList<ItemStack> sortedStacks = new ArrayList<ItemStack>();
        block0: for (SpiritWithCount item : this.spirits) {
            for (ItemStack stack : stacks) {
                if (!item.matches(stack)) continue;
                sortedStacks.add(stack);
                continue block0;
            }
        }
        return sortedStacks;
    }

    public boolean doSpiritsMatch(ArrayList<ItemStack> spirits) {
        if (this.spirits.size() == 0) {
            return true;
        }
        if (this.spirits.size() != spirits.size()) {
            return false;
        }
        ArrayList<ItemStack> sortedStacks = this.getSortedSpirits(spirits);
        if (sortedStacks.size() < this.spirits.size()) {
            return false;
        }
        for (int i = 0; i < this.spirits.size(); ++i) {
            ItemStack stack;
            SpiritWithCount item = this.spirits.get(i);
            if (item.matches(stack = sortedStacks.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean doesInputMatch(ItemStack input) {
        return this.input.matches(input);
    }

    public boolean doesOutputMatch(ItemStack output) {
        return this.output.ingredient.test(output);
    }

    public static SpiritInfusionRecipe getRecipe(Level level, ItemStack stack, ArrayList<ItemStack> spirits) {
        return SpiritInfusionRecipe.getRecipe(level, c -> c.doesInputMatch(stack) && c.doSpiritsMatch(spirits));
    }

    public static SpiritInfusionRecipe getRecipe(Level level, Predicate<SpiritInfusionRecipe> predicate) {
        List<SpiritInfusionRecipe> recipes = SpiritInfusionRecipe.getRecipes(level);
        for (SpiritInfusionRecipe recipe : recipes) {
            if (!predicate.test(recipe)) continue;
            return recipe;
        }
        return null;
    }

    public static List<SpiritInfusionRecipe> getRecipes(Level level) {
        return level.m_7465_().m_44013_((RecipeType)Type.INSTANCE);
    }

    public static class Type
    implements RecipeType<SpiritInfusionRecipe> {
        public static final Type INSTANCE = new Type();

        public String toString() {
            return "malum:spirit_infusion";
        }
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<SpiritInfusionRecipe> {
        public SpiritInfusionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputObject = json.getAsJsonObject("input");
            IngredientWithCount input = IngredientWithCount.deserialize((JsonObject)inputObject);
            JsonObject outputObject = json.getAsJsonObject("output");
            IngredientWithCount output = IngredientWithCount.deserialize((JsonObject)outputObject);
            JsonArray extraItemsArray = json.getAsJsonArray("extra_items");
            ArrayList<IngredientWithCount> extraItems = new ArrayList<IngredientWithCount>();
            for (int i = 0; i < extraItemsArray.size(); ++i) {
                JsonObject extraItemObject = extraItemsArray.get(i).getAsJsonObject();
                extraItems.add(IngredientWithCount.deserialize((JsonObject)extraItemObject));
            }
            JsonArray spiritsArray = json.getAsJsonArray("spirits");
            ArrayList<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
            for (int i = 0; i < spiritsArray.size(); ++i) {
                JsonObject spiritObject = spiritsArray.get(i).getAsJsonObject();
                spirits.add(SpiritWithCount.deserialize(spiritObject));
            }
            if (spirits.isEmpty()) {
                return null;
            }
            return new SpiritInfusionRecipe(recipeId, input, output, spirits, extraItems);
        }

        @Nullable
        public SpiritInfusionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            IngredientWithCount input = IngredientWithCount.read((FriendlyByteBuf)buffer);
            IngredientWithCount output = IngredientWithCount.read((FriendlyByteBuf)buffer);
            int extraItemCount = buffer.readInt();
            ArrayList<IngredientWithCount> extraItems = new ArrayList<IngredientWithCount>();
            for (int i = 0; i < extraItemCount; ++i) {
                extraItems.add(IngredientWithCount.read((FriendlyByteBuf)buffer));
            }
            int spiritCount = buffer.readInt();
            ArrayList<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
            for (int i = 0; i < spiritCount; ++i) {
                spirits.add(new SpiritWithCount(buffer.m_130267_()));
            }
            return new SpiritInfusionRecipe(recipeId, input, output, spirits, extraItems);
        }

        public void toNetwork(FriendlyByteBuf buffer, SpiritInfusionRecipe recipe) {
            recipe.input.write(buffer);
            recipe.output.write(buffer);
            buffer.writeInt(recipe.extraItems.size());
            for (IngredientWithCount ingredientWithCount : recipe.extraItems) {
                ingredientWithCount.write(buffer);
            }
            buffer.writeInt(recipe.spirits.size());
            for (SpiritWithCount spiritWithCount : recipe.spirits) {
                buffer.m_130055_(spiritWithCount.getStack());
            }
        }
    }
}

