/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.core.setup.content.RecipeSerializerRegistry;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.ortus.systems.recipe.IOrtusRecipe;
import com.sammy.ortus.systems.recipe.IngredientWithCount;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SpiritFocusingRecipe
extends IOrtusRecipe {
    public static final String NAME = "spirit_focusing";
    private final ResourceLocation id;
    public final int time;
    public final int durabilityCost;
    public final Ingredient input;
    public final IngredientWithCount output;
    public final ArrayList<SpiritWithCount> spirits;

    public SpiritFocusingRecipe(ResourceLocation id, int time, int durabilityCost, Ingredient input, IngredientWithCount output, ArrayList<SpiritWithCount> spirits) {
        this.id = id;
        this.time = time;
        this.durabilityCost = durabilityCost;
        this.input = input;
        this.output = output;
        this.spirits = spirits;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.FOCUSING_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ArrayList<ItemStack> getSortedSpirits(ArrayList<ItemStack> stacks) {
        ArrayList<ItemStack> sortedStacks = new ArrayList<ItemStack>();
        block0: for (SpiritWithCount item : this.spirits) {
            for (ItemStack stack : stacks) {
                if (!item.matches(stack)) continue;
                sortedStacks.add(stack);
                continue block0;
            }
        }
        return sortedStacks;
    }

    public boolean doSpiritsMatch(ArrayList<ItemStack> spirits) {
        if (this.spirits.size() == 0) {
            return true;
        }
        if (this.spirits.size() != spirits.size()) {
            return false;
        }
        ArrayList<ItemStack> sortedStacks = this.getSortedSpirits(spirits);
        if (sortedStacks.size() < this.spirits.size()) {
            return false;
        }
        for (int i = 0; i < this.spirits.size(); ++i) {
            ItemStack stack;
            SpiritWithCount item = this.spirits.get(i);
            if (item.matches(stack = sortedStacks.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean doesInputMatch(ItemStack input) {
        return this.input.test(input);
    }

    public boolean doesOutputMatch(ItemStack output) {
        return this.output.ingredient.test(output);
    }

    public static SpiritFocusingRecipe getRecipe(Level level, ItemStack stack, ArrayList<ItemStack> spirits) {
        return SpiritFocusingRecipe.getRecipe(level, c -> c.doesInputMatch(stack) && c.doSpiritsMatch(spirits));
    }

    public static SpiritFocusingRecipe getRecipe(Level level, Predicate<SpiritFocusingRecipe> predicate) {
        List<SpiritFocusingRecipe> recipes = SpiritFocusingRecipe.getRecipes(level);
        for (SpiritFocusingRecipe recipe : recipes) {
            if (!predicate.test(recipe)) continue;
            return recipe;
        }
        return null;
    }

    public static List<SpiritFocusingRecipe> getRecipes(Level level) {
        return level.m_7465_().m_44013_((RecipeType)Type.INSTANCE);
    }

    public static class Type
    implements RecipeType<SpiritFocusingRecipe> {
        public static final Type INSTANCE = new Type();

        public String toString() {
            return "malum:spirit_focusing";
        }
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<SpiritFocusingRecipe> {
        public SpiritFocusingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int time = json.getAsJsonPrimitive("time").getAsInt();
            int durabilityCost = json.getAsJsonPrimitive("durabilityCost").getAsInt();
            JsonObject inputObject = json.getAsJsonObject("input");
            Ingredient input = Ingredient.m_43917_((JsonElement)inputObject);
            JsonObject outputObject = json.getAsJsonObject("output");
            IngredientWithCount output = IngredientWithCount.deserialize((JsonObject)outputObject);
            JsonArray spiritsArray = json.getAsJsonArray("spirits");
            ArrayList<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
            for (int i = 0; i < spiritsArray.size(); ++i) {
                JsonObject spiritObject = spiritsArray.get(i).getAsJsonObject();
                spirits.add(SpiritWithCount.deserialize(spiritObject));
            }
            if (spirits.isEmpty()) {
                return null;
            }
            return new SpiritFocusingRecipe(recipeId, time, durabilityCost, input, output, spirits);
        }

        @Nullable
        public SpiritFocusingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int time = buffer.readInt();
            int durabilityCost = buffer.readInt();
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            IngredientWithCount output = IngredientWithCount.read((FriendlyByteBuf)buffer);
            int spiritCount = buffer.readInt();
            ArrayList<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();
            for (int i = 0; i < spiritCount; ++i) {
                spirits.add(new SpiritWithCount(buffer.m_130267_()));
            }
            return new SpiritFocusingRecipe(recipeId, time, durabilityCost, input, output, spirits);
        }

        public void toNetwork(FriendlyByteBuf buffer, SpiritFocusingRecipe recipe) {
            buffer.writeInt(recipe.time);
            buffer.writeInt(recipe.durabilityCost);
            recipe.input.m_43923_(buffer);
            recipe.output.write(buffer);
            buffer.writeInt(recipe.spirits.size());
            for (SpiritWithCount item : recipe.spirits) {
                buffer.m_130055_(item.getStack());
            }
        }
    }
}

