/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.google.gson.JsonObject;
import com.sammy.malum.core.setup.content.RecipeSerializerRegistry;
import com.sammy.ortus.systems.recipe.IOrtusRecipe;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BlockTransmutationRecipe
extends IOrtusRecipe {
    public static final String NAME = "block_transmutation";
    private final ResourceLocation id;
    public final Block input;
    public final Block output;

    public BlockTransmutationRecipe(ResourceLocation id, Block input, Block output) {
        this.id = id;
        this.input = input;
        this.output = output;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.BLOCK_TRANSMUTATION_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean doesInputMatch(Block input) {
        return input.equals(this.input);
    }

    public boolean doesOutputMatch(Block output) {
        return output.equals(this.output);
    }

    public static BlockTransmutationRecipe getRecipe(Level level, Block block) {
        List<BlockTransmutationRecipe> recipes = BlockTransmutationRecipe.getRecipes(level);
        for (BlockTransmutationRecipe recipe : recipes) {
            if (!recipe.doesInputMatch(block)) continue;
            return recipe;
        }
        return null;
    }

    public static List<BlockTransmutationRecipe> getRecipes(Level level) {
        return level.m_7465_().m_44013_((RecipeType)Type.INSTANCE);
    }

    public static class Type
    implements RecipeType<BlockTransmutationRecipe> {
        public static final Type INSTANCE = new Type();

        public String toString() {
            return "malum:block_transmutation";
        }
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<BlockTransmutationRecipe> {
        public BlockTransmutationRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String input = json.getAsJsonPrimitive("input").getAsString();
            String output = json.getAsJsonPrimitive("output").getAsString();
            return new BlockTransmutationRecipe(recipeId, (Block)Registry.f_122824_.m_7745_(new ResourceLocation(input)), (Block)Registry.f_122824_.m_7745_(new ResourceLocation(output)));
        }

        @Nullable
        public BlockTransmutationRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            BlockState input = Block.m_49803_((int)buffer.m_130242_());
            BlockState output = Block.m_49803_((int)buffer.m_130242_());
            return new BlockTransmutationRecipe(recipeId, input.m_60734_(), output.m_60734_());
        }

        public void toNetwork(FriendlyByteBuf buffer, BlockTransmutationRecipe recipe) {
            buffer.m_130130_(Block.m_49956_((BlockState)recipe.input.m_49966_()));
            buffer.m_130130_(Block.m_49956_((BlockState)recipe.output.m_49966_()));
        }
    }
}

