/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets.particle.altar;

import com.sammy.malum.core.helper.SpiritHelper;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.ortus.setup.OrtusParticles;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.RegistryObject;

public class AltarCraftParticlePacket {
    private final List<String> spirits;
    private final double posX;
    private final double posY;
    private final double posZ;

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, AltarCraftParticlePacket.class, AltarCraftParticlePacket::encode, AltarCraftParticlePacket::decode, AltarCraftParticlePacket::execute);
    }

    public AltarCraftParticlePacket(List<String> spirits, double posX, double posY, double posZ) {
        this.spirits = spirits;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public static AltarCraftParticlePacket decode(FriendlyByteBuf buf) {
        int strings = buf.readInt();
        ArrayList<String> spirits = new ArrayList<String>();
        for (int i = 0; i < strings; ++i) {
            spirits.add(buf.m_130277_());
        }
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        return new AltarCraftParticlePacket(spirits, posX, posY, posZ);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.spirits.size());
        for (String string : this.spirits) {
            buf.m_130070_(string);
        }
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public void execute(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientOnly.addParticles(this.spirits, this.posX, this.posY, this.posZ));
        context.get().setPacketHandled(true);
    }

    public static class ClientOnly {
        public static void addParticles(List<String> spirits, double posX, double posY, double posZ) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            ArrayList<MalumSpiritType> types = new ArrayList<MalumSpiritType>();
            for (String string : spirits) {
                types.add(SpiritHelper.getSpiritType(string));
            }
            for (MalumSpiritType type : types) {
                Color color = type.color;
                Color endColor = type.endColor;
                ParticleBuilders.create((RegistryObject)OrtusParticles.TWINKLE_PARTICLE).setAlpha(0.6f, 0.0f).setLifetime(80).setScale(0.15f, 0.0f).setColor(color, endColor).randomOffset((double)0.1f).addMotion(0.0, (double)0.26f, 0.0).randomMotion((double)0.03f, (double)0.04f).enableGravity().repeat((Level)level, posX, posY, posZ, 32);
                ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(0.2f, 0.0f).setLifetime(60).setScale(0.4f, 0.0f).setColor(color, endColor).randomOffset(0.25, (double)0.1f).randomMotion((double)0.004f, (double)0.004f).enableNoClip().repeat((Level)level, posX, posY, posZ, 12);
                ParticleBuilders.create((RegistryObject)OrtusParticles.SPARKLE_PARTICLE).setAlpha(0.05f, 0.0f).setLifetime(30).setScale(0.2f, 0.0f).setColor(color, endColor).randomOffset((double)0.05f, (double)0.05f).randomMotion((double)0.02f, (double)0.02f).enableNoClip().repeat((Level)level, posX, posY, posZ, 8);
            }
        }
    }
}

