/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets.particle.altar;

import com.sammy.malum.core.helper.SpiritHelper;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.ortus.setup.OrtusParticles;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.RegistryObject;

public class AltarConsumeParticlePacket {
    private final ItemStack stack;
    private final List<String> spirits;
    private final double posX;
    private final double posY;
    private final double posZ;
    private final double altarPosX;
    private final double altarPosY;
    private final double altarPosZ;

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, AltarConsumeParticlePacket.class, AltarConsumeParticlePacket::encode, AltarConsumeParticlePacket::decode, AltarConsumeParticlePacket::execute);
    }

    public AltarConsumeParticlePacket(ItemStack stack, List<String> spirits, double posX, double posY, double posZ, double altarPosX, double altarPosY, double altarPosZ) {
        this.stack = stack;
        this.spirits = spirits;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.altarPosX = altarPosX;
        this.altarPosY = altarPosY;
        this.altarPosZ = altarPosZ;
    }

    public static AltarConsumeParticlePacket decode(FriendlyByteBuf buf) {
        ItemStack stack = buf.m_130267_();
        int strings = buf.readInt();
        ArrayList<String> spirits = new ArrayList<String>();
        for (int i = 0; i < strings; ++i) {
            spirits.add(buf.m_130277_());
        }
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        double altarPosX = buf.readDouble();
        double altarPosY = buf.readDouble();
        double altarPosZ = buf.readDouble();
        return new AltarConsumeParticlePacket(stack, spirits, posX, posY, posZ, altarPosX, altarPosY, altarPosZ);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130055_(this.stack);
        buf.writeInt(this.spirits.size());
        for (String string : this.spirits) {
            buf.m_130070_(string);
        }
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(this.altarPosX);
        buf.writeDouble(this.altarPosY);
        buf.writeDouble(this.altarPosZ);
    }

    public void execute(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientOnly.addParticles(this.stack, this.spirits, this.posX, this.posY, this.posZ, this.altarPosX, this.altarPosY, this.altarPosZ));
        context.get().setPacketHandled(true);
    }

    public static class ClientOnly {
        public static void addParticles(ItemStack stack, List<String> spirits, double posX, double posY, double posZ, double altarPosX, double altarPosY, double altarPosZ) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            ArrayList<MalumSpiritType> types = new ArrayList<MalumSpiritType>();
            for (String string : spirits) {
                types.add(SpiritHelper.getSpiritType(string));
            }
            float alpha = 0.1f / (float)types.size();
            for (MalumSpiritType type : types) {
                Color color = type.color;
                Color endColor = type.endColor;
                ParticleBuilders.create((RegistryObject)OrtusParticles.TWINKLE_PARTICLE).setAlpha(alpha * 2.0f, 0.0f).setLifetime(60).setScale(0.4f, 0.0f).setColor(color, endColor).randomOffset(0.25, (double)0.1f).randomMotion((double)0.004f, (double)0.004f).enableNoClip().repeat((Level)level, posX, posY, posZ, 12);
                ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(alpha, 0.0f).setLifetime(30).setScale(0.2f, 0.0f).setColor(color, endColor).randomOffset((double)0.05f, (double)0.05f).randomMotion((double)0.002f, (double)0.002f).enableNoClip().repeat((Level)level, posX, posY, posZ, 8);
                Vec3 velocity = new Vec3(posX, posY, posZ).m_82492_(altarPosX, altarPosY, altarPosZ).m_82541_().m_82490_((double)-0.05f);
                ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(alpha, 0.0f).setLifetime(40).setScale(0.3f, 0.0f).randomOffset((double)0.15f).randomMotion((double)0.005f, (double)0.005f).setColor(color, color.darker()).addMotion(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_).enableNoClip().repeat((Level)level, posX, posY, posZ, 36);
            }
        }
    }
}

