/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets.particle;

import com.sammy.malum.common.packets.particle.BlockParticlePacket;
import java.awt.Color;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class TotemParticlePacket {
    private final ArrayList<Color> colors;
    private final int posX;
    private final int posY;
    private final int posZ;

    public TotemParticlePacket(ArrayList<Color> colors, int posX, int posY, int posZ) {
        this.colors = colors;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, TotemParticlePacket.class, TotemParticlePacket::encode, TotemParticlePacket::decode, TotemParticlePacket::execute);
    }

    public static TotemParticlePacket decode(FriendlyByteBuf buf) {
        ArrayList<Color> colors = new ArrayList<Color>();
        int colorCount = buf.readInt();
        for (int i = 0; i < colorCount; ++i) {
            Color color = new Color(buf.readInt(), buf.readInt(), buf.readInt());
            colors.add(color);
        }
        int posX = buf.readInt();
        int posY = buf.readInt();
        int posZ = buf.readInt();
        return new TotemParticlePacket(colors, posX, posY, posZ);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.colors.size());
        for (Color color : this.colors) {
            buf.writeInt(color.getRed());
            buf.writeInt(color.getGreen());
            buf.writeInt(color.getBlue());
        }
        buf.writeInt(this.posX);
        buf.writeInt(this.posY);
        buf.writeInt(this.posZ);
    }

    public void execute(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ClientOnly.addParticles(new BlockPos(this.posX, this.posY, this.posZ), this.colors);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static class ClientOnly {
        public static void addParticles(BlockPos pos, ArrayList<Color> colors) {
            for (int i = 0; i < colors.size(); ++i) {
                BlockParticlePacket.ClientOnly.addParticles(pos.m_6630_(i), colors.get(i));
            }
        }
    }
}

