/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets.particle;

import com.sammy.ortus.setup.OrtusParticles;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.RegistryObject;

public class SoulPurgeParticlePacket {
    private final Color color;
    private final Color endColor;
    private final double posX;
    private final double posY;
    private final double posZ;

    public SoulPurgeParticlePacket(Color color, Color endColor, double posX, double posY, double posZ) {
        this.color = color;
        this.endColor = endColor;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, SoulPurgeParticlePacket.class, SoulPurgeParticlePacket::encode, SoulPurgeParticlePacket::decode, SoulPurgeParticlePacket::execute);
    }

    public static SoulPurgeParticlePacket decode(FriendlyByteBuf buf) {
        Color color = new Color(buf.readInt(), buf.readInt(), buf.readInt());
        Color endColor = new Color(buf.readInt(), buf.readInt(), buf.readInt());
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        return new SoulPurgeParticlePacket(color, endColor, posX, posY, posZ);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.color.getRed());
        buf.writeInt(this.color.getGreen());
        buf.writeInt(this.color.getBlue());
        buf.writeInt(this.endColor.getRed());
        buf.writeInt(this.endColor.getGreen());
        buf.writeInt(this.endColor.getBlue());
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public void execute(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ClientOnly.addParticles(new Vec3(this.posX, this.posY, this.posZ), this.color, this.endColor);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static class ClientOnly {
        public static void addParticles(Vec3 pos, Color color, Color endColor) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            ParticleBuilders.create((RegistryObject)OrtusParticles.SPARKLE_PARTICLE).setAlpha(1.0f, 0.0f).setScale(0.4f, 0.0f).setLifetime(20).randomOffset(0.5, 0.0).randomMotion(0.0, 0.125).addMotion(0.0, (double)0.28f, 0.0).setColor(color, endColor).setSpin(0.4f).enableGravity().repeat((Level)level, pos.f_82479_, pos.f_82480_ - (double)0.2f, pos.f_82481_, 40);
            ParticleBuilders.create((RegistryObject)OrtusParticles.SPARKLE_PARTICLE).setAlpha(0.75f, 0.0f).setScale(0.2f, 0.0f).setLifetime(40).randomOffset(0.5, 0.5).randomMotion(0.125, 0.05).addMotion(0.0, (double)0.15f, 0.0).setColor(color, endColor).setSpin(0.3f).enableGravity().repeat((Level)level, pos.f_82479_, pos.f_82480_ - (double)0.2f, pos.f_82481_, 30);
        }
    }
}

